/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.TimeUtil;

class TimeUtilTest {
    TimeUtilTest() {
    }

    @Test
    void formatNanosToString() {
        Assertions.assertEquals((Object)"1ns", (Object)TimeUtil.nanosToString((long)1L));
        Assertions.assertEquals((Object)"10ns", (Object)TimeUtil.nanosToString((long)10L));
        Assertions.assertEquals((Object)"100ns", (Object)TimeUtil.nanosToString((long)100L));
        Assertions.assertEquals((Object)"1\u03bcs", (Object)TimeUtil.nanosToString((long)1000L));
        Assertions.assertEquals((Object)"10\u03bcs100ns", (Object)TimeUtil.nanosToString((long)10100L));
        Assertions.assertEquals((Object)"101\u03bcs10ns", (Object)TimeUtil.nanosToString((long)101010L));
        Assertions.assertEquals((Object)"10ms101\u03bcs10ns", (Object)TimeUtil.nanosToString((long)10101010L));
        Assertions.assertEquals((Object)"1s20ms304\u03bcs50ns", (Object)TimeUtil.nanosToString((long)1020304050L));
        Assertions.assertEquals((Object)"1m42s30ms405\u03bcs60ns", (Object)TimeUtil.nanosToString((long)102030405060L));
        Assertions.assertEquals((Object)"2h50m3s40ms506\u03bcs70ns", (Object)TimeUtil.nanosToString((long)10203040506070L));
        Assertions.assertEquals((Object)"11d19h25m4s50ms607\u03bcs80ns", (Object)TimeUtil.nanosToString((long)1020304050607080L));
    }

    @Test
    void parseMillisFromString() {
        Assertions.assertEquals((long)0L, (Long)((Long)TimeUtil.parseTimeMillis.apply("9ns")));
        Assertions.assertEquals((long)0L, (Long)((Long)TimeUtil.parseTimeMillis.apply("9\u03bcs")));
        Assertions.assertEquals((long)0L, (Long)((Long)TimeUtil.parseTimeMillis.apply("9us")));
        Assertions.assertEquals((long)9L, (Long)((Long)TimeUtil.parseTimeMillis.apply("9ms")));
        Assertions.assertEquals((long)9000L, (Long)((Long)TimeUtil.parseTimeMillis.apply("9s")));
        Assertions.assertEquals((long)540000L, (Long)((Long)TimeUtil.parseTimeMillis.apply("9m")));
        Assertions.assertEquals((long)32400000L, (Long)((Long)TimeUtil.parseTimeMillis.apply("9h")));
        Assertions.assertEquals((long)777600000L, (Long)((Long)TimeUtil.parseTimeMillis.apply("9d")));
        Assertions.assertEquals((long)10L, (Long)((Long)TimeUtil.parseTimeMillis.apply("10ms101\u03bcs10ns")));
        Assertions.assertEquals((long)1020L, (Long)((Long)TimeUtil.parseTimeMillis.apply("1s20ms304\u03bcs50ns")));
        Assertions.assertEquals((long)102030L, (Long)((Long)TimeUtil.parseTimeMillis.apply("1m42s30ms405\u03bcs60ns")));
        Assertions.assertEquals((long)10203040L, (Long)((Long)TimeUtil.parseTimeMillis.apply("2h50m3s40ms506\u03bcs70ns")));
        Assertions.assertEquals((long)1020304050L, (Long)((Long)TimeUtil.parseTimeMillis.apply("11d19h25m4s50ms607\u03bcs80ns")));
        Assertions.assertEquals((long)5L, (Long)((Long)TimeUtil.parseTimeMillis.apply("5050000ns")));
        Assertions.assertEquals((long)5L, (Long)((Long)TimeUtil.parseTimeMillis.apply("5050\u03bcs")));
        Assertions.assertEquals((long)5L, (Long)((Long)TimeUtil.parseTimeMillis.apply("5050us")));
        Assertions.assertEquals((long)3L, (Long)((Long)TimeUtil.parseTimeMillis.apply("2000\u03bcs1000000ns")));
        Assertions.assertEquals((long)60004L, (Long)((Long)TimeUtil.parseTimeMillis.apply("1m4000\u03bcs")));
        Assertions.assertEquals((long)120001L, (Long)((Long)TimeUtil.parseTimeMillis.apply("1m60000ms1000000ns")));
        Assertions.assertEquals((long)60606L, (Long)((Long)TimeUtil.parseTimeMillis.apply("1m0s606ms0\u03bcs")));
        Assertions.assertEquals((long)3L, (Long)((Long)TimeUtil.parseTimeMillis.apply("1000000ns2000\u03bcs")));
        Assertions.assertEquals((long)60004L, (Long)((Long)TimeUtil.parseTimeMillis.apply("4000\u03bcs1m")));
        Assertions.assertEquals((long)120001L, (Long)((Long)TimeUtil.parseTimeMillis.apply("60000ms1000000ns1m")));
        Assertions.assertEquals((long)0L, (Long)((Long)TimeUtil.parseTimeMillis.apply("999\u03bcs")));
        Assertions.assertEquals((long)0L, (Long)((Long)TimeUtil.parseTimeMillis.apply("999999ns")));
        Assertions.assertEquals((long)1L, (Long)((Long)TimeUtil.parseTimeMillis.apply("999\u03bcs999999ns")));
    }

    @Test
    void nanosToStringAndBackAgain() {
        long maxDuration = 604800000L;
        int millisecondInNanos = 1000000;
        Assertions.assertEquals((Object)"7d", (Object)TimeUtil.nanosToString((long)(maxDuration * (long)millisecondInNanos)));
        for (int i = 0; i < 1000; ++i) {
            long randomMillis = ThreadLocalRandom.current().nextLong(1L, maxDuration);
            long nanos = randomMillis * (long)millisecondInNanos;
            Assertions.assertEquals((long)nanos, (long)((Long)TimeUtil.parseTimeMillis.apply(TimeUtil.nanosToString((long)nanos)) * (long)millisecondInNanos));
            Assertions.assertEquals((Long)((Long)TimeUtil.parseTimeMillis.apply(TimeUtil.nanosToString((long)nanos))), (Long)((Long)TimeUtil.parseTimeMillis.apply(TimeUtil.nanosToString((long)((Long)TimeUtil.parseTimeMillis.apply(TimeUtil.nanosToString((long)nanos)) * (long)millisecondInNanos)))));
        }
    }
}

