/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import java.time.Clock;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.function.Suppliers;
import org.neo4j.function.ThrowingPredicate;
import org.neo4j.function.ThrowingSupplier;

public final class Predicates {
    public static final IntPredicate ALWAYS_TRUE_INT = v -> true;
    public static final IntPredicate ALWAYS_FALSE_INT = v -> false;
    public static final LongPredicate ALWAYS_FALSE_LONG = v -> false;
    private static final int DEFAULT_POLL_INTERVAL = 20;
    private static final int DEFAULT_TIMEOUT_MS = 20000;

    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return x -> true;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return x -> false;
    }

    public static <T> Predicate<T> notNull() {
        return Objects::nonNull;
    }

    @SafeVarargs
    public static <T> Predicate<T> all(Predicate<T> ... predicates) {
        return Predicates.all(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> all(Iterable<Predicate<T>> predicates) {
        return item -> {
            for (Predicate predicate : predicates) {
                if (predicate.test(item)) continue;
                return false;
            }
            return true;
        };
    }

    @SafeVarargs
    public static <T> Predicate<T> any(Predicate<T> ... predicates) {
        return Predicates.any(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> any(Iterable<Predicate<T>> predicates) {
        return item -> {
            for (Predicate predicate : predicates) {
                if (!predicate.test(item)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> instanceOf(@Nonnull Class<?> clazz) {
        return clazz::isInstance;
    }

    public static <T> Predicate<T> instanceOfAny(Class<?> ... classes) {
        return item -> {
            if (item != null) {
                for (Class clazz : classes) {
                    if (!clazz.isInstance(item)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static <TYPE> TYPE await(Supplier<TYPE> supplier, Predicate<TYPE> predicate, long timeout, TimeUnit timeoutUnit, long pollInterval, TimeUnit pollUnit) throws TimeoutException {
        return (TYPE)Predicates.awaitEx(supplier::get, predicate::test, timeout, timeoutUnit, pollInterval, pollUnit);
    }

    public static <TYPE> TYPE await(Supplier<TYPE> supplier, Predicate<TYPE> predicate, long timeout, TimeUnit timeoutUnit) throws TimeoutException {
        return Predicates.awaitEx(ThrowingSupplier.throwingSupplier(supplier), ThrowingPredicate.throwingPredicate(predicate), timeout, timeoutUnit);
    }

    public static <TYPE, EXCEPTION extends Exception> TYPE awaitEx(ThrowingSupplier<TYPE, EXCEPTION> supplier, ThrowingPredicate<TYPE, EXCEPTION> predicate, long timeout, TimeUnit timeoutUnit, long pollInterval, TimeUnit pollUnit) throws TimeoutException, EXCEPTION {
        Suppliers.ThrowingCapturingSupplier<TYPE, EXCEPTION> composed = Suppliers.compose(supplier, predicate);
        Predicates.awaitEx(composed, timeout, timeoutUnit, pollInterval, pollUnit);
        return composed.lastInput();
    }

    public static <TYPE, EXCEPTION extends Exception> TYPE awaitEx(ThrowingSupplier<TYPE, ? extends EXCEPTION> supplier, ThrowingPredicate<TYPE, ? extends EXCEPTION> predicate, long timeout, TimeUnit timeoutUnit) throws TimeoutException, EXCEPTION {
        Suppliers.ThrowingCapturingSupplier<TYPE, EXCEPTION> composed = Suppliers.compose(supplier, predicate);
        Predicates.awaitEx(composed, timeout, timeoutUnit);
        return composed.lastInput();
    }

    public static void await(BooleanSupplier condition) throws TimeoutException {
        Predicates.awaitEx(condition::getAsBoolean, 20000L, TimeUnit.MILLISECONDS);
    }

    public static void await(BooleanSupplier condition, long timeout, TimeUnit unit) throws TimeoutException {
        Predicates.awaitEx(condition::getAsBoolean, timeout, unit);
    }

    public static <EXCEPTION extends Exception> void awaitEx(ThrowingSupplier<Boolean, EXCEPTION> condition, long timeout, TimeUnit unit) throws TimeoutException, EXCEPTION {
        Predicates.awaitEx(condition, timeout, unit, 20L, TimeUnit.MILLISECONDS);
    }

    public static void await(BooleanSupplier condition, long timeout, TimeUnit timeoutUnit, long pollInterval, TimeUnit pollUnit) throws TimeoutException {
        Predicates.awaitEx(condition::getAsBoolean, timeout, timeoutUnit, pollInterval, pollUnit);
    }

    public static <EXCEPTION extends Exception> void awaitEx(ThrowingSupplier<Boolean, EXCEPTION> condition, long timeout, TimeUnit unit, long pollInterval, TimeUnit pollUnit) throws TimeoutException, EXCEPTION {
        if (!Predicates.tryAwaitEx(condition, timeout, unit, pollInterval, pollUnit)) {
            throw new TimeoutException("Waited for " + timeout + " " + unit + ", but " + condition + " was not accepted.");
        }
    }

    public static <EXCEPTION extends Exception> boolean tryAwaitEx(ThrowingSupplier<Boolean, EXCEPTION> condition, long timeout, TimeUnit timeoutUnit, long pollInterval, TimeUnit pollUnit) throws EXCEPTION {
        return Predicates.tryAwaitEx(condition, timeout, timeoutUnit, pollInterval, pollUnit, Clock.systemUTC());
    }

    public static <EXCEPTION extends Exception> boolean tryAwaitEx(ThrowingSupplier<Boolean, EXCEPTION> condition, long timeout, TimeUnit timeoutUnit, long pollInterval, TimeUnit pollUnit, Clock clock) throws EXCEPTION {
        long deadlineMillis = clock.millis() + timeoutUnit.toMillis(timeout);
        long pollIntervalNanos = pollUnit.toNanos(pollInterval);
        do {
            if (condition.get().booleanValue()) {
                return true;
            }
            LockSupport.parkNanos(pollIntervalNanos);
        } while (clock.millis() < deadlineMillis);
        return false;
    }

    public static void awaitForever(BooleanSupplier condition, long checkInterval, TimeUnit unit) {
        long sleep = unit.toNanos(checkInterval);
        while (!condition.getAsBoolean()) {
            LockSupport.parkNanos(sleep);
        }
        return;
    }

    @SafeVarargs
    public static <T> Predicate<T> in(T ... allowed) {
        return Predicates.in(Arrays.asList(allowed));
    }

    public static <T> Predicate<T> in(Iterable<T> allowed) {
        return item -> {
            for (Object allow : allowed) {
                if (!allow.equals(item)) continue;
                return true;
            }
            return false;
        };
    }

    public static IntPredicate any(int[] values) {
        return v -> {
            for (int value : values) {
                if (v != value) continue;
                return true;
            }
            return false;
        };
    }
}

