/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.Objects;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.memory.LimitedMemoryTracker;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;
import org.neo4j.util.Preconditions;

public class LocalMemoryTracker
implements LimitedMemoryTracker {
    public static Monitor NO_MONITOR = allocatedBytesNative -> {};
    public static final long NO_LIMIT = 0L;
    private static final long INFINITY = Long.MAX_VALUE;
    private static final long DEFAULT_GRAB_SIZE = 1024L;
    private final MemoryPool memoryPool;
    private final long grabSize;
    private final String limitSettingName;
    private final Monitor monitor;
    private long localBytesLimit;
    private long localHeapPool;
    private long allocatedBytesHeap;
    private long allocatedBytesNative;
    private long heapHighWaterMark;

    public LocalMemoryTracker() {
        this(MemoryPools.NO_TRACKING, Long.MAX_VALUE, 1024L, null, NO_MONITOR);
    }

    public LocalMemoryTracker(MemoryPool memoryPool) {
        this(memoryPool, Long.MAX_VALUE, 1024L, null, NO_MONITOR);
    }

    public LocalMemoryTracker(MemoryPool memoryPool, long localBytesLimit, long grabSize, String limitSettingName) {
        this(memoryPool, localBytesLimit, grabSize, limitSettingName, NO_MONITOR);
    }

    public LocalMemoryTracker(MemoryPool memoryPool, long localBytesLimit, long grabSize, String limitSettingName, Monitor monitor) {
        this.memoryPool = Objects.requireNonNull(memoryPool);
        this.localBytesLimit = LocalMemoryTracker.validateLimit(localBytesLimit);
        this.grabSize = Preconditions.requireNonNegative(grabSize);
        this.limitSettingName = limitSettingName;
        this.monitor = monitor;
    }

    @Override
    public void allocateNative(long bytes) {
        if (bytes == 0L) {
            return;
        }
        Preconditions.requirePositive(bytes);
        this.allocatedBytesNative += bytes;
        if (this.allocatedBytesHeap + this.allocatedBytesNative > this.localBytesLimit) {
            this.allocatedBytesNative -= bytes;
            throw new MemoryLimitExceededException(bytes, this.localBytesLimit, this.allocatedBytesHeap + this.allocatedBytesNative, Status.General.TransactionOutOfMemoryError, this.limitSettingName);
        }
        try {
            this.memoryPool.reserveNative(bytes);
        }
        catch (MemoryLimitExceededException t) {
            this.allocatedBytesNative -= bytes;
            throw t;
        }
    }

    @Override
    public void releaseNative(long bytes) {
        this.allocatedBytesNative -= bytes;
        this.memoryPool.releaseNative(bytes);
    }

    @Override
    public void allocateHeap(long bytes) {
        if (bytes == 0L) {
            return;
        }
        Preconditions.requirePositive(bytes);
        this.allocatedBytesHeap += bytes;
        if (this.allocatedBytesHeap + this.allocatedBytesNative > this.localBytesLimit) {
            this.allocatedBytesHeap -= bytes;
            throw new MemoryLimitExceededException(bytes, this.localBytesLimit, this.allocatedBytesHeap + this.allocatedBytesNative, Status.General.TransactionOutOfMemoryError, this.limitSettingName);
        }
        if (this.allocatedBytesHeap > this.heapHighWaterMark) {
            this.heapHighWaterMark = this.allocatedBytesHeap;
        }
        if (this.allocatedBytesHeap > this.localHeapPool) {
            long grab = Math.max(bytes, this.grabSize);
            try {
                this.reserveHeapFromPool(grab);
            }
            catch (MemoryLimitExceededException t) {
                this.allocatedBytesHeap -= bytes;
                throw t;
            }
        }
    }

    @Override
    public void releaseHeap(long bytes) {
        Preconditions.requireNonNegative(bytes);
        this.allocatedBytesHeap -= bytes;
        if (this.localHeapPool > this.grabSize && this.localHeapPool / 2L > this.allocatedBytesHeap) {
            long memoryToRelease = this.localHeapPool / 4L;
            this.memoryPool.releaseHeap(memoryToRelease);
            this.localHeapPool -= memoryToRelease;
        }
    }

    @Override
    public long heapHighWaterMark() {
        return this.heapHighWaterMark;
    }

    @Override
    public long usedNativeMemory() {
        return this.allocatedBytesNative;
    }

    @Override
    public long estimatedHeapMemory() {
        return this.allocatedBytesHeap;
    }

    @Override
    public void reset() {
        try {
            if (this.allocatedBytesNative != 0L) {
                this.monitor.potentialNativeMemoryLeak(this.allocatedBytesNative);
            }
            assert (this.allocatedBytesNative == 0L) : "Potential direct memory leak. Expecting all allocated direct memory to be released, but still has " + this.allocatedBytesNative;
        }
        finally {
            this.memoryPool.releaseHeap(this.localHeapPool);
            this.localHeapPool = 0L;
            this.allocatedBytesHeap = 0L;
            this.allocatedBytesNative = 0L;
            this.heapHighWaterMark = 0L;
        }
    }

    @Override
    public MemoryTracker getScopedMemoryTracker() {
        return new ScopedMemoryTracker(this);
    }

    @Override
    public void setLimit(long localBytesLimit) {
        this.localBytesLimit = LocalMemoryTracker.validateLimit(localBytesLimit);
    }

    private void reserveHeapFromPool(long size) {
        this.memoryPool.reserveHeap(size);
        this.localHeapPool += size;
    }

    private static long validateLimit(long localBytesLimit) {
        return localBytesLimit == 0L ? Long.MAX_VALUE : Preconditions.requireNonNegative(localBytesLimit);
    }

    public static interface Monitor {
        public void potentialNativeMemoryLeak(long var1);
    }
}

