/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.progress.Indicator;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

class IndicatorTest {
    IndicatorTest() {
    }

    @Test
    void shouldIncludeDeltaTimes() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(bout);
        FakeClock clock = new FakeClock();
        Indicator.Textual indicator = new Indicator.Textual("Test", out, true, (SystemNanoClock)clock, 'D');
        int line = 0;
        clock.forward(1L, TimeUnit.SECONDS);
        indicator.progress(20 * line, 20 * ++line);
        clock.forward(100L, TimeUnit.MILLISECONDS);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        clock.forward(3L, TimeUnit.SECONDS);
        indicator.progress(20 * line, 20 * ++line);
        out.flush();
        String output = bout.toString();
        Assertions.assertThat((String)output).contains(new CharSequence[]{"10% D1s"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"20% D100ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"40% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"50% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"60% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"70% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"80% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"90% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"100% D3s"});
    }
}

