/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;

class ScopedMemoryTrackerTest {
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final ScopedMemoryTracker scopedMemoryTracker = new ScopedMemoryTracker(this.memoryTracker);

    ScopedMemoryTrackerTest() {
    }

    @Test
    void delegatesToParent() {
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.releaseNative(2L);
        this.scopedMemoryTracker.allocateHeap(12L);
        this.scopedMemoryTracker.releaseHeap(1L);
        Assertions.assertEquals((long)8L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)11L, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void dontReleaseParentsResources() {
        this.memoryTracker.allocateNative(1L);
        this.memoryTracker.allocateHeap(3L);
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.releaseNative(2L);
        this.scopedMemoryTracker.allocateHeap(12L);
        this.scopedMemoryTracker.releaseHeap(1L);
        Assertions.assertEquals((long)9L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)8L, (long)this.scopedMemoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)14L, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)11L, (long)this.scopedMemoryTracker.estimatedHeapMemory());
        this.scopedMemoryTracker.close();
        Assertions.assertEquals((long)1L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)3L, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void closeParentThenCloseChildShouldBeOK() {
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.allocateHeap(10L);
        ScopedMemoryTracker child = new ScopedMemoryTracker((MemoryTracker)this.scopedMemoryTracker);
        child.allocateNative(5L);
        child.allocateHeap(5L);
        this.scopedMemoryTracker.close();
        Assertions.assertEquals((long)0L, (long)this.scopedMemoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)this.scopedMemoryTracker.estimatedHeapMemory());
        child.close();
        Assertions.assertEquals((long)0L, (long)this.scopedMemoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)this.scopedMemoryTracker.estimatedHeapMemory());
    }

    @Test
    void closeParentThenAllocateReleaseOrResetChildShouldThrow() {
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.allocateHeap(10L);
        ScopedMemoryTracker child = new ScopedMemoryTracker((MemoryTracker)this.scopedMemoryTracker);
        child.allocateNative(5L);
        child.allocateHeap(5L);
        this.scopedMemoryTracker.close();
        Assertions.assertThrows(IllegalStateException.class, () -> child.allocateHeap(10L));
        Assertions.assertThrows(IllegalStateException.class, () -> child.allocateNative(10L));
        Assertions.assertThrows(IllegalStateException.class, () -> child.releaseHeap(10L));
        Assertions.assertThrows(IllegalStateException.class, () -> child.releaseNative(10L));
        Assertions.assertThrows(IllegalStateException.class, () -> ((ScopedMemoryTracker)child).reset());
    }
}

