/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.resources;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.resources.SunManagementHeapAllocation;

class SunManagementHeapAllocationTest {
    SunManagementHeapAllocationTest() {
    }

    @Test
    void shouldLoadHeapAllocation() {
        org.junit.jupiter.api.Assertions.assertNotSame((Object)HeapAllocation.NOT_AVAILABLE, (Object)HeapAllocation.HEAP_ALLOCATION);
        Assertions.assertThat((Object)HeapAllocation.HEAP_ALLOCATION).isInstanceOf(SunManagementHeapAllocation.class);
    }

    @Test
    void shouldMeasureAllocation() {
        long allocatedBytes = HeapAllocation.HEAP_ALLOCATION.allocatedBytes(Thread.currentThread());
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < 17; ++i) {
            objects.add(new Object());
        }
        Assertions.assertThat((long)allocatedBytes).isLessThan(HeapAllocation.HEAP_ALLOCATION.allocatedBytes(Thread.currentThread()));
        org.junit.jupiter.api.Assertions.assertEquals((int)17, (int)objects.size());
    }
}

