/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class TimeUtil {
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    public static final String VALID_TIME_DESCRIPTION = "Valid units are: `ns`, `\u03bcs`, `ms`, `s`, `m`, `h` and `d`; default unit is `s`";
    public static final Function<String, Long> parseTimeMillis = timeWithOrWithoutUnit -> {
        int unitIndex = -1;
        for (int i = 0; i < timeWithOrWithoutUnit.length(); ++i) {
            char ch = timeWithOrWithoutUnit.charAt(i);
            if (Character.isDigit(ch)) continue;
            unitIndex = i;
            break;
        }
        if (unitIndex == -1) {
            return DEFAULT_TIME_UNIT.toMillis(Integer.parseInt(timeWithOrWithoutUnit));
        }
        if (unitIndex == 0) {
            throw new IllegalArgumentException("Missing numeric value");
        }
        int unitIndexEnd = 0;
        long timeInNanos = 0L;
        block1: while (unitIndexEnd < timeWithOrWithoutUnit.length()) {
            int amountIndex = unitIndexEnd;
            unitIndexEnd = timeWithOrWithoutUnit.length();
            for (int i = unitIndex; i < timeWithOrWithoutUnit.length(); ++i) {
                char ch = timeWithOrWithoutUnit.charAt(i);
                if (!Character.isDigit(ch)) continue;
                unitIndexEnd = i;
                break;
            }
            String unit = timeWithOrWithoutUnit.substring(unitIndex, unitIndexEnd).toLowerCase();
            int amount = Integer.parseInt(timeWithOrWithoutUnit.substring(amountIndex, unitIndex));
            timeInNanos += TimeUtil.toNanos(unit, amount);
            for (int i = unitIndexEnd; i < timeWithOrWithoutUnit.length(); ++i) {
                char ch = timeWithOrWithoutUnit.charAt(i);
                if (Character.isDigit(ch)) continue;
                unitIndex = i;
                continue block1;
            }
        }
        return TimeUnit.NANOSECONDS.toMillis(timeInNanos);
    };

    private static long toNanos(String unit, int amount) {
        switch (unit) {
            case "ns": {
                return TimeUnit.NANOSECONDS.toNanos(amount);
            }
            case "us": 
            case "\u03bcs": {
                return TimeUnit.MICROSECONDS.toNanos(amount);
            }
            case "ms": {
                return TimeUnit.MILLISECONDS.toNanos(amount);
            }
            case "s": {
                return TimeUnit.SECONDS.toNanos(amount);
            }
            case "m": {
                return TimeUnit.MINUTES.toNanos(amount);
            }
            case "h": {
                return TimeUnit.HOURS.toNanos(amount);
            }
            case "d": {
                return TimeUnit.DAYS.toNanos(amount);
            }
        }
        throw new IllegalArgumentException("Unrecognized unit `" + unit + "`. Valid units are: `ns`, `\u03bcs`, `ms`, `s`, `m`, `h` and `d`; default unit is `s`");
    }

    public static String nanosToString(long nanos) {
        long microseconds;
        long milliseconds;
        long seconds;
        long minutes;
        long hours;
        assert (nanos >= 0L);
        long nanoSeconds = nanos;
        StringBuilder timeString = new StringBuilder();
        long days = TimeUnit.DAYS.convert(nanoSeconds, TimeUnit.NANOSECONDS);
        if (days > 0L) {
            nanoSeconds -= TimeUnit.DAYS.toNanos(days);
            timeString.append(days).append('d');
        }
        if ((hours = TimeUnit.HOURS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.HOURS.toNanos(hours);
            timeString.append(hours).append('h');
        }
        if ((minutes = TimeUnit.MINUTES.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.MINUTES.toNanos(minutes);
            timeString.append(minutes).append('m');
        }
        if ((seconds = TimeUnit.SECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.SECONDS.toNanos(seconds);
            timeString.append(seconds).append('s');
        }
        if ((milliseconds = TimeUnit.MILLISECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.MILLISECONDS.toNanos(milliseconds);
            timeString.append(milliseconds).append("ms");
        }
        if ((microseconds = TimeUnit.MICROSECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.MICROSECONDS.toNanos(microseconds);
            timeString.append(microseconds).append("\u03bcs");
        }
        if (nanoSeconds > 0L || timeString.length() == 0) {
            timeString.append(nanoSeconds).append("ns");
        }
        return timeString.toString();
    }

    private TimeUtil() {
        throw new AssertionError();
    }
}

