/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database.readonly;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.kernel.api.exceptions.WriteOnReadOnlyAccessDbException;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;

class DatabaseReadOnlyCheckerTest {
    DatabaseReadOnlyCheckerTest() {
    }

    @Test
    void readOnlyCheckerThrowsExceptionOnCheck() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> DatabaseReadOnlyChecker.readOnly().check());
        Assertions.assertThat((Throwable)e).hasRootCauseInstanceOf(WriteOnReadOnlyAccessDbException.class);
    }

    @Test
    void writeOnlyDoesNotThrowExceptionOnCheck() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> DatabaseReadOnlyChecker.writable().check());
    }

    @Test
    void databaseCheckersShouldReflectUpdatesToGlobalChecker() {
        NamedDatabaseId foo = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        NamedDatabaseId bar = DatabaseIdFactory.from((String)"bar", (UUID)UUID.randomUUID());
        HashSet<NamedDatabaseId> databases = new HashSet<NamedDatabaseId>();
        databases.add(foo);
        ReadOnlyDatabases globalChecker = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{() -> {
            Set snapshot = Set.copyOf(databases);
            return snapshot::contains;
        }});
        DatabaseReadOnlyChecker fooChecker = globalChecker.forDatabase(foo);
        DatabaseReadOnlyChecker barChecker = globalChecker.forDatabase(bar);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fooChecker.isReadOnly());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)barChecker.isReadOnly());
        databases.add(bar);
        globalChecker.refresh();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)barChecker.isReadOnly());
    }

    @Test
    void databaseCheckerShouldCacheLookupsFromGlobalChecker() {
        NamedDatabaseId foo = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        NamedDatabaseId bar = DatabaseIdFactory.from((String)"bar", (UUID)UUID.randomUUID());
        HashSet<NamedDatabaseId> databases = new HashSet<NamedDatabaseId>();
        databases.add(foo);
        ReadOnlyDatabases globalChecker = (ReadOnlyDatabases)Mockito.spy((Object)new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{() -> {
            Set snapshot = Set.copyOf(databases);
            return snapshot::contains;
        }}));
        DatabaseReadOnlyChecker fooChecker = globalChecker.forDatabase(foo);
        DatabaseReadOnlyChecker barChecker = globalChecker.forDatabase(bar);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fooChecker.isReadOnly());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fooChecker.isReadOnly());
        ((ReadOnlyDatabases)Mockito.verify((Object)globalChecker, (VerificationMode)Mockito.atMostOnce())).isReadOnly(foo);
        databases.add(bar);
        globalChecker.refresh();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)barChecker.isReadOnly());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fooChecker.isReadOnly());
        ((ReadOnlyDatabases)Mockito.verify((Object)globalChecker, (VerificationMode)Mockito.times((int)2))).isReadOnly(foo);
    }
}

