/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.kernel.lifecycle.SafeLifecycle;

class SafeLifecycleTest {
    private ThrowingConsumer<Lifecycle, Throwable> init = Lifecycle::init;
    private ThrowingConsumer<Lifecycle, Throwable> start = Lifecycle::start;
    private ThrowingConsumer<Lifecycle, Throwable> stop = Lifecycle::stop;
    private ThrowingConsumer<Lifecycle, Throwable> shutdown = Lifecycle::shutdown;
    private ThrowingConsumer<Lifecycle, Throwable>[] ops = new ThrowingConsumer[]{this.init, this.start, this.stop, this.shutdown};
    private LifecycleStatus[] states = new LifecycleStatus[]{LifecycleStatus.NONE, LifecycleStatus.STOPPED, LifecycleStatus.STARTED, LifecycleStatus.SHUTDOWN};
    private Object[][] onSuccess = new Object[][]{{LifecycleStatus.STOPPED, null, null, LifecycleStatus.NONE}, {null, LifecycleStatus.STARTED, LifecycleStatus.STOPPED, LifecycleStatus.SHUTDOWN}, {null, null, LifecycleStatus.STOPPED, null}, {null, null, null, null}};
    private Object[][] onFailed = new Object[][]{{LifecycleStatus.NONE, null, null, LifecycleStatus.NONE}, {null, LifecycleStatus.STOPPED, LifecycleStatus.STOPPED, LifecycleStatus.SHUTDOWN}, {null, null, LifecycleStatus.STOPPED, null}, {null, null, null, null}};
    private Boolean[][] ignored = new Boolean[][]{{false, false, false, true}, {false, false, true, false}, {false, false, false, false}, {false, false, false, false}};

    SafeLifecycleTest() {
    }

    @Test
    void shouldPerformSuccessfulTransitionsCorrectly() throws Throwable {
        for (int state = 0; state < this.states.length; ++state) {
            for (int op = 0; op < this.ops.length; ++op) {
                MySafeAndSuccessfulLife sf = new MySafeAndSuccessfulLife(this.states[state]);
                boolean caughtIllegalTransition = false;
                try {
                    this.ops[op].accept((Object)sf);
                }
                catch (IllegalStateException e) {
                    caughtIllegalTransition = true;
                }
                if (this.onSuccess[state][op] == null) {
                    Assertions.assertTrue((boolean)caughtIllegalTransition);
                    Assertions.assertEquals((Object)this.states[state], (Object)sf.getStatus());
                    continue;
                }
                Assertions.assertFalse((boolean)caughtIllegalTransition);
                Assertions.assertEquals((Object)this.onSuccess[state][op], (Object)sf.getStatus());
                int expectedOpCode = this.ignored[state][op] != false ? -1 : op;
                Assertions.assertEquals((int)expectedOpCode, (int)sf.opCode);
            }
        }
    }

    @Test
    void shouldPerformFailedTransitionsCorrectly() throws Throwable {
        for (int state = 0; state < this.states.length; ++state) {
            for (int op = 0; op < this.ops.length; ++op) {
                MyFailedLife sf = new MyFailedLife(this.states[state]);
                boolean caughtIllegalTransition = false;
                boolean failedOperation = false;
                try {
                    this.ops[op].accept((Object)sf);
                }
                catch (IllegalStateException e) {
                    caughtIllegalTransition = true;
                }
                catch (UnsupportedOperationException e) {
                    failedOperation = true;
                }
                if (this.onFailed[state][op] == null) {
                    Assertions.assertTrue((boolean)caughtIllegalTransition);
                    Assertions.assertEquals((Object)this.states[state], (Object)sf.getStatus());
                    continue;
                }
                Assertions.assertFalse((boolean)caughtIllegalTransition);
                Assertions.assertEquals((Object)this.onFailed[state][op], (Object)sf.getStatus());
                if (this.ignored[state][op].booleanValue()) {
                    Assertions.assertEquals((int)-1, (int)sf.opCode);
                    Assertions.assertFalse((boolean)failedOperation);
                    continue;
                }
                Assertions.assertEquals((int)op, (int)sf.opCode);
                Assertions.assertTrue((boolean)failedOperation);
            }
        }
    }

    private static class MyFailedLife
    extends SafeLifecycle {
        int opCode = -1;

        MyFailedLife(LifecycleStatus state) {
            super(state);
        }

        public void init0() {
            this.invoke(0);
        }

        public void start0() {
            this.invoke(1);
        }

        public void stop0() {
            this.invoke(2);
        }

        public void shutdown0() {
            this.invoke(3);
        }

        private void invoke(int opCode) {
            if (this.opCode == -1) {
                this.opCode = opCode;
                throw new UnsupportedOperationException("I made a bo-bo");
            }
            throw new RuntimeException("Double invocation");
        }
    }

    private static class MySafeAndSuccessfulLife
    extends SafeLifecycle {
        int opCode = -1;

        MySafeAndSuccessfulLife(LifecycleStatus state) {
            super(state);
        }

        public void init0() {
            this.invoke(0);
        }

        public void start0() {
            this.invoke(1);
        }

        public void stop0() {
            this.invoke(2);
        }

        public void shutdown0() {
            this.invoke(3);
        }

        private void invoke(int opCode) {
            if (this.opCode != -1) {
                throw new RuntimeException("Double invocation");
            }
            this.opCode = opCode;
        }
    }
}

