/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.string;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.string.SecureString;

class SecureStringTest {
    SecureStringTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void testString(boolean encrypt) {
        SecureStringTest.testString("a super secret text", encrypt);
    }

    @TestFactory
    Collection<DynamicTest> dynamicTestsFromCollection() {
        Random random = new Random();
        List<Charset> standardCharsets = Arrays.asList(StandardCharsets.US_ASCII, StandardCharsets.UTF_8, StandardCharsets.UTF_16, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE);
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        for (Charset charset : standardCharsets) {
            for (boolean encrypted : Arrays.asList(true, false)) {
                long randomSeed = random.nextLong();
                String testName = String.format("TestRandomStrings: encrypted(%s), encoding(%s), randomSeed(%d)", encrypted, charset, randomSeed);
                tests.add(DynamicTest.dynamicTest((String)testName, () -> SecureStringTest.testRandomStrings(encrypted, charset, randomSeed)));
            }
        }
        return tests;
    }

    static void testRandomStrings(boolean encrypt, Charset charset, long randomSeed) {
        Random random = new Random(randomSeed);
        for (int i = 0; i < 1000; ++i) {
            byte[] bytes = new byte[random.nextInt(10000) + 1];
            random.nextBytes(bytes);
            String clearText = new String(bytes, charset);
            SecureStringTest.testString(clearText, encrypt);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void testNullAndEmpty(boolean encrypt) {
        SecureStringTest.testString("", encrypt);
        SecureStringTest.testString(null, encrypt);
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void toStringNotLeaking(boolean encrypt) {
        String clearText = "leaked?";
        SecureString ss = new SecureString(clearText, encrypt);
        Assertions.assertNotEquals((Object)clearText, (Object)ss.toString());
    }

    private static void testString(String clearText, boolean useEncryption) {
        SecureString ss = new SecureString(clearText, useEncryption);
        if (useEncryption) {
            Assertions.assertTrue((boolean)ss.encryptionAvailable());
        }
        Assertions.assertEquals((Object)clearText, (Object)ss.getString());
    }
}

