/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

class TestLifecycleException {
    TestLifecycleException() {
    }

    @Test
    void shouldMakeNoneToStoppedIntoHumanReadableInitMessage() {
        Assertions.assertThat((String)TestLifecycleException.exceptionFor(LifecycleStatus.NONE, LifecycleStatus.STOPPED).getMessage()).isEqualTo("Component 'SomeComponent' failed to initialize.");
    }

    @Test
    void shouldMakeStoppedToStartedIntoHumanReadableStartingMessage() {
        Assertions.assertThat((String)TestLifecycleException.exceptionFor(LifecycleStatus.STOPPED, LifecycleStatus.STARTED).getMessage()).isEqualTo("Component 'SomeComponent' was successfully initialized, but failed to start.");
    }

    @Test
    void shouldMakeStartedToStoppedIntoHumanReadableStoppingMessage() {
        Assertions.assertThat((String)TestLifecycleException.exceptionFor(LifecycleStatus.STARTED, LifecycleStatus.STOPPED).getMessage()).isEqualTo("Component 'SomeComponent' failed to stop.");
    }

    @Test
    void shouldMakeShutdownIntoHumanReadableShutdownMessage() {
        Assertions.assertThat((String)TestLifecycleException.exceptionFor(LifecycleStatus.STOPPED, LifecycleStatus.SHUTDOWN).getMessage()).isEqualTo("Component 'SomeComponent' failed to shut down.");
    }

    @Test
    void shouldIncludeRootCauseMessageInExceptionMessage() {
        Exception root = new Exception("big bad root cause");
        Exception intermediate = new Exception("intermediate exception", root);
        Assertions.assertThat((Throwable)TestLifecycleException.exceptionFor(LifecycleStatus.STARTED, LifecycleStatus.STOPPED, intermediate)).hasMessageContaining(root.getMessage());
    }

    private static LifecycleException exceptionFor(LifecycleStatus from, LifecycleStatus to) {
        return TestLifecycleException.exceptionFor(from, to, null);
    }

    private static LifecycleException exceptionFor(LifecycleStatus from, LifecycleStatus to, Throwable cause) {
        return new LifecycleException(new Object(){

            public String toString() {
                return "SomeComponent";
            }
        }, from, to, cause);
    }
}

