/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.neo4j.memory.DualScopedHeapMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;

public class RebindableDualScopedMemoryTracker
extends ScopedMemoryTracker
implements DualScopedHeapMemoryTracker {
    private MemoryTracker innerDelegate;
    private long innerTrackedNative;
    private long innerTrackedHeap;

    public RebindableDualScopedMemoryTracker(MemoryTracker outerDelegate) {
        super(outerDelegate);
    }

    public void setInnerDelegate(MemoryTracker innerDelegate) {
        this.innerDelegate = innerDelegate;
    }

    @Override
    public long usedNativeMemory() {
        return super.usedNativeMemory() + this.innerTrackedNative;
    }

    @Override
    public long estimatedHeapMemory() {
        return super.estimatedHeapMemory() + this.innerTrackedHeap;
    }

    @Override
    public void allocateNative(long bytes) {
        if (this.innerDelegate != null) {
            this.innerDelegate.allocateNative(bytes);
            this.innerTrackedNative += bytes;
        } else {
            super.allocateNative(bytes);
        }
    }

    @Override
    public void releaseNative(long bytes) {
        if (this.innerDelegate != null) {
            this.innerDelegate.releaseNative(bytes);
            this.innerTrackedNative -= bytes;
        } else {
            super.releaseNative(bytes);
        }
    }

    @Override
    public void allocateHeap(long bytes) {
        if (this.innerDelegate != null) {
            this.innerDelegate.allocateHeap(bytes);
            this.innerTrackedHeap += bytes;
        } else {
            super.allocateHeap(bytes);
        }
    }

    @Override
    public void releaseHeap(long bytes) {
        if (this.innerDelegate != null) {
            this.innerDelegate.releaseHeap(bytes);
            this.innerTrackedHeap -= bytes;
        } else {
            super.releaseHeap(bytes);
        }
    }

    @Override
    public void allocateHeapOuter(long bytes) {
        super.allocateHeap(bytes);
    }

    @Override
    public void releaseHeapOuter(long bytes) {
        super.releaseHeap(bytes);
    }

    @Override
    public long heapHighWaterMark() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.innerDelegate.releaseNative(this.innerTrackedNative);
        this.innerDelegate.releaseHeap(this.innerTrackedHeap);
        this.innerTrackedNative = 0L;
        this.innerTrackedHeap = 0L;
        super.reset();
    }

    @Override
    public void close() {
        if (!(this.innerDelegate == null || this.innerDelegate instanceof ScopedMemoryTracker && ((ScopedMemoryTracker)this.innerDelegate).isClosed)) {
            this.innerDelegate.releaseNative(this.innerTrackedNative);
            this.innerDelegate.releaseHeap(this.innerTrackedHeap);
            this.innerDelegate = null;
        }
        this.innerTrackedNative = 0L;
        this.innerTrackedHeap = 0L;
        super.close();
    }

    public void closeInner() {
        if (this.innerDelegate != null) {
            if (!(this.innerDelegate instanceof ScopedMemoryTracker) || !((ScopedMemoryTracker)this.innerDelegate).isClosed) {
                this.innerDelegate.releaseNative(this.innerTrackedNative);
                this.innerDelegate.releaseHeap(this.innerTrackedHeap);
            }
            this.innerTrackedNative = 0L;
            this.innerTrackedHeap = 0L;
            this.innerDelegate = null;
        }
    }

    @Override
    public MemoryTracker getScopedMemoryTracker() {
        return new ScopedMemoryTracker(this);
    }
}

