/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.Objects;
import java.util.UUID;

public class Id {
    protected final UUID uuid;
    private String shortName;

    public Id(UUID uuid) {
        Objects.requireNonNull(uuid, "UUID should be not null.");
        this.uuid = uuid;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public boolean startsWith(String prefix) {
        return Objects.equals(this.shortName(), prefix);
    }

    protected String shortName() {
        if (this.shortName == null) {
            this.shortName = this.uuid.toString().substring(0, 8);
        }
        return this.shortName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Id id = (Id)o;
        return Objects.equals(this.uuid, id.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String toString() {
        return this.shortName();
    }
}

