/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.RebindableDualScopedMemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;

class RebindableDualScopedMemoryTrackerTest {
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final RebindableDualScopedMemoryTracker scopedMemoryTracker = new RebindableDualScopedMemoryTracker(this.memoryTracker);

    RebindableDualScopedMemoryTrackerTest() {
    }

    @Test
    void delegatesToOuterParentByDefault() {
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.releaseNative(2L);
        this.scopedMemoryTracker.allocateHeap(12L);
        this.scopedMemoryTracker.releaseHeap(1L);
        Assertions.assertEquals((long)8L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)11L, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void delegatesToInner() {
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.releaseNative(2L);
        this.scopedMemoryTracker.allocateHeap(12L);
        this.scopedMemoryTracker.releaseHeap(1L);
        LocalMemoryTracker inner = new LocalMemoryTracker();
        this.scopedMemoryTracker.setInnerDelegate((MemoryTracker)inner);
        this.scopedMemoryTracker.allocateNative(7L);
        this.scopedMemoryTracker.releaseNative(3L);
        this.scopedMemoryTracker.allocateHeap(10L);
        this.scopedMemoryTracker.releaseHeap(4L);
        Assertions.assertEquals((long)8L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)11L, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)4L, (long)inner.usedNativeMemory());
        Assertions.assertEquals((long)6L, (long)inner.estimatedHeapMemory());
    }

    @Test
    void dontReleaseParentsResources() {
        LocalMemoryTracker inner = new LocalMemoryTracker();
        this.memoryTracker.allocateNative(1L);
        this.memoryTracker.allocateHeap(3L);
        inner.allocateNative(2L);
        inner.allocateHeap(4L);
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.releaseNative(2L);
        this.scopedMemoryTracker.allocateHeap(12L);
        this.scopedMemoryTracker.releaseHeap(1L);
        this.scopedMemoryTracker.setInnerDelegate((MemoryTracker)inner);
        this.scopedMemoryTracker.allocateNative(7L);
        this.scopedMemoryTracker.releaseNative(3L);
        this.scopedMemoryTracker.allocateHeap(10L);
        this.scopedMemoryTracker.releaseHeap(4L);
        Assertions.assertEquals((long)9L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)6L, (long)inner.usedNativeMemory());
        Assertions.assertEquals((long)12L, (long)this.scopedMemoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)14L, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)10L, (long)inner.estimatedHeapMemory());
        Assertions.assertEquals((long)17L, (long)this.scopedMemoryTracker.estimatedHeapMemory());
        this.scopedMemoryTracker.releaseNative(4L);
        this.scopedMemoryTracker.releaseHeap(6L);
        this.scopedMemoryTracker.close();
        Assertions.assertEquals((long)1L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)3L, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)2L, (long)inner.usedNativeMemory());
        Assertions.assertEquals((long)4L, (long)inner.estimatedHeapMemory());
    }

    @Test
    void closeParentThenCloseChildShouldBeOK() {
        LocalMemoryTracker inner = new LocalMemoryTracker();
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.allocateHeap(10L);
        this.scopedMemoryTracker.setInnerDelegate((MemoryTracker)inner);
        inner.allocateNative(7L);
        inner.allocateHeap(7L);
        ScopedMemoryTracker child = new ScopedMemoryTracker((MemoryTracker)this.scopedMemoryTracker);
        child.allocateNative(5L);
        child.releaseNative(5L);
        child.allocateHeap(5L);
        child.releaseHeap(5L);
        this.scopedMemoryTracker.close();
        Assertions.assertEquals((long)0L, (long)this.scopedMemoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)this.scopedMemoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)this.scopedMemoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)this.scopedMemoryTracker.estimatedHeapMemory());
        child.close();
        Assertions.assertEquals((long)0L, (long)this.scopedMemoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)this.scopedMemoryTracker.estimatedHeapMemory());
    }

    @Test
    void closeParentThenAllocateReleaseOrResetChildShouldThrow() {
        LocalMemoryTracker inner = new LocalMemoryTracker();
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.allocateHeap(10L);
        this.scopedMemoryTracker.setInnerDelegate((MemoryTracker)inner);
        inner.allocateNative(7L);
        inner.allocateHeap(7L);
        ScopedMemoryTracker child = new ScopedMemoryTracker((MemoryTracker)this.scopedMemoryTracker);
        child.allocateNative(5L);
        child.releaseNative(5L);
        child.allocateHeap(5L);
        child.releaseHeap(5L);
        this.scopedMemoryTracker.close();
        Assertions.assertThrows(IllegalStateException.class, () -> child.allocateHeap(10L));
        Assertions.assertThrows(IllegalStateException.class, () -> child.allocateNative(10L));
        Assertions.assertThrows(IllegalStateException.class, () -> child.releaseHeap(10L));
        Assertions.assertThrows(IllegalStateException.class, () -> child.releaseNative(10L));
        Assertions.assertThrows(IllegalStateException.class, () -> ((ScopedMemoryTracker)child).reset());
    }

    @Test
    void delegatesToInnerUntilCloseInner() {
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.releaseNative(2L);
        this.scopedMemoryTracker.allocateHeap(12L);
        this.scopedMemoryTracker.releaseHeap(1L);
        LocalMemoryTracker inner = new LocalMemoryTracker();
        inner.allocateNative(10000L);
        inner.allocateHeap(10000L);
        this.scopedMemoryTracker.setInnerDelegate((MemoryTracker)inner);
        this.scopedMemoryTracker.allocateNative(7L);
        this.scopedMemoryTracker.releaseNative(3L);
        this.scopedMemoryTracker.allocateHeap(10L);
        this.scopedMemoryTracker.releaseHeap(4L);
        Assertions.assertEquals((long)8L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)11L, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)10004L, (long)inner.usedNativeMemory());
        Assertions.assertEquals((long)10006L, (long)inner.estimatedHeapMemory());
        this.scopedMemoryTracker.closeInner();
        Assertions.assertEquals((long)4L, (long)this.scopedMemoryTracker.unreleasedInnerScopeNative());
        Assertions.assertEquals((long)6L, (long)this.scopedMemoryTracker.unreleasedInnerScopeHeap());
        this.scopedMemoryTracker.allocateNative(2000L);
        this.scopedMemoryTracker.releaseNative(1000L);
        this.scopedMemoryTracker.allocateHeap(5000L);
        this.scopedMemoryTracker.releaseHeap(3000L);
        Assertions.assertEquals((long)1008L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)2011L, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)10000L, (long)inner.usedNativeMemory());
        Assertions.assertEquals((long)10000L, (long)inner.estimatedHeapMemory());
    }

    @Test
    void delegatesToInnerUntilCloseInnerRepeat() {
        this.scopedMemoryTracker.allocateNative(10L);
        this.scopedMemoryTracker.releaseNative(2L);
        this.scopedMemoryTracker.allocateHeap(12L);
        this.scopedMemoryTracker.releaseHeap(1L);
        LocalMemoryTracker inner = new LocalMemoryTracker();
        inner.allocateNative(10000L);
        inner.allocateHeap(10000L);
        this.scopedMemoryTracker.setInnerDelegate((MemoryTracker)inner);
        this.scopedMemoryTracker.allocateNative(7L);
        this.scopedMemoryTracker.releaseNative(3L);
        this.scopedMemoryTracker.allocateHeap(10L);
        this.scopedMemoryTracker.releaseHeap(4L);
        Assertions.assertEquals((long)8L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)11L, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)10004L, (long)inner.usedNativeMemory());
        Assertions.assertEquals((long)10006L, (long)inner.estimatedHeapMemory());
        this.scopedMemoryTracker.closeInner();
        long expectedCarryOverNative = 4L;
        long expectedCarryOverHeap = 6L;
        Assertions.assertEquals((long)4L, (long)this.scopedMemoryTracker.unreleasedInnerScopeNative());
        Assertions.assertEquals((long)6L, (long)this.scopedMemoryTracker.unreleasedInnerScopeHeap());
        this.scopedMemoryTracker.allocateNative(2000L);
        this.scopedMemoryTracker.releaseNative(1000L);
        this.scopedMemoryTracker.allocateHeap(5000L);
        this.scopedMemoryTracker.releaseHeap(3000L);
        Assertions.assertEquals((long)1008L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)2011L, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)10000L, (long)inner.usedNativeMemory());
        Assertions.assertEquals((long)10000L, (long)inner.estimatedHeapMemory());
        LocalMemoryTracker inner2 = new LocalMemoryTracker();
        inner2.allocateNative(100000L);
        inner2.allocateHeap(100000L);
        this.scopedMemoryTracker.setInnerDelegate((MemoryTracker)inner2);
        this.scopedMemoryTracker.allocateNative(23L);
        this.scopedMemoryTracker.releaseNative(7L);
        this.scopedMemoryTracker.allocateHeap(11L);
        this.scopedMemoryTracker.releaseHeap(2L);
        Assertions.assertEquals((long)1008L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)2011L, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)100020L, (long)inner2.usedNativeMemory());
        Assertions.assertEquals((long)100015L, (long)inner2.estimatedHeapMemory());
        this.scopedMemoryTracker.closeInner();
        this.scopedMemoryTracker.allocateNative(2000L);
        this.scopedMemoryTracker.releaseNative(1000L);
        this.scopedMemoryTracker.allocateHeap(5000L);
        this.scopedMemoryTracker.releaseHeap(3000L);
        Assertions.assertEquals((long)2008L, (long)this.memoryTracker.usedNativeMemory());
        Assertions.assertEquals((long)4011L, (long)this.memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)100000L, (long)inner2.usedNativeMemory());
        Assertions.assertEquals((long)100000L, (long)inner2.estimatedHeapMemory());
    }

    @Test
    void assertNoUnreleasedInnerOnClose() {
        LocalMemoryTracker outer = new LocalMemoryTracker();
        RebindableDualScopedMemoryTracker tracker = new RebindableDualScopedMemoryTracker((MemoryTracker)outer);
        LocalMemoryTracker inner1 = new LocalMemoryTracker();
        tracker.setInnerDelegate((MemoryTracker)inner1);
        tracker.allocateNative(3L);
        tracker.releaseNative(1L);
        tracker.allocateHeap(2L);
        tracker.releaseHeap(1L);
        tracker.closeInner();
        Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)tracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner1.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner1.estimatedHeapMemory());
        Assertions.assertEquals((long)2L, (long)tracker.unreleasedInnerScopeNative());
        Assertions.assertEquals((long)1L, (long)tracker.unreleasedInnerScopeHeap());
        LocalMemoryTracker inner2 = new LocalMemoryTracker();
        tracker.setInnerDelegate((MemoryTracker)inner2);
        tracker.allocateNative(4L);
        tracker.releaseNative(3L);
        tracker.allocateHeap(10L);
        tracker.releaseHeap(5L);
        tracker.closeInner();
        Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)tracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner1.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner1.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner2.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner2.estimatedHeapMemory());
        Assertions.assertEquals((long)3L, (long)tracker.unreleasedInnerScopeNative());
        Assertions.assertEquals((long)6L, (long)tracker.unreleasedInnerScopeHeap());
        LocalMemoryTracker inner3 = new LocalMemoryTracker();
        tracker.setInnerDelegate((MemoryTracker)inner3);
        tracker.allocateNative(20L);
        tracker.releaseNative(10L);
        tracker.allocateHeap(34L);
        tracker.releaseHeap(30L);
        tracker.closeInner();
        Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)tracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner1.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner1.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner2.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner2.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner3.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner3.estimatedHeapMemory());
        Assertions.assertEquals((long)13L, (long)tracker.unreleasedInnerScopeNative());
        Assertions.assertEquals((long)10L, (long)tracker.unreleasedInnerScopeHeap());
        AssertionError error = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> ((RebindableDualScopedMemoryTracker)tracker).close()));
        Assertions.assertEquals((Object)"Unreleased inner native memory", (Object)((Throwable)((Object)error)).getMessage());
    }

    @Test
    void assertNoUnreleasedInnerOnClose2() {
        LocalMemoryTracker outer = new LocalMemoryTracker();
        RebindableDualScopedMemoryTracker tracker = new RebindableDualScopedMemoryTracker((MemoryTracker)outer);
        LocalMemoryTracker inner1 = new LocalMemoryTracker();
        tracker.setInnerDelegate((MemoryTracker)inner1);
        tracker.allocateNative(3L);
        tracker.releaseNative(3L);
        tracker.allocateHeap(2L);
        tracker.releaseHeap(1L);
        tracker.closeInner();
        Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)tracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner1.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner1.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)tracker.unreleasedInnerScopeNative());
        Assertions.assertEquals((long)1L, (long)tracker.unreleasedInnerScopeHeap());
        AssertionError error = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> ((RebindableDualScopedMemoryTracker)tracker).close()));
        Assertions.assertEquals((Object)"Unreleased inner heap memory", (Object)((Throwable)((Object)error)).getMessage());
    }

    @Test
    void assertNoUnreleasedInnerOnClose3() {
        LocalMemoryTracker outer = new LocalMemoryTracker();
        RebindableDualScopedMemoryTracker tracker = new RebindableDualScopedMemoryTracker((MemoryTracker)outer);
        LocalMemoryTracker inner1 = new LocalMemoryTracker();
        tracker.setInnerDelegate((MemoryTracker)inner1);
        tracker.allocateNative(3L);
        tracker.releaseNative(1L);
        tracker.allocateHeap(2L);
        tracker.releaseHeap(1L);
        tracker.closeInner();
        Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)tracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner1.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner1.estimatedHeapMemory());
        Assertions.assertEquals((long)2L, (long)tracker.unreleasedInnerScopeNative());
        Assertions.assertEquals((long)1L, (long)tracker.unreleasedInnerScopeHeap());
        LocalMemoryTracker inner2 = new LocalMemoryTracker();
        tracker.setInnerDelegate((MemoryTracker)inner2);
        tracker.allocateNative(4L);
        tracker.releaseNative(3L);
        tracker.allocateHeap(10L);
        tracker.releaseHeap(5L);
        tracker.closeInner();
        Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)tracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner1.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner1.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner2.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner2.estimatedHeapMemory());
        Assertions.assertEquals((long)3L, (long)tracker.unreleasedInnerScopeNative());
        Assertions.assertEquals((long)6L, (long)tracker.unreleasedInnerScopeHeap());
        LocalMemoryTracker inner3 = new LocalMemoryTracker();
        tracker.setInnerDelegate((MemoryTracker)inner3);
        tracker.allocateNative(20L);
        tracker.releaseNative(23L);
        tracker.allocateHeap(34L);
        tracker.releaseHeap(40L);
        tracker.closeInner();
        Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)tracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner1.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner1.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner2.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner2.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)inner3.usedNativeMemory());
        Assertions.assertEquals((long)0L, (long)inner3.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)tracker.unreleasedInnerScopeNative());
        Assertions.assertEquals((long)0L, (long)tracker.unreleasedInnerScopeHeap());
        tracker.close();
    }
}

