/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.util.FeatureToggles;

public class HeapDumpDiagnostics {
    public static final HeapDumpDiagnostics INSTANCE = new HeapDumpDiagnostics();
    private static final boolean storeDiagnostics = FeatureToggles.flag(HeapDumpDiagnostics.class, "ENABLED", true);
    public volatile String START_TIME;
    public volatile String NEO4J_VERSION;
    public final ConcurrentHashMap<String, String> DIAGNOSTICS = new ConcurrentHashMap();
    public volatile String SYSTEM_DIAGNOSTICS;

    public static void addDiagnostics(String database, String diagnostics) {
        if (storeDiagnostics) {
            if (Objects.equals(database, "")) {
                HeapDumpDiagnostics.INSTANCE.SYSTEM_DIAGNOSTICS = HeapDumpDiagnostics.cleanupDiagnostics(diagnostics);
            } else if (HeapDumpDiagnostics.INSTANCE.DIAGNOSTICS.containsKey(database) || HeapDumpDiagnostics.INSTANCE.DIAGNOSTICS.size() < 10) {
                HeapDumpDiagnostics.INSTANCE.DIAGNOSTICS.put(database, HeapDumpDiagnostics.cleanupDiagnostics(diagnostics));
            }
        }
    }

    private static String cleanupDiagnostics(String diagnostics) {
        return diagnostics.replace("  ", "");
    }

    private HeapDumpDiagnostics() {
    }
}

