/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.service.NamedService;
import org.neo4j.service.PrioritizedService;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.Preconditions;

public final class Services {
    private static final boolean PRINT_SERVICE_LOADER_STACK_TRACES = FeatureToggles.flag(Services.class, "printServiceLoaderStackTraces", false);

    private Services() {
    }

    public static <T> Collection<T> loadAll(Class<T> service) {
        return Services.loadAll(Services.class.getClassLoader(), service);
    }

    public static <T> Collection<T> loadAll(ClassLoader classLoader, Class<T> service) {
        HashMap providers = new HashMap();
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        Services.loadAllSafely(service, contextCL).forEach(provider -> providers.put(provider.getClass().getName(), provider));
        if (classLoader != contextCL) {
            Services.loadAllSafely(service, classLoader).forEach(provider -> providers.putIfAbsent(provider.getClass().getName(), provider));
        }
        return new ArrayList(providers.values());
    }

    public static <T extends NamedService> Optional<T> load(Class<T> service, String name) {
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)name), "Service provider name is null or blank");
        return Services.load(service, name, NamedService::getName);
    }

    public static <T, K> Optional<T> load(Class<T> service, K key, Function<T, K> keyAccessor) {
        Objects.requireNonNull(key, "Service provider key is null");
        List<Object> matches = Services.loadAll(service).stream().filter(provider -> key.equals(keyAccessor.apply(provider))).toList();
        if (matches.size() > 1) {
            throw new RuntimeException(String.format("Found multiple service providers %s[%s]: %s", service, key, matches));
        }
        return matches.isEmpty() ? Optional.empty() : Optional.of(matches.get(0));
    }

    public static <T extends PrioritizedService> Optional<T> loadByPriority(Class<T> service) {
        List all = (List)Services.loadAll(service);
        all.sort(Comparator.comparingInt(PrioritizedService::getPriority));
        return all.isEmpty() ? Optional.empty() : Optional.of((PrioritizedService)all.get(0));
    }

    public static <T extends NamedService> T loadOrFail(Class<T> service, String name) {
        return (T)Services.loadOrFail(service, name, NamedService::getName);
    }

    public static <T, K> T loadOrFail(Class<T> service, K key, Function<T, K> keyAccessor) {
        return Services.load(service, key, keyAccessor).orElseThrow(() -> new NoSuchElementException(String.format("Could not find service provider %s[%s]", service.getName(), key)));
    }

    private static <T> List<T> loadAllSafely(Class<T> type, ClassLoader classLoader) {
        ArrayList<T> services = new ArrayList<T>();
        Iterator<T> loader = ServiceLoader.load(type, classLoader).iterator();
        while (loader.hasNext()) {
            try {
                services.add(loader.next());
            }
            catch (ServiceConfigurationError e) {
                if (!PRINT_SERVICE_LOADER_STACK_TRACES) continue;
                e.printStackTrace();
            }
        }
        return services;
    }
}

