/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.ThreadSafePeakMemoryTracker;

class ThreadSafePeakMemoryTrackerTest {
    ThreadSafePeakMemoryTrackerTest() {
    }

    @Test
    void shouldRegisterConcurrentAllocationsAndDeallocations() throws InterruptedException {
        ThreadSafePeakMemoryTracker tracker = new ThreadSafePeakMemoryTracker();
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        for (int t = 0; t < 10; ++t) {
            executorService.submit(() -> {
                int i;
                for (i = 1; i < 100; ++i) {
                    tracker.allocateNative((long)i);
                    Assertions.assertThat((long)tracker.usedNativeMemory()).isGreaterThan(0L);
                }
                for (i = 1; i < 100; ++i) {
                    Assertions.assertThat((long)tracker.usedNativeMemory()).isGreaterThan(0L);
                    tracker.releaseNative((long)i);
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.MINUTES);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
    }

    @Test
    void shouldRegisterPeakMemoryUsage() throws InterruptedException {
        ThreadSafePeakMemoryTracker tracker = new ThreadSafePeakMemoryTracker();
        int threads = 200;
        long[] allocations = new long[threads];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long sum = 0L;
        for (int i = 0; i < allocations.length; ++i) {
            allocations[i] = random.nextInt(1, 10000);
            sum += allocations[i];
        }
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        int i = 0;
        while (i < threads) {
            int id = i++;
            executorService.submit(() -> tracker.allocateNative(allocations[id]));
        }
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.MINUTES);
        long peakAfterAllocation = tracker.peakMemoryUsage();
        LongStream.of(allocations).forEach(arg_0 -> ((ThreadSafePeakMemoryTracker)tracker).releaseNative(arg_0));
        long peakAfterDeallocation = tracker.peakMemoryUsage();
        LongStream.of(allocations).forEach(arg_0 -> ((ThreadSafePeakMemoryTracker)tracker).allocateNative(arg_0));
        tracker.allocateNative(10L);
        long peakAfterHigherReallocation = tracker.peakMemoryUsage();
        LongStream.of(allocations).forEach(arg_0 -> ((ThreadSafePeakMemoryTracker)tracker).releaseNative(arg_0));
        tracker.releaseNative(10L);
        long peakAfterFinalDeallocation = tracker.peakMemoryUsage();
        org.junit.jupiter.api.Assertions.assertEquals((long)sum, (long)peakAfterAllocation);
        org.junit.jupiter.api.Assertions.assertEquals((long)sum, (long)peakAfterDeallocation);
        org.junit.jupiter.api.Assertions.assertEquals((long)(sum + 10L), (long)peakAfterHigherReallocation);
        org.junit.jupiter.api.Assertions.assertEquals((long)(sum + 10L), (long)peakAfterFinalDeallocation);
    }
}

