/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.HeapDumper;
import org.neo4j.memory.MemoryTracker;

public class HeapDumpingMemoryTracker
implements MemoryTracker {
    private final MemoryTracker delegate;
    private final HeapDumper heapDumper;
    private long targetHighWaterMark;
    private String heapDumpFileName;
    private boolean overwriteExisting;
    private boolean liveObjectsOnly;
    private Consumer<HeapDumpingMemoryTracker> onTargetReached;
    private long lastAllocatedBytes;

    public HeapDumpingMemoryTracker(MemoryTracker delegate) {
        this.delegate = delegate;
        this.heapDumper = new HeapDumper();
    }

    public void setHeapDumpAtHighWaterMark(long targetHighWaterMark, String heapDumpFileName) {
        this.targetHighWaterMark = targetHighWaterMark;
        this.heapDumpFileName = heapDumpFileName;
        this.overwriteExisting = true;
        this.liveObjectsOnly = true;
        this.onTargetReached = null;
    }

    public void setHeapDumpAtHighWaterMark(long targetHighWaterMark, String heapDumpFileName, boolean overwriteExisting, boolean liveObjectsOnly, Consumer<HeapDumpingMemoryTracker> onTargetReached) {
        this.targetHighWaterMark = targetHighWaterMark;
        this.heapDumpFileName = heapDumpFileName;
        this.overwriteExisting = overwriteExisting;
        this.liveObjectsOnly = liveObjectsOnly;
        this.onTargetReached = onTargetReached;
    }

    public void setCallbackAtHighWaterMark(long targetHighWaterMark, Consumer<HeapDumpingMemoryTracker> onTargetReached) {
        this.targetHighWaterMark = targetHighWaterMark;
        this.heapDumpFileName = null;
        this.overwriteExisting = false;
        this.liveObjectsOnly = true;
        this.onTargetReached = onTargetReached;
    }

    @Override
    public long usedNativeMemory() {
        return this.delegate.usedNativeMemory();
    }

    @Override
    public long estimatedHeapMemory() {
        return this.delegate.estimatedHeapMemory();
    }

    @Override
    public void allocateNative(long bytes) {
        this.delegate.allocateNative(bytes);
    }

    @Override
    public void releaseNative(long bytes) {
        this.delegate.releaseNative(bytes);
    }

    @Override
    public void allocateHeap(long bytes) {
        this.delegate.allocateHeap(bytes);
        this.checkIfTargetHighWaterMarkReached(bytes);
    }

    @Override
    public void releaseHeap(long bytes) {
        this.delegate.releaseHeap(bytes);
    }

    @Override
    public long heapHighWaterMark() {
        return this.delegate.heapHighWaterMark();
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public MemoryTracker getScopedMemoryTracker() {
        return new DefaultScopedMemoryTracker(this);
    }

    public long lastAllocatedBytes() {
        return this.lastAllocatedBytes;
    }

    private void checkIfTargetHighWaterMarkReached(long bytes) {
        long currentHighWaterMark = this.delegate.heapHighWaterMark();
        if (this.targetHighWaterMark > 0L && currentHighWaterMark >= this.targetHighWaterMark) {
            this.lastAllocatedBytes = bytes;
            this.doHeapDump();
            if (this.onTargetReached != null) {
                this.onTargetReached.accept(this);
            }
            this.targetHighWaterMark = 0L;
        }
    }

    private void doHeapDump() {
        if (this.heapDumpFileName == null) {
            return;
        }
        if (this.overwriteExisting && Files.exists(Path.of(this.heapDumpFileName, new String[0]), new LinkOption[0])) {
            try {
                Files.delete(Path.of(this.heapDumpFileName, new String[0]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.heapDumper.createHeapDump(this.heapDumpFileName, this.liveObjectsOnly);
    }
}

