/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.DefaultIntervalStrategy;
import org.neo4j.internal.helpers.IntervalStrategy;

class ExponentialIntervalStrategyTest {
    private static final int NUMBER_OF_ACCESSES = 5;

    ExponentialIntervalStrategyTest() {
    }

    @Test
    void shouldDoubleEachTime() {
        IntervalStrategy strategy = DefaultIntervalStrategy.exponential((long)1L, (long)32L, (TimeUnit)TimeUnit.MILLISECONDS);
        IntervalStrategy.IntervalProvider backoff = strategy.newIntervalProvider();
        for (int i = 0; i < 5; ++i) {
            backoff.increment();
        }
        Assertions.assertEquals((long)32L, (long)backoff.getMillis());
    }

    @Test
    void shouldProvidePreviousTimeout() {
        IntervalStrategy strategy = DefaultIntervalStrategy.exponential((long)1L, (long)32L, (TimeUnit)TimeUnit.MILLISECONDS);
        IntervalStrategy.IntervalProvider backoff = strategy.newIntervalProvider();
        for (int i = 0; i < 5; ++i) {
            backoff.increment();
        }
        Assertions.assertEquals((long)32L, (long)backoff.getMillis());
    }

    @Test
    void shouldRespectUpperBound() {
        long upperBound = 27L;
        IntervalStrategy strategy = DefaultIntervalStrategy.exponential((long)1L, (long)upperBound, (TimeUnit)TimeUnit.MILLISECONDS);
        IntervalStrategy.IntervalProvider backoff = strategy.newIntervalProvider();
        for (int i = 0; i < 5; ++i) {
            backoff.increment();
        }
        Assertions.assertEquals((long)upperBound, (long)backoff.getMillis());
        backoff.increment();
        backoff.increment();
        backoff.increment();
        Assertions.assertEquals((long)upperBound, (long)backoff.getMillis());
    }
}

