/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

class ProgressMonitorFactoryTest {
    ProgressMonitorFactoryTest() {
    }

    @Test
    void shouldMapOneProgressRangeToAnother() {
        final MutableLong targetProgression = new MutableLong();
        ProgressListener.Adapter target = new ProgressListener.Adapter(){

            public void add(long progress) {
                targetProgression.add(progress);
            }
        };
        int mappedResolution = 10;
        ProgressMonitorFactory factory = ProgressMonitorFactory.mapped((ProgressListener)target, (int)mappedResolution);
        int totalCount = 100;
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        try (ProgressListener source = factory.singlePart("Mapped", (long)totalCount);){
            int stride;
            for (int i = 0; i < totalCount; i += stride) {
                stride = rng.nextInt(1, 5);
                source.add((long)stride);
            }
        }
        Assertions.assertThat((long)targetProgression.longValue()).isEqualTo((long)mappedResolution);
    }
}

