/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.kernel.api.exceptions.NotificationCategory;
import org.neo4j.kernel.api.exceptions.SeverityLevel;

@PublicApi
public interface Status {
    public Code code();

    public static Status statusCodeOf(Throwable e) {
        do {
            if (!(e instanceof HasStatus)) continue;
            return ((HasStatus)((Object)e)).status();
        } while ((e = e.getCause()) != null);
        return null;
    }

    public static interface HasStatus {
        public Status status();
    }

    public static enum Classification {
        ClientError(TransactionEffect.ROLLBACK, "The Client sent a bad request - changing the request might yield a successful outcome."),
        ClientNotification(TransactionEffect.NONE, "There are notifications about the request sent by the client."),
        TransientError(TransactionEffect.ROLLBACK, "The database cannot service the request right now, retrying later might yield a successful outcome. "),
        DatabaseError(TransactionEffect.ROLLBACK, "The database failed to service the request. ");

        private final boolean rollbackTransaction;
        private final String description;

        private Classification(TransactionEffect transactionEffect, String description) {
            this.description = description;
            this.rollbackTransaction = transactionEffect == TransactionEffect.ROLLBACK;
        }

        public boolean rollbackTransaction() {
            return this.rollbackTransaction;
        }

        public String description() {
            return this.description;
        }

        private static enum TransactionEffect {
            ROLLBACK,
            NONE;

        }
    }

    public static class NotificationCode
    extends Code {
        private final SeverityLevel severity;
        private final NotificationCategory notificationCategory;
        private final Classification classification;
        private final String category;
        private final String title;

        <C extends Enum<C>> NotificationCode(Classification classification, C categoryAndTitle, String description, SeverityLevel severity, NotificationCategory notificationCategory) {
            super(classification, categoryAndTitle, description);
            this.severity = severity;
            this.classification = classification;
            this.category = categoryAndTitle.getDeclaringClass().getSimpleName();
            this.notificationCategory = notificationCategory;
            this.title = categoryAndTitle.name();
        }

        public String getSeverity() {
            return this.severity.name();
        }

        public String getNotificationCategory() {
            return this.notificationCategory.name();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotificationCode code = (NotificationCode)o;
            return this.category.equals(code.category) && this.classification == code.classification && this.title.equals(code.title) && this.severity == code.severity && this.notificationCategory == code.notificationCategory;
        }

        @Override
        public int hashCode() {
            int result = this.classification.hashCode();
            result = 31 * result + this.category.hashCode();
            result = 31 * result + this.title.hashCode();
            result = 31 * result + this.severity.hashCode();
            result = 31 * result + this.notificationCategory.hashCode();
            return result;
        }
    }

    public static class Code {
        private final Classification classification;
        private final String description;
        private final String category;
        private final String title;

        public static Collection<Status> all() {
            ArrayList<Status> result = new ArrayList<Status>();
            for (Class<?> child : Status.class.getDeclaredClasses()) {
                if (!child.isEnum() || !Status.class.isAssignableFrom(child)) continue;
                Class<?> statusType = child;
                Collections.addAll(result, (Status[])statusType.getEnumConstants());
            }
            return result;
        }

        <C extends Enum<C>> Code(Classification classification, C categoryAndTitle, String description) {
            this.classification = classification;
            this.category = categoryAndTitle.getDeclaringClass().getSimpleName();
            this.title = categoryAndTitle.name();
            this.description = description;
        }

        public String toString() {
            return "Status.Code[" + this.serialize() + "]";
        }

        public final String serialize() {
            return String.format("Neo.%s.%s.%s", new Object[]{this.classification, this.category, this.title});
        }

        public final String description() {
            return this.description;
        }

        public Classification classification() {
            return this.classification;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Code code = (Code)o;
            return this.category.equals(code.category) && this.classification == code.classification && this.title.equals(code.title);
        }

        public int hashCode() {
            int result = this.classification.hashCode();
            result = 31 * result + this.category.hashCode();
            result = 31 * result + this.title.hashCode();
            return result;
        }
    }

    public static enum ChangeDataCapture implements Status
    {
        Disabled(Classification.DatabaseError, "Change Data Capture is not currently enabled for this database"),
        ScanFailure(Classification.DatabaseError, "Unable to read the Change Data Capture data for this database"),
        InvalidIdentifier(Classification.ClientError, "Invalid change identifier"),
        FutureIdentifier(Classification.TransientError, "Change identifier points to a future transaction that has not yet happened on this database instance");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private ChangeDataCapture(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Fabric implements Status
    {
        RemoteExecutionFailed(Classification.DatabaseError, "The database was unable to execute a remote part of the statement."),
        AccessMode(Classification.ClientError, "The request could not be completed due to access mode violation");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Fabric(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Cluster implements Status
    {
        ReplicationFailure(Classification.TransientError, "Replication failure."),
        NotALeader(Classification.ClientError, "The request cannot be processed by this server. Write requests can only be processed by the leader."),
        Routing(Classification.ClientError, "Unable to route the request to the appropriate server"),
        ServerAlreadyEnabled(Classification.ClientNotification, "`ENABLE SERVER` has no effect.", SeverityLevel.INFORMATION, NotificationCategory.TOPOLOGY),
        ServerAlreadyCordoned(Classification.ClientNotification, "`CORDON SERVER` has no effect.", SeverityLevel.INFORMATION, NotificationCategory.TOPOLOGY),
        NoDatabasesReallocated(Classification.ClientNotification, "`REALLOCATE DATABASES` had no effect.", SeverityLevel.INFORMATION, NotificationCategory.TOPOLOGY),
        CordonedServersExistedDuringAllocation(Classification.ClientNotification, "Cordoned servers existed when making an allocation decision.", SeverityLevel.INFORMATION, NotificationCategory.TOPOLOGY);

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Cluster(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }

        private Cluster(Classification classification, String description, SeverityLevel severity, NotificationCategory category) {
            this.code = new NotificationCode(classification, this, description, severity, category);
        }
    }

    public static enum Database implements Status
    {
        DatabaseNotFound(Classification.ClientError, "The request referred to a database that does not exist."),
        HomeDatabaseNotFound(Classification.ClientNotification, "The request referred to a home database that does not exist.", SeverityLevel.INFORMATION, NotificationCategory.UNRECOGNIZED),
        ExistingAliasFound(Classification.ClientError, "The request referred to a database with an alias."),
        ExistingDatabaseFound(Classification.ClientError, "The request referred to a database that already exists."),
        IllegalAliasChain(Classification.ClientError, "An illegal chain of aliases has been detected. This request cannot be executed."),
        DatabaseLimitReached(Classification.DatabaseError, "The limit to number of databases has been reached."),
        UnableToStartDatabase(Classification.DatabaseError, "Unable to start database."),
        Unknown(Classification.DatabaseError, "Unknown database management error");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Database(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }

        private Database(Classification classification, String description, SeverityLevel severity, NotificationCategory category) {
            this.code = new NotificationCode(classification, this, description, severity, category);
        }
    }

    public static enum General implements Status
    {
        InvalidArguments(Classification.ClientError, "The request contained fields that were empty or are not allowed."),
        ForbiddenOnReadOnlyDatabase(Classification.ClientError, "This is a read only database, writing or modifying the database is not allowed."),
        WriteOnReadOnlyAccessDatabase(Classification.ClientError, "This database is in read-only mode, writing or modifying the database is not allowed."),
        TransactionOutOfMemoryError(Classification.ClientError, "The transaction used more memory than was allowed. The maximum allowed size for a transaction can be configured with 'db.memory.transaction.max' in the neo4j configuration (normally in 'conf/neo4j.conf' or, if you are using Neo4j Desktop, found through the user interface)."),
        UpgradeRequired(Classification.ClientError, "This transaction required database to be of a higher kernel version than it is. Make sure that dbms has been correctly upgraded before retrying this operation."),
        IndexCorruptionDetected(Classification.DatabaseError, "The request (directly or indirectly) referred to an index that is in a failed state. The index needs to be dropped and recreated manually."),
        SchemaCorruptionDetected(Classification.DatabaseError, "A malformed schema rule was encountered. Please contact your support representative."),
        StorageDamageDetected(Classification.DatabaseError, "Expected set of files not found on disk. Please restore from backup."),
        UnknownError(Classification.DatabaseError, "An unknown error occurred."),
        TransactionMemoryLimit(Classification.TransientError, "There is not enough memory to perform the current task. Please try increasing 'server.memory.off_heap.transaction_max_size' in the neo4j configuration (normally in 'conf/neo4j.conf' or, if you are using Neo4j Desktop, found through the user interface), and then restart the database."),
        OutOfMemoryError(Classification.TransientError, "There is not enough memory to perform the current task. Please try increasing 'server.memory.heap.max_size' in the neo4j configuration (normally in 'conf/neo4j.conf' or, if you are using Neo4j Desktop, found through the user interface) or if you are running an embedded installation increase the heap by using '-Xmx' command line flag, and then restart the database."),
        StackOverFlowError(Classification.TransientError, "There is not enough stack size to perform the current task. This is generally considered to be a database error, so please contact Neo4j support. You could try increasing the stack size: for example to set the stack size to 2M, add `server.jvm.additional=-Xss2M' to in the neo4j configuration (normally in 'conf/neo4j.conf' or, if you are using Neo4j Desktop, found through the user interface) or if you are running an embedded installation just add -Xss2M as command line flag."),
        MemoryPoolOutOfMemoryError(Classification.TransientError, "The memory pool limit was exceeded. The corresponding setting can be found in the error message"),
        DatabaseUnavailable(Classification.TransientError, "The database is not currently available to serve your request, refer to the database logs for more details. Retrying your request at a later time may succeed.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private General(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Security implements Status
    {
        CredentialsExpired(Classification.ClientError, "The credentials have expired and need to be updated."),
        Unauthorized(Classification.ClientError, "The client is unauthorized due to authentication failure."),
        AuthenticationRateLimit(Classification.ClientError, "The client has provided incorrect authentication details too many times in a row."),
        ModifiedConcurrently(Classification.TransientError, "The user was modified concurrently to this request."),
        Forbidden(Classification.ClientError, "An attempt was made to perform an unauthorized action."),
        AuthorizationExpired(Classification.ClientError, "The stored authorization info has expired. Please reconnect."),
        AuthProviderTimeout(Classification.TransientError, "An auth provider request timed out."),
        AuthProviderFailed(Classification.TransientError, "An auth provider request failed."),
        TokenExpired(Classification.ClientError, "The auth provider token has expired"),
        CommandHasNoEffect(Classification.ClientNotification, "`%s` has no effect.", SeverityLevel.INFORMATION, NotificationCategory.SECURITY),
        ImpossibleRevokeCommand(Classification.ClientNotification, "`%s` has no effect.", SeverityLevel.WARNING, NotificationCategory.SECURITY);

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Security(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }

        private Security(Classification classification, String description, SeverityLevel severity, NotificationCategory category) {
            this.code = new NotificationCode(classification, this, description, severity, category);
        }
    }

    public static enum Procedure implements Status
    {
        ProcedureRegistrationFailed(Classification.ClientError, "The database failed to register a procedure, refer to the associated error message for details."),
        ProcedureNotFound(Classification.ClientError, "A request referred to a procedure that is not registered with this database instance. If you are deploying custom procedures in a cluster setup, ensure all instances in the cluster have the procedure jar file deployed."),
        ProcedureCallFailed(Classification.ClientError, "Failed to invoke a procedure. See the detailed error description for exact cause."),
        TypeError(Classification.ClientError, "A procedure is using or receiving a value of an invalid type."),
        ProcedureTimedOut(Classification.ClientError, "The procedure has not completed within the specified timeout. You may want to retry with a longer timeout."),
        ProcedureWarning(Classification.ClientNotification, "The query used a procedure that generated a warning.", SeverityLevel.WARNING, NotificationCategory.GENERIC);

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Procedure(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }

        private Procedure(Classification classification, String description, SeverityLevel severity, NotificationCategory category) {
            this.code = new NotificationCode(classification, this, description, severity, category);
        }
    }

    public static enum Schema implements Status
    {
        RepeatedPropertyInCompositeSchema(Classification.ClientError, "Unable to create index or constraint because schema had a repeated property."),
        RepeatedLabelInSchema(Classification.ClientError, "Unable to create index or constraint because schema had a repeated label."),
        RepeatedRelationshipTypeInSchema(Classification.ClientError, "Unable to create index or constraint because schema had a repeated relationship type."),
        EquivalentSchemaRuleAlreadyExists(Classification.ClientError, "Unable to perform operation because an equivalent schema rule already exists."),
        ConstraintAlreadyExists(Classification.ClientError, "Unable to perform operation because it would clash with a pre-existing constraint."),
        ConstraintNotFound(Classification.ClientError, "The request (directly or indirectly) referred to a constraint that does not exist."),
        ConstraintValidationFailed(Classification.ClientError, "A constraint imposed by the database was violated."),
        ConstraintViolation(Classification.ClientError, "Added or changed index entry would violate constraint"),
        IndexAlreadyExists(Classification.ClientError, "Unable to perform operation because it would clash with a pre-existing index."),
        IndexNotFound(Classification.ClientError, "The request (directly or indirectly) referred to an index that does not exist."),
        HintedIndexNotFound(Classification.ClientNotification, "The request (directly or indirectly) referred to an index that does not exist.", SeverityLevel.WARNING, NotificationCategory.HINT),
        IndexMultipleFound(Classification.ClientError, "The request referenced an index by its schema, and multiple matching indexes were found."),
        IndexNotApplicable(Classification.ClientError, "The request did not contain the properties required by the index."),
        IndexWithNameAlreadyExists(Classification.ClientError, "Unable to perform operation because index with given name already exists."),
        ConstraintWithNameAlreadyExists(Classification.ClientError, "Unable to perform operation because constraint with given name already exists."),
        ForbiddenOnConstraintIndex(Classification.ClientError, "A requested operation can not be performed on the specified index because the index is part of a constraint. If you want to drop the index, for instance, you must drop the constraint."),
        TokenNameError(Classification.ClientError, "A token name, such as a label, relationship type or property key, used is not valid. Tokens cannot be empty strings and cannot be null."),
        ConstraintCreationFailed(Classification.DatabaseError, "Creating a requested constraint failed."),
        ConstraintDropFailed(Classification.DatabaseError, "The database failed to drop a requested constraint."),
        IndexCreationFailed(Classification.DatabaseError, "Failed to create an index."),
        IndexDropFailed(Classification.DatabaseError, "The database failed to drop a requested index."),
        LabelAccessFailed(Classification.DatabaseError, "The request accessed a label that did not exist."),
        TokenLimitReached(Classification.DatabaseError, "The maximum number of tokens of this type has been reached, no more tokens of this type can be created."),
        PropertyKeyAccessFailed(Classification.DatabaseError, "The request accessed a property that does not exist."),
        RelationshipTypeAccessFailed(Classification.DatabaseError, "The request accessed a relationship type that does not exist."),
        SchemaRuleAccessFailed(Classification.DatabaseError, "The request referred to a schema rule that does not exist."),
        SchemaRuleDuplicateFound(Classification.DatabaseError, "The request referred to a schema rule that is defined multiple times.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Schema(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }

        private Schema(Classification classification, String description, SeverityLevel severity, NotificationCategory category) {
            this.code = new NotificationCode(classification, this, description, severity, category);
        }
    }

    public static enum Routing implements Status
    {
        DbmsInPanic(Classification.ClientError, "Server is in panic"),
        RoutingFailed(Classification.ClientError, "Failed to Route");

        private final Code code;

        private Routing(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }

        @Override
        public Code code() {
            return this.code;
        }
    }

    public static enum Statement implements Status
    {
        SyntaxError(Classification.ClientError, "The statement contains invalid or unsupported syntax."),
        SemanticError(Classification.ClientError, "The statement is syntactically valid, but expresses something that the database cannot do."),
        ParameterMissing(Classification.ClientError, "The statement refers to a parameter that was not provided in the request."),
        ParameterNotProvided(Classification.ClientNotification, "The statement refers to a parameter that was not provided in the request.", SeverityLevel.WARNING, NotificationCategory.GENERIC),
        ConstraintVerificationFailed(Classification.ClientError, "A constraint imposed by the statement is violated by the data in the database."),
        EntityNotFound(Classification.ClientError, "The statement refers to a non-existent entity."),
        PropertyNotFound(Classification.ClientError, "The statement refers to a non-existent property."),
        TypeError(Classification.ClientError, "The statement is attempting to perform operations on values with types that are not supported by the operation."),
        ArgumentError(Classification.ClientError, "The statement is attempting to perform operations using invalid arguments"),
        ArithmeticError(Classification.ClientError, "Invalid use of arithmetic, such as dividing by zero."),
        RuntimeUnsupportedError(Classification.ClientError, "This query is not supported by the chosen runtime."),
        NotSystemDatabaseError(Classification.ClientError, "This is an administration command and it should be executed against the system database."),
        AccessMode(Classification.ClientError, "The request could not be completed due to access mode violation"),
        UnsupportedOperationError(Classification.ClientError, "This query performed an operation that is not supported in this context."),
        ExternalResourceFailed(Classification.ClientError, "Access to an external resource failed"),
        UnsatisfiableRelationshipTypeExpression(Classification.ClientNotification, "The query contains a relationship type expression that cannot be satisfied.", SeverityLevel.WARNING, NotificationCategory.GENERIC),
        RepeatedRelationshipReference(Classification.ClientNotification, "The query returns no results due to repeated references to a relationship.", SeverityLevel.WARNING, NotificationCategory.GENERIC),
        RemoteExecutionClientError(Classification.ClientError, "The database was unable to execute a remote part of the statement due to a client error."),
        ExecutionFailed(Classification.DatabaseError, "The database was unable to execute the statement."),
        CodeGenerationFailed(Classification.ClientNotification, "The database was unable to generate code for the query. A stacktrace can be found in the debug.log.", SeverityLevel.INFORMATION, NotificationCategory.PERFORMANCE),
        RemoteExecutionFailed(Classification.DatabaseError, "The database was unable to execute a remote part of the statement."),
        ExecutionTimeout(Classification.TransientError, "The database was unable to execute the statement in a timely fashion."),
        RemoteExecutionTransientError(Classification.TransientError, "The database was unable to execute a remote part of the statement due to a transient failure."),
        CartesianProduct(Classification.ClientNotification, "This query builds a cartesian product between disconnected patterns.", SeverityLevel.INFORMATION, NotificationCategory.PERFORMANCE),
        DynamicProperty(Classification.ClientNotification, "Queries using dynamic properties will use neither index seeks nor index scans for those properties", SeverityLevel.INFORMATION, NotificationCategory.PERFORMANCE),
        EagerOperator(Classification.ClientNotification, "The execution plan for this query contains the Eager operator, which forces all dependent data to be materialized in main memory before proceeding", SeverityLevel.INFORMATION, NotificationCategory.PERFORMANCE),
        JoinHintUnfulfillableWarning(Classification.ClientNotification, "The database was unable to plan a hinted join.", SeverityLevel.WARNING, NotificationCategory.HINT),
        NoApplicableIndex(Classification.ClientNotification, "Adding a schema index may speed up this query.", SeverityLevel.INFORMATION, NotificationCategory.PERFORMANCE),
        SuboptimalIndexForWildcardQuery(Classification.ClientNotification, "Index cannot execute wildcard query efficiently", SeverityLevel.INFORMATION, NotificationCategory.PERFORMANCE),
        UnboundedVariableLengthPattern(Classification.ClientNotification, "The provided pattern is unbounded, consider adding an upper limit to the number of node hops.", SeverityLevel.INFORMATION, NotificationCategory.PERFORMANCE),
        ExhaustiveShortestPath(Classification.ClientNotification, "Exhaustive shortest path has been planned for your query that means that shortest path graph algorithm might not be used to find the shortest path. Hence an exhaustive enumeration of all paths might be used in order to find the requested shortest path.", SeverityLevel.INFORMATION, NotificationCategory.PERFORMANCE),
        SideEffectVisibility(Classification.ClientNotification, "Using a subquery expression within a mutating statement has implications for its side-effect visibility", SeverityLevel.WARNING, NotificationCategory.DEPRECATION),
        RuntimeUnsupportedWarning(Classification.ClientNotification, "This query is not supported by the chosen runtime.", SeverityLevel.WARNING, NotificationCategory.UNSUPPORTED),
        FeatureDeprecationWarning(Classification.ClientNotification, "This feature is deprecated and will be removed in future versions.", SeverityLevel.WARNING, NotificationCategory.DEPRECATION),
        RuntimeExperimental(Classification.ClientNotification, "This feature is experimental and should not be used in production systems.", SeverityLevel.WARNING, NotificationCategory.UNSUPPORTED),
        UnsupportedAdministrationCommand(Classification.ClientError, "This administration command is not supported."),
        UnknownLabelWarning(Classification.ClientNotification, "The provided label is not in the database.", SeverityLevel.WARNING, NotificationCategory.UNRECOGNIZED),
        UnknownRelationshipTypeWarning(Classification.ClientNotification, "The provided relationship type is not in the database.", SeverityLevel.WARNING, NotificationCategory.UNRECOGNIZED),
        UnknownPropertyKeyWarning(Classification.ClientNotification, "The provided property key is not in the database", SeverityLevel.WARNING, NotificationCategory.UNRECOGNIZED),
        SubqueryVariableShadowing(Classification.ClientNotification, "Variable in subquery is shadowing a variable with the same name from the outer scope.", SeverityLevel.INFORMATION, NotificationCategory.GENERIC);

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Statement(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }

        private Statement(Classification classification, String description, SeverityLevel severity, NotificationCategory category) {
            this.code = new NotificationCode(classification, this, description, severity, category);
        }
    }

    public static enum Transaction implements Status
    {
        TransactionNotFound(Classification.ClientError, "The request referred to a transaction that does not exist."),
        TransactionAccessedConcurrently(Classification.ClientError, "There were concurrent requests accessing the same transaction, which is not allowed."),
        ForbiddenDueToTransactionType(Classification.ClientError, "The transaction is of the wrong type to service the request. For instance, a transaction that has had schema modifications performed in it cannot be used to subsequently perform data operations, and vice versa."),
        TransactionValidationFailed(Classification.ClientError, "Transaction changes did not pass validation checks"),
        TransactionHookFailed(Classification.ClientError, "Transaction hook failure."),
        TransactionMarkedAsFailed(Classification.ClientError, "Transaction was marked as both successful and failed. Failure takes precedence and so this transaction was rolled back although it may have looked like it was going to be committed"),
        TransactionTimedOut(Classification.ClientError, "The transaction has not completed within the specified timeout (db.transaction.timeout). You may want to retry with a longer timeout."),
        TransactionTimedOutClientConfiguration(Classification.ClientError, "The transaction has not completed within the timeout specified at its start by the client. You may want to retry with a longer timeout."),
        InvalidBookmark(Classification.ClientError, "Supplied bookmark cannot be interpreted. You should only supply a bookmark that was previously generated by Neo4j. Maybe you have generated your own bookmark, or modified a bookmark since it was generated by Neo4j."),
        InvalidBookmarkMixture(Classification.ClientError, "Mixing bookmarks generated by different databases is forbidden.You should only chain bookmarks that are generated from the same database. You may however chain bookmarks generated from system database with bookmarks from another database."),
        Terminated(Classification.ClientError, "Explicitly terminated by the user."),
        LockAcquisitionTimeout(Classification.TransientError, "Unable to acquire lock within configured timeout (db.lock.acquisition.timeout)."),
        TransactionStartFailed(Classification.DatabaseError, "The database was unable to start the transaction."),
        TransactionTerminationFailed(Classification.DatabaseError, "The database was unable to terminate the transaction."),
        TransactionRollbackFailed(Classification.DatabaseError, "The database was unable to roll back the transaction."),
        TransactionCommitFailed(Classification.DatabaseError, "The database was unable to commit the transaction."),
        TransactionLogError(Classification.DatabaseError, "The database was unable to write transaction to log."),
        LinkedTransactionError(Classification.DatabaseError, "The transaction was terminated because another transaction executing the same query encountered an error."),
        BookmarkTimeout(Classification.TransientError, "Bookmark wait timed out. Database has not reached the specified version"),
        LeaseExpired(Classification.TransientError, "The lease under which this transaction was started is no longer valid."),
        DeadlockDetected(Classification.TransientError, "This transaction, and at least one more transaction, has acquired locks in a way that it will wait indefinitely, and the database has aborted it. Retrying this transaction will most likely be successful."),
        ConstraintsChanged(Classification.TransientError, "Database constraints changed since the start of this transaction"),
        Outdated(Classification.TransientError, "Transaction has seen state which has been invalidated by applied updates while transaction was active. Transaction may succeed if retried."),
        LockClientStopped(Classification.ClientError, "The transaction has been terminated, so no more locks can be acquired. This can occur because the transaction ran longer than the configured transaction timeout, or because a human operator manually terminated the transaction, or because the database is shutting down."),
        MaximumTransactionLimitReached(Classification.TransientError, "Unable to start new transaction since the maximum number of concurrently executing transactions is reached (db.transaction.concurrent.maximum). You can retry at a later time or consider increasing allowed maximum of concurrent transactions."),
        Interrupted(Classification.TransientError, "Interrupted while waiting."),
        LeaderSwitch(Classification.TransientError, "The request could not be completed due to cluster leader switch"),
        QueryExecutionFailedOnTransaction(Classification.TransientError, "The transaction was marked as failed because a query failed.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Transaction(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Request implements Status
    {
        Invalid(Classification.ClientError, "The client provided an invalid request."),
        InvalidFormat(Classification.ClientError, "The client provided a request that was missing required fields, or had values that are not allowed."),
        InvalidUsage(Classification.ClientError, "The client made a request but did not consume outgoing buffers in a timely fashion."),
        DeprecatedFormat(Classification.ClientNotification, "The client made a request for a format which has been deprecated.", SeverityLevel.WARNING, NotificationCategory.DEPRECATION),
        NoThreadsAvailable(Classification.TransientError, "There are no available threads to serve this request at the moment. You can retry at a later time or consider increasing max thread pool size for bolt connector(s).");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Request(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }

        private Request(Classification classification, String description, SeverityLevel severity, NotificationCategory category) {
            this.code = new NotificationCode(classification, this, description, severity, category);
        }
    }
}

