/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.time;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.time.Stopwatch;

class StopwatchTest {
    private MutableLong time = new MutableLong();
    private Stopwatch stopwatch = new Stopwatch(() -> ((MutableLong)this.time).longValue());

    StopwatchTest() {
    }

    @Test
    void tick() {
        Assertions.assertEquals((long)0L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.time.add(3L);
        Assertions.assertEquals((long)3L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    @Test
    void testTimeout() {
        Duration timeout = Duration.ofNanos(10L);
        Assertions.assertFalse((boolean)this.stopwatch.hasTimedOut(timeout));
        this.time.add(5L);
        Assertions.assertFalse((boolean)this.stopwatch.hasTimedOut(timeout));
        this.time.add(5L);
        Assertions.assertTrue((boolean)this.stopwatch.hasTimedOut(timeout));
    }
}

