/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Numbers;

class NumbersTest {
    NumbersTest() {
    }

    @Test
    void failSafeCastLongToInt() {
        ArithmeticException exception = (ArithmeticException)org.junit.jupiter.api.Assertions.assertThrows(ArithmeticException.class, () -> Numbers.safeCastLongToInt((long)0x80000000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Value 2147483648 is too big to be represented as int", (Object)exception.getMessage());
    }

    @Test
    void failSafeCastLongToShort() {
        ArithmeticException exception = (ArithmeticException)org.junit.jupiter.api.Assertions.assertThrows(ArithmeticException.class, () -> Numbers.safeCastLongToShort((long)32768L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Value 32768 is too big to be represented as short", (Object)exception.getMessage());
    }

    @Test
    void failSafeCastIntToUnsignedShort() {
        ArithmeticException exception = (ArithmeticException)org.junit.jupiter.api.Assertions.assertThrows(ArithmeticException.class, () -> Numbers.safeCastIntToUnsignedShort((int)131068));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Value 131068 is too big to be represented as unsigned short", (Object)exception.getMessage());
    }

    @Test
    void failSafeCastLongToByte() {
        ArithmeticException exception = (ArithmeticException)org.junit.jupiter.api.Assertions.assertThrows(ArithmeticException.class, () -> Numbers.safeCastLongToByte((long)128L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Value 128 is too big to be represented as byte", (Object)exception.getMessage());
    }

    @Test
    void failSafeCastIntToShort() {
        ArithmeticException exception = (ArithmeticException)org.junit.jupiter.api.Assertions.assertThrows(ArithmeticException.class, () -> Numbers.safeCastIntToShort((int)32768));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Value 32768 is too big to be represented as short", (Object)exception.getMessage());
    }

    @Test
    void castLongToInt() {
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)Numbers.safeCastLongToInt((long)1L));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)Numbers.safeCastLongToInt((long)10L));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)Numbers.safeCastLongToInt((long)-1L));
        org.junit.jupiter.api.Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Numbers.safeCastLongToInt((long)Integer.MAX_VALUE));
        org.junit.jupiter.api.Assertions.assertEquals((int)Integer.MIN_VALUE, (int)Numbers.safeCastLongToInt((long)Integer.MIN_VALUE));
    }

    @Test
    void castLongToShort() {
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)Numbers.safeCastLongToShort((long)1L));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)Numbers.safeCastLongToShort((long)10L));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)Numbers.safeCastLongToShort((long)-1L));
        org.junit.jupiter.api.Assertions.assertEquals((short)Short.MAX_VALUE, (short)Numbers.safeCastLongToShort((long)32767L));
        org.junit.jupiter.api.Assertions.assertEquals((short)Short.MIN_VALUE, (short)Numbers.safeCastLongToShort((long)-32768L));
    }

    @Test
    void castIntToUnsignedShort() {
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)Numbers.safeCastIntToUnsignedShort((int)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)Numbers.safeCastIntToUnsignedShort((int)10));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)Numbers.safeCastIntToUnsignedShort((int)65535));
    }

    @Test
    void castIntToShort() {
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)Numbers.safeCastIntToShort((int)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)Numbers.safeCastIntToShort((int)10));
        org.junit.jupiter.api.Assertions.assertEquals((short)Short.MAX_VALUE, (short)Numbers.safeCastIntToShort((int)Short.MAX_VALUE));
        org.junit.jupiter.api.Assertions.assertEquals((short)Short.MIN_VALUE, (short)Numbers.safeCastIntToShort((int)Short.MIN_VALUE));
    }

    @Test
    void castLongToByte() {
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)Numbers.safeCastLongToByte((long)1L));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)Numbers.safeCastLongToByte((long)10L));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)Numbers.safeCastLongToByte((long)-1L));
        org.junit.jupiter.api.Assertions.assertEquals((byte)127, (byte)Numbers.safeCastLongToByte((long)127L));
        org.junit.jupiter.api.Assertions.assertEquals((byte)-128, (byte)Numbers.safeCastLongToByte((long)-128L));
    }

    @Test
    void castUnsignedShortToInt() {
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)Numbers.unsignedShortToInt((short)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)Short.MAX_VALUE, (int)Numbers.unsignedShortToInt((short)Short.MAX_VALUE));
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)Numbers.unsignedShortToInt((short)-1));
    }

    @Test
    void checkLongCeilingPowerOfTwo() {
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)Numbers.ceilingPowerOfTwo((long)1L));
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Numbers.ceilingPowerOfTwo((long)2L));
        org.junit.jupiter.api.Assertions.assertEquals((long)8L, (long)Numbers.ceilingPowerOfTwo((long)5L));
        org.junit.jupiter.api.Assertions.assertEquals((long)32L, (long)Numbers.ceilingPowerOfTwo((long)32L));
        org.junit.jupiter.api.Assertions.assertEquals((long)1024L, (long)Numbers.ceilingPowerOfTwo((long)1023L));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.ceilingPowerOfTwo((long)Long.MAX_VALUE));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.ceilingPowerOfTwo((long)0L));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.ceilingPowerOfTwo((long)-1L));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.ceilingPowerOfTwo((long)Long.MIN_VALUE));
    }

    @Test
    void checkIntCeilingPowerOfTwo() {
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)Numbers.ceilingPowerOfTwo((int)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)Numbers.ceilingPowerOfTwo((int)2));
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)Numbers.ceilingPowerOfTwo((int)5));
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)Numbers.ceilingPowerOfTwo((int)32));
        org.junit.jupiter.api.Assertions.assertEquals((int)1024, (int)Numbers.ceilingPowerOfTwo((int)1023));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.ceilingPowerOfTwo((int)Integer.MAX_VALUE));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.ceilingPowerOfTwo((int)0));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.ceilingPowerOfTwo((int)-1));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.ceilingPowerOfTwo((int)Integer.MIN_VALUE));
    }

    @Test
    void checkPowerOfTwo() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Numbers.isPowerOfTwo((long)1L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Numbers.isPowerOfTwo((long)5L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Numbers.isPowerOfTwo((long)8L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Numbers.isPowerOfTwo((long)1024L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Numbers.isPowerOfTwo((long)Long.MAX_VALUE));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.isPowerOfTwo((long)0L));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.isPowerOfTwo((long)-1L));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Numbers.isPowerOfTwo((long)Long.MIN_VALUE));
    }

    @Test
    void shouldFloorPowerOfTwo() {
        long value = 35L;
        Assertions.assertThat((long)Numbers.floorPowerOfTwo((long)value)).isEqualTo(32L);
    }
}

