/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.net.URI;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Strings;

class StringsTest {
    StringsTest() {
    }

    @Test
    void testPrettyPrint() {
        Object[] recursiveArray;
        Assertions.assertEquals((Object)"null", (Object)Strings.prettyPrint(null));
        Assertions.assertEquals((Object)"42", (Object)Strings.prettyPrint((Object)42));
        Assertions.assertEquals((Object)"42", (Object)Strings.prettyPrint((Object)"42"));
        Assertions.assertEquals((Object)"[1, 2, 3, 4]", (Object)Strings.prettyPrint((Object)new int[]{1, 2, 3, 4}));
        Assertions.assertEquals((Object)"[false, true, true, false]", (Object)Strings.prettyPrint((Object)new boolean[]{false, true, true, false}));
        Assertions.assertEquals((Object)"[a, b, z]", (Object)Strings.prettyPrint((Object)new char[]{'a', 'b', 'z'}));
        Assertions.assertEquals((Object)"[ab, cd, zx]", (Object)Strings.prettyPrint((Object)new String[]{"ab", "cd", "zx"}));
        Assertions.assertEquals((Object)"[Cat, [http://neo4j.com, http://neo4j.org], Dog, [1, 2, 3], [[[Wolf]]]]", (Object)Strings.prettyPrint((Object)new Object[]{"Cat", new URI[]{URI.create("http://neo4j.com"), URI.create("http://neo4j.org")}, "Dog", new int[]{1, 2, 3}, new Object[]{new Object[]{new Object[]{"Wolf"}}}}));
        recursiveArray[1] = recursiveArray = new Object[]{10.12345, null, "String"};
        Assertions.assertEquals((Object)"[10.12345, [...], String]", (Object)Strings.prettyPrint((Object)recursiveArray));
    }

    @Test
    void testEscape() {
        Assertions.assertEquals((Object)"abc", (Object)Strings.escape((String)"abc"));
        Assertions.assertEquals((Object)"Abc", (Object)Strings.escape((String)"Abc"));
        Assertions.assertEquals((Object)"a\\\"bc", (Object)Strings.escape((String)"a\"bc"));
        Assertions.assertEquals((Object)"a\\'bc", (Object)Strings.escape((String)"a'bc"));
        Assertions.assertEquals((Object)"a\\\\bc", (Object)Strings.escape((String)"a\\bc"));
        Assertions.assertEquals((Object)"a\\nbc", (Object)Strings.escape((String)"a\nbc"));
        Assertions.assertEquals((Object)"a\\tbc", (Object)Strings.escape((String)"a\tbc"));
        Assertions.assertEquals((Object)"a\\rbc", (Object)Strings.escape((String)"a\rbc"));
        Assertions.assertEquals((Object)"a\\bbc", (Object)Strings.escape((String)"a\bbc"));
        Assertions.assertEquals((Object)"a\\fbc", (Object)Strings.escape((String)"a\fbc"));
    }

    @Test
    void testJoiningLines() {
        Assertions.assertEquals((Object)("a" + System.lineSeparator() + "b" + System.lineSeparator() + "c"), (Object)Strings.joinAsLines((String[])new String[]{"a", "b", "c"}));
    }

    @Test
    void testCodePoints() {
        String withEmoji = "a\ud83d\ude05bc";
        String startingWithEmoji = "\ud83d\ude05abc";
        String endingWithEmoji = "abc\ud83d\ude05";
        String justEmoji = "\ud83d\ude05";
        String normalString = "abc";
        String emptyString = "";
        for (String s : List.of(withEmoji, startingWithEmoji, endingWithEmoji, justEmoji, normalString, emptyString)) {
            Assertions.assertArrayEquals((int[])Strings.codePoints((String)s).toArray(), (int[])s.codePoints().toArray());
        }
    }
}

