/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPoolImpl;
import org.neo4j.memory.MemoryPools;

class LocalMemoryTrackerTest {
    LocalMemoryTrackerTest() {
    }

    @Test
    void trackDirectMemoryAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocateNative(10L);
        memoryTracker.allocateNative(20L);
        memoryTracker.allocateNative(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)70L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackDirectMemoryDeallocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocateNative(100L);
        org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)memoryTracker.usedNativeMemory());
        memoryTracker.releaseNative(20L);
        org.junit.jupiter.api.Assertions.assertEquals((long)80L, (long)memoryTracker.usedNativeMemory());
        memoryTracker.releaseNative(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)40L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackHeapMemoryAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocateHeap(10L);
        memoryTracker.allocateHeap(20L);
        memoryTracker.allocateHeap(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)70L, (long)memoryTracker.estimatedHeapMemory());
    }

    @Test
    void trackHeapMemoryDeallocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocateHeap(100L);
        org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.releaseHeap(20L);
        org.junit.jupiter.api.Assertions.assertEquals((long)80L, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.releaseHeap(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)40L, (long)memoryTracker.estimatedHeapMemory());
    }

    @Test
    void throwsOnLimitHeap() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 10L, 0L, "settingName");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> memoryTracker.allocateHeap(100L)).isInstanceOf(MemoryLimitExceededException.class)).hasMessageContaining("settingName");
        Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
    }

    @Test
    void throwsOnLimitNative() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 10L, 0L, "settingName");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> memoryTracker.allocateNative(100L)).isInstanceOf(MemoryLimitExceededException.class)).hasMessageContaining("settingName");
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isEqualTo(0L);
    }

    @Test
    void throwsOnPoolLimitHeap() {
        MemoryPoolImpl pool = new MemoryPoolImpl(5L, true, "poolSetting");
        LocalMemoryTracker tracker = new LocalMemoryTracker((MemoryPool)pool, 10L, 0L, "localSetting");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tracker.allocateHeap(10L)).isInstanceOf(MemoryLimitExceededException.class)).hasMessageContaining("poolSetting");
        Assertions.assertThat((long)tracker.estimatedHeapMemory()).isEqualTo(0L);
    }

    @Test
    void throwsOnPoolLimitNative() {
        MemoryPoolImpl pool = new MemoryPoolImpl(5L, true, "poolSetting");
        LocalMemoryTracker tracker = new LocalMemoryTracker((MemoryPool)pool, 10L, 0L, "localSetting");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tracker.allocateNative(10L)).isInstanceOf(MemoryLimitExceededException.class)).hasMessageContaining("poolSetting");
        Assertions.assertThat((long)tracker.usedNativeMemory()).isEqualTo(0L);
    }

    @Test
    void reuseAfterReportedDirectMemoryLeak() {
        LocalMemoryTracker tracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 10L, 0L, "localSetting");
        tracker.allocateNative(10L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((LocalMemoryTracker)tracker).reset()).isInstanceOf(AssertionError.class)).hasMessageContaining("Potential direct memory leak");
        tracker.allocateNative(10L);
        tracker.releaseNative(10L);
        tracker.reset();
    }

    @Test
    void shouldTellMonitorOnNativeMemoryLeak() {
        MutableLong leakedMemory = new MutableLong(-1L);
        LocalMemoryTracker tracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, Long.MAX_VALUE, 100L, "setting", () -> true, leakedNativeMemoryBytes -> {
            Assertions.assertThat((long)leakedMemory.longValue()).isEqualTo(-1L);
            leakedMemory.setValue(leakedNativeMemoryBytes);
        });
        int leakedAmount = 123;
        tracker.allocateNative((long)leakedAmount);
        tracker.allocateNative(5L);
        tracker.releaseNative(5L);
        Assertions.assertThatThrownBy(() -> ((LocalMemoryTracker)tracker).reset()).isInstanceOf(AssertionError.class);
        Assertions.assertThat((long)leakedMemory.longValue()).isEqualTo((long)leakedAmount);
    }
}

