/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database.readonly;

import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.kernel.api.exceptions.WriteOnReadOnlyAccessDbException;
import org.neo4j.kernel.database.NamedDatabaseId;

public interface DatabaseReadOnlyChecker {
    public static DatabaseReadOnlyChecker writable() {
        return WritableDatabaseReadOnlyChecker.INSTANCE;
    }

    public static DatabaseReadOnlyChecker readOnly() {
        return ReadOnlyDatabaseReadOnlyChecker.INSTANCE;
    }

    public boolean isReadOnly();

    public void check();

    public static class WritableDatabaseReadOnlyChecker
    implements DatabaseReadOnlyChecker {
        static final WritableDatabaseReadOnlyChecker INSTANCE = new WritableDatabaseReadOnlyChecker();

        private WritableDatabaseReadOnlyChecker() {
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public void check() {
        }
    }

    public static class ReadOnlyDatabaseReadOnlyChecker
    implements DatabaseReadOnlyChecker {
        static final ReadOnlyDatabaseReadOnlyChecker INSTANCE = new ReadOnlyDatabaseReadOnlyChecker();

        private ReadOnlyDatabaseReadOnlyChecker() {
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void check() {
            throw new RuntimeException((Throwable)((Object)new WriteOnReadOnlyAccessDbException()));
        }
    }

    public static class Default
    implements DatabaseReadOnlyChecker {
        private volatile long lastUpdated = -1L;
        private volatile boolean readOnly = false;
        private final ReadOnlyDatabases dbmsChecker;
        private final NamedDatabaseId namedDatabaseId;

        Default(ReadOnlyDatabases readOnlyDatabases, NamedDatabaseId namedDatabaseId) {
            this.dbmsChecker = readOnlyDatabases;
            this.namedDatabaseId = namedDatabaseId;
        }

        @Override
        public boolean isReadOnly() {
            long globalUpdate = this.dbmsChecker.updateId();
            if (this.lastUpdated != globalUpdate) {
                this.readOnly = this.dbmsChecker.isReadOnly(this.namedDatabaseId.databaseId());
                this.lastUpdated = globalUpdate;
            }
            return this.readOnly;
        }

        @Override
        public void check() {
            if (this.isReadOnly()) {
                throw new RuntimeException((Throwable)((Object)new WriteOnReadOnlyAccessDbException(this.namedDatabaseId.name())));
            }
        }
    }
}

