/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class HostnamePort {
    private final String host;
    private final int[] ports;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HostnamePort(String hostnamePort) {
        Objects.requireNonNull(hostnamePort);
        String[] parts = HostnamePort.splitHostAndPort(hostnamePort);
        if (parts.length == 1) {
            this.host = (String)StringUtils.defaultIfBlank((CharSequence)parts[0], null);
            this.ports = new int[]{0, 0};
            return;
        } else {
            if (parts.length != 2) throw new IllegalArgumentException(hostnamePort);
            this.host = (String)StringUtils.defaultIfBlank((CharSequence)parts[0], null);
            String[] portStrings = parts[1].split("-");
            this.ports = new int[2];
            if (portStrings.length == 1) {
                this.ports[0] = this.ports[1] = Integer.parseInt(portStrings[0]);
                return;
            } else {
                if (portStrings.length != 2) throw new IllegalArgumentException(String.format("Cannot have more than two port ranges: %s", hostnamePort));
                this.ports[0] = Integer.parseInt(portStrings[0]);
                this.ports[1] = Integer.parseInt(portStrings[1]);
            }
        }
    }

    public HostnamePort(String host, int port) {
        this(host, port, port);
    }

    public HostnamePort(String host, int portFrom, int portTo) {
        this.host = host;
        this.ports = new int[]{portFrom, portTo};
    }

    public String getHost() {
        return this.host;
    }

    public static String getHostAddress(String host, String defaultHost) {
        if (host == null) {
            return defaultHost;
        }
        return host;
    }

    public String getHost(String defaultHost) {
        return HostnamePort.getHostAddress(this.host, defaultHost);
    }

    public int[] getPorts() {
        return this.ports;
    }

    public int getPort() {
        return this.ports[0];
    }

    public boolean isRange() {
        return this.ports[0] != this.ports[1];
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String defaultHost) {
        StringBuilder builder = new StringBuilder();
        String host = this.getHost(defaultHost);
        if (host != null) {
            builder.append(host);
        }
        if (this.getPort() != 0) {
            builder.append(':');
            builder.append(this.getPort());
            if (this.isRange()) {
                builder.append('-').append(this.getPorts()[1]);
            }
        }
        return builder.toString();
    }

    public boolean matches(URI toMatch) {
        boolean result = false;
        for (int port = this.ports[0]; port <= this.ports[1]; ++port) {
            if (port != toMatch.getPort()) continue;
            result = true;
            break;
        }
        if (this.host == null && toMatch.getHost() == null) {
            return result;
        }
        if (this.host == null) {
            return false;
        }
        String toMatchHost = toMatch.getHost();
        return result && (this.host.equalsIgnoreCase(toMatchHost) || this.getHost(null).equalsIgnoreCase(HostnamePort.getHostAddress(toMatchHost, toMatchHost)));
    }

    private static String[] splitHostAndPort(String hostnamePort) {
        boolean isIPv6HostPort;
        int indexOfSchemaSeparator = (hostnamePort = hostnamePort.trim()).indexOf("://");
        if (indexOfSchemaSeparator != -1) {
            hostnamePort = hostnamePort.substring(indexOfSchemaSeparator + 3);
        }
        boolean bl = isIPv6HostPort = hostnamePort.startsWith("[") && hostnamePort.contains("]");
        if (isIPv6HostPort) {
            int splitIndex = hostnamePort.indexOf(93) + 1;
            String host = hostnamePort.substring(0, splitIndex);
            String port = hostnamePort.substring(splitIndex);
            if (StringUtils.isNotBlank((CharSequence)port)) {
                port = port.substring(1);
                return new String[]{host, port};
            }
            return new String[]{host};
        }
        return hostnamePort.split(":");
    }

    public SocketAddress toSocketAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostnamePort that = (HostnamePort)o;
        return Objects.equals(this.host, that.host) && Arrays.equals(this.ports, that.ports);
    }

    public int hashCode() {
        return Objects.hash(this.host, Arrays.hashCode(this.ports));
    }
}

