/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import org.neo4j.internal.helpers.Exceptions;

public interface ThrowingAction<E extends Exception> {
    public void apply() throws E;

    public static <E extends Exception> ThrowingAction<E> noop() {
        return () -> {};
    }

    public static void executeAll(ThrowingAction<?> ... actions) throws Exception {
        Exception error = null;
        for (ThrowingAction<?> action : actions) {
            try {
                action.apply();
            }
            catch (Exception e) {
                error = Exceptions.chain(error, e);
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

