/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.common;

import java.util.Iterator;
import java.util.function.Supplier;

public interface DependencyResolver {
    default public <T> T resolveDependency(Class<T> type) {
        return this.resolveDependency(type, SelectionStrategy.SINGLE);
    }

    public <T> T resolveDependency(Class<T> var1, SelectionStrategy var2);

    default public <T> Iterable<T> resolveTypeDependencies(Class<T> type) {
        throw new UnsupportedOperationException("not implemented");
    }

    default public <T> Supplier<T> provideDependency(Class<T> type) {
        return () -> this.resolveDependency(type);
    }

    public boolean containsDependency(Class<?> var1);

    public static interface SelectionStrategy {
        public static final SelectionStrategy SINGLE = new SelectionStrategy(){

            @Override
            public <T> T select(Class<T> type, Iterable<? extends T> candidates) throws IllegalArgumentException {
                Iterator<T> iterator = candidates.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
                }
                T only = iterator.next();
                if (iterator.hasNext()) {
                    throw new IllegalArgumentException("Multiple dependencies of type:" + type.getName());
                }
                return only;
            }
        };

        public <T> T select(Class<T> var1, Iterable<? extends T> var2) throws IllegalArgumentException;
    }
}

