/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.neo4j.internal.helpers.progress.Indicator;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

final class Aggregator {
    private final Map<ProgressListener, State> states = new HashMap<ProgressListener, State>();
    private final Indicator indicator;
    private final ProgressMonitorFactory.IndicatorListener listener;
    private volatile long progress;
    private volatile int last;
    private static final AtomicLongFieldUpdater<Aggregator> PROGRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(Aggregator.class, "progress");
    private volatile long totalCount;

    Aggregator(Indicator indicator, ProgressMonitorFactory.IndicatorListener listener) {
        this.indicator = indicator;
        this.listener = listener;
    }

    synchronized void add(ProgressListener progress, long totalCount) {
        this.states.put(progress, State.INIT);
        this.totalCount += totalCount;
    }

    synchronized ProgressMonitorFactory.Completer initialize() {
        this.indicator.startProcess(this.totalCount);
        if (this.states.isEmpty()) {
            this.indicator.progress(0, this.indicator.reportResolution());
        }
        ArrayList<ProgressListener> progressesToClose = new ArrayList<ProgressListener>(this.states.keySet());
        return () -> progressesToClose.forEach(ProgressListener::close);
    }

    void update(long delta) {
        int current;
        long progress;
        if (delta > 0L && (progress = Long.min(this.totalCount, PROGRESS_UPDATER.addAndGet(this, delta))) > 0L && (current = (int)(progress * (long)this.indicator.reportResolution() / this.totalCount)) > this.last) {
            this.updateTo(current, progress);
        }
    }

    private synchronized void updateTo(int to, long progress) {
        if (to > this.last) {
            this.indicator.progress(this.last, to);
            this.listener.update(progress, this.totalCount);
            this.last = to;
        }
    }

    void updateRemaining() {
        this.updateTo(this.indicator.reportResolution(), this.totalCount);
    }

    synchronized void start(ProgressListener.MultiPartProgressListener part) {
        this.states.put(part, State.LIVE);
    }

    synchronized void complete(ProgressListener.MultiPartProgressListener part) {
        if (this.states.remove(part) != null && this.states.isEmpty()) {
            this.updateRemaining();
        }
    }

    synchronized void signalFailure(Throwable e) {
        this.indicator.failure(e);
    }

    void done() {
        this.states.keySet().forEach(ProgressListener::close);
    }

    void mark(char mark) {
        this.indicator.mark(mark);
    }

    static enum State {
        INIT,
        LIVE;

    }
}

