/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.Arrays;
import org.neo4j.util.BitUtils;

public final class BitBuffer {
    private final long[] longs;
    private final int numberOfBytes;
    private int writePosition;
    private int readPosition;

    public static BitBuffer bits(int numberOfBytes) {
        int requiredLongs = BitBuffer.requiredLongs(numberOfBytes);
        return new BitBuffer(new long[requiredLongs], numberOfBytes);
    }

    public static int requiredLongs(int numberOfBytes) {
        return (numberOfBytes - 1 >> 3) + 1;
    }

    public static BitBuffer bitsFromLongs(long[] longs) {
        return new BitBuffer(longs, longs.length << 3);
    }

    public static BitBuffer bitsFromBytes(byte[] bytes) {
        return BitBuffer.bitsFromBytes(bytes, 0);
    }

    public static BitBuffer bitsFromBytes(byte[] bytes, int startIndex) {
        int count = bytes.length;
        BitBuffer bits = BitBuffer.bits(count - startIndex);
        for (int i = startIndex; i < count; ++i) {
            bits.put(bytes[i]);
        }
        return bits;
    }

    public static BitBuffer bitsFromBytes(byte[] bytes, int offset, int length) {
        BitBuffer bits = BitBuffer.bits(length - offset);
        for (int i = offset; i < offset + length; ++i) {
            bits.put(bytes[i]);
        }
        return bits;
    }

    private BitBuffer(long[] longs, int numberOfBytes) {
        this.longs = longs;
        this.numberOfBytes = numberOfBytes;
    }

    public static long rightOverflowMask(int steps) {
        return -1L >>> 64 - steps;
    }

    public long[] getLongs() {
        return this.longs;
    }

    public byte[] asBytes() {
        return this.asBytes(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] asBytes(int offsetBytes) {
        int readPositionBefore = this.readPosition;
        this.readPosition = 0;
        try {
            byte[] result = new byte[this.numberOfBytes + offsetBytes];
            for (int i = 0; i < this.numberOfBytes; ++i) {
                result[i + offsetBytes] = this.getByte();
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            this.readPosition = readPositionBefore;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int longIndex = this.longs.length - 1; longIndex >= 0; --longIndex) {
            long value = this.longs[longIndex];
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(longIndex);
            builder.append(':');
            BitUtils.numberToString(builder, value, 8);
            if (longIndex != 0) continue;
            builder.append(" <-- START");
        }
        return builder.toString();
    }

    public BitBuffer put(byte value) {
        return this.put(value, 8);
    }

    public BitBuffer put(byte value, int steps) {
        return this.put((long)value, steps);
    }

    public BitBuffer put(short value) {
        return this.put(value, 16);
    }

    public BitBuffer put(short value, int steps) {
        return this.put((long)value, steps);
    }

    public BitBuffer put(int value) {
        return this.put(value, 32);
    }

    public BitBuffer put(int value, int steps) {
        return this.put((long)value, steps);
    }

    public BitBuffer put(long value) {
        return this.put(value, 64);
    }

    public BitBuffer put(long value, int steps) {
        int lowLongIndex = this.writePosition >> 6;
        int lowBitInLong = this.writePosition % 64;
        int lowBitsAvailable = 64 - lowBitInLong;
        long lowValueMask = BitBuffer.rightOverflowMask(Math.min(lowBitsAvailable, steps));
        int n = lowLongIndex;
        this.longs[n] = this.longs[n] | (value & lowValueMask) << lowBitInLong;
        if (steps > lowBitsAvailable) {
            long highValueMask = BitBuffer.rightOverflowMask(steps - lowBitsAvailable);
            int n2 = lowLongIndex + 1;
            this.longs[n2] = this.longs[n2] | value >>> lowBitsAvailable & highValueMask;
        }
        this.writePosition += steps;
        return this;
    }

    public BitBuffer put(byte[] bytes, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.put(bytes[i], 8);
        }
        return this;
    }

    public boolean available() {
        return this.readPosition < this.writePosition;
    }

    public byte getByte() {
        return this.getByte(8);
    }

    public byte getByte(int steps) {
        return (byte)this.getLong(steps);
    }

    public short getShort() {
        return this.getShort(16);
    }

    public short getShort(int steps) {
        return (short)this.getLong(steps);
    }

    public int getInt() {
        return this.getInt(32);
    }

    public int getInt(int steps) {
        return (int)this.getLong(steps);
    }

    public long getUnsignedInt() {
        return (long)this.getInt(32) & 0xFFFFFFFFL;
    }

    public long getLong() {
        return this.getLong(64);
    }

    public long getLong(int steps) {
        int lowLongIndex = this.readPosition >> 6;
        int lowBitInLong = this.readPosition % 64;
        int lowBitsAvailable = 64 - lowBitInLong;
        long lowLongMask = BitBuffer.rightOverflowMask(Math.min(lowBitsAvailable, steps)) << lowBitInLong;
        long lowValue = this.longs[lowLongIndex] & lowLongMask;
        long result = lowValue >>> lowBitInLong;
        if (steps > lowBitsAvailable) {
            long highLongMask = BitBuffer.rightOverflowMask(steps - lowBitsAvailable);
            result |= (this.longs[lowLongIndex + 1] & highLongMask) << lowBitsAvailable;
        }
        this.readPosition += steps;
        return result;
    }

    public void clear(boolean zeroBits) {
        if (zeroBits) {
            Arrays.fill(this.longs, 0L);
        }
        this.writePosition = 0;
        this.readPosition = 0;
    }

    public int longsInUse() {
        return (this.writePosition - 1) / 64 + 1;
    }
}

