/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.neo4j.function;

/**
 * Represents a function that accepts one {@code int} argument and produces a result, or throws an exception.
 * @param <R> the type of the result of the function
 * @param <E> the type of exception that may be thrown from the function
 */
@FunctionalInterface
public interface ThrowingIntFunction<R, E extends Exception> {
    /**
     * Apply a value to this function.
     *
     * @param value the function argument
     * @return the function result
     * @throws E an exception if the function fails
     */
    R apply(int value) throws E;
}
