/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.StringJoiner;
import org.neo4j.common.Edition;
import org.neo4j.kernel.KernelVersion;

public record DbStatistics(String storeVersion, KernelVersion kernelVersion, long lastCommittedTransactionId, Edition edition, int nodes, int sparseNodes, int denseNodes, int highNodeId, int nodeProperties, int relationships, int highRelationshipId, int relationshipProperties, int indexes, int lookupIndexes, int btreeIndexes, int constraints, int btreeConstraints, int schemaEntities) {
    public static final int NO_DATA = -1;

    public String statisticsAsConstructorString() {
        StringJoiner newStatisticsString = new StringJoiner(", ", "new DbStatistics( ", " )");
        newStatisticsString.add("\"" + this.storeVersion + "\"");
        newStatisticsString.add((CharSequence)(this.kernelVersion != null ? "KernelVersion." + this.kernelVersion.name() : "null"));
        newStatisticsString.add("" + this.lastCommittedTransactionId);
        newStatisticsString.add(this.edition.name());
        newStatisticsString.add("" + this.nodes);
        newStatisticsString.add("" + this.sparseNodes);
        newStatisticsString.add("" + this.denseNodes);
        newStatisticsString.add("" + this.highNodeId);
        newStatisticsString.add("" + this.nodeProperties);
        newStatisticsString.add("" + this.relationships);
        newStatisticsString.add("" + this.highRelationshipId);
        newStatisticsString.add("" + this.relationshipProperties);
        newStatisticsString.add("" + this.indexes);
        newStatisticsString.add("" + this.lookupIndexes);
        newStatisticsString.add("" + this.btreeIndexes);
        newStatisticsString.add("" + this.constraints);
        newStatisticsString.add("" + this.btreeConstraints);
        newStatisticsString.add("" + this.schemaEntities);
        return newStatisticsString.toString();
    }
}

