/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.function.Suppliers;

class SuppliersTest {
    SuppliersTest() {
    }

    @Test
    void singletonSupplierShouldAlwaysReturnSame() {
        Object o = new Object();
        Supplier supplier = Suppliers.singleton((Object)o);
        Assertions.assertThat(supplier.get()).isSameAs(o);
        Assertions.assertThat(supplier.get()).isSameAs(o);
        Assertions.assertThat(supplier.get()).isSameAs(o);
    }

    @Test
    void lazySingletonSupplierShouldOnlyRequestInstanceWhenRequired() {
        Object o = new Object();
        Supplier mockSupplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when(mockSupplier.get()).thenReturn(o);
        Suppliers.Lazy supplier = Suppliers.lazySingleton((Supplier)mockSupplier);
        Mockito.verifyNoInteractions((Object[])new Object[]{mockSupplier});
        Assertions.assertThat(supplier.get()).isSameAs(o);
        Assertions.assertThat(supplier.get()).isSameAs(o);
        Assertions.assertThat(supplier.get()).isSameAs(o);
        ((Supplier)Mockito.verify((Object)mockSupplier)).get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockSupplier});
    }

    @Test
    void adaptedSupplierShouldOnlyCallAdaptorOnceForEachNewInstance() {
        Object o1 = new Object();
        Object o1a = new Object();
        Object o2 = new Object();
        Object o2a = new Object();
        Object o3 = new Object();
        Object o3a = new Object();
        Supplier mockSupplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when(mockSupplier.get()).thenReturn(o1, new Object[]{o1, o1, o2, o3, o3});
        Function mockFunction = (Function)Mockito.mock(Function.class);
        Mockito.when(mockFunction.apply(o1)).thenReturn(o1a);
        Mockito.when(mockFunction.apply(o2)).thenReturn(o2a);
        Mockito.when(mockFunction.apply(o3)).thenReturn(o3a);
        Supplier supplier = Suppliers.adapted((Supplier)mockSupplier, (Function)mockFunction);
        Assertions.assertThat(supplier.get()).isSameAs(o1a);
        Assertions.assertThat(supplier.get()).isSameAs(o1a);
        Assertions.assertThat(supplier.get()).isSameAs(o1a);
        Assertions.assertThat(supplier.get()).isSameAs(o2a);
        Assertions.assertThat(supplier.get()).isSameAs(o3a);
        Assertions.assertThat(supplier.get()).isSameAs(o3a);
        ((Function)Mockito.verify((Object)mockFunction)).apply(o1);
        ((Function)Mockito.verify((Object)mockFunction)).apply(o2);
        ((Function)Mockito.verify((Object)mockFunction)).apply(o3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockFunction});
    }

    @Test
    void correctlyReportNotInitialisedSuppliers() {
        Suppliers.Lazy lazySingleton = Suppliers.lazySingleton(() -> "a");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lazySingleton.isInitialised());
        org.junit.jupiter.api.Assertions.assertNull((Object)lazySingleton.getIfPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"null", (Object)lazySingleton.toString());
    }

    @Test
    void correctlyReportInitialisedSuppliers() {
        Suppliers.Lazy lazySingleton = Suppliers.lazySingleton(() -> "a");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lazySingleton.get());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)lazySingleton.isInitialised());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lazySingleton.getIfPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)lazySingleton.toString());
    }
}

