/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.MathUtil;

class MathUtilTest {
    MathUtilTest() {
    }

    @Test
    void shouldClampInt() {
        int value = 12345;
        Assertions.assertThat((int)MathUtil.clamp((int)value, (int)(value - 10), (int)(value + 10))).isEqualTo(value);
        Assertions.assertThat((int)MathUtil.clamp((int)value, (int)(value + 10), (int)(value + 100))).isEqualTo(value + 10);
        Assertions.assertThat((int)MathUtil.clamp((int)value, (int)(value - 100), (int)(value - 10))).isEqualTo(value - 10);
    }

    @Test
    void shouldClampLong() {
        long value = 123456789000L;
        Assertions.assertThat((long)MathUtil.clamp((long)value, (long)(value - 10L), (long)(value + 10L))).isEqualTo(value);
        Assertions.assertThat((long)MathUtil.clamp((long)value, (long)(value + 10L), (long)(value + 100L))).isEqualTo(value + 10L);
        Assertions.assertThat((long)MathUtil.clamp((long)value, (long)(value - 100L), (long)(value - 10L))).isEqualTo(value - 10L);
    }

    @Test
    void shouldClampFloat() {
        float value = 123.456f;
        Assertions.assertThat((double)MathUtil.clamp((double)value, (double)((double)value - 1.5), (double)((double)value + 1.5))).isEqualTo((double)value);
        Assertions.assertThat((double)MathUtil.clamp((double)value, (double)((double)value + 1.5), (double)(value + 3.0f))).isEqualTo((double)value + 1.5);
        Assertions.assertThat((double)MathUtil.clamp((double)value, (double)(value - 3.0f), (double)((double)value - 1.5))).isEqualTo((double)value - 1.5);
    }

    @Test
    void shouldClampDouble() {
        double value = 123.456;
        Assertions.assertThat((double)MathUtil.clamp((double)value, (double)(value - 1.5), (double)(value + 1.5))).isEqualTo(value);
        Assertions.assertThat((double)MathUtil.clamp((double)value, (double)(value + 1.5), (double)(value + 3.0))).isEqualTo(value + 1.5);
        Assertions.assertThat((double)MathUtil.clamp((double)value, (double)(value - 3.0), (double)(value - 1.5))).isEqualTo(value - 1.5);
    }
}

