/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database.readonly;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.readonly.ReadOnlyChangeListener;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.NamedDatabaseId;

public class DefaultReadOnlyDatabases
implements ReadOnlyDatabases {
    private final ReadOnlyChangeListener listener;
    private volatile Set<ReadOnlyDatabases.Lookup> readOnlyDatabases;
    private volatile long updateId;
    private final Set<ReadOnlyDatabases.LookupFactory> readOnlyDatabasesLookupFactories;

    public DefaultReadOnlyDatabases(ReadOnlyDatabases.LookupFactory ... readOnlyDatabasesLookupFactories) {
        this(ReadOnlyChangeListener.NO_OP, readOnlyDatabasesLookupFactories);
    }

    public DefaultReadOnlyDatabases(ReadOnlyChangeListener listener, ReadOnlyDatabases.LookupFactory ... readOnlyDatabasesLookupFactories) {
        this.readOnlyDatabasesLookupFactories = Set.of(readOnlyDatabasesLookupFactories);
        this.readOnlyDatabases = Set.of();
        this.updateId = -1L;
        this.listener = listener;
    }

    @Override
    public boolean isReadOnly(DatabaseId databaseId) {
        Objects.requireNonNull(databaseId);
        if (databaseId.isSystemDatabase()) {
            return false;
        }
        return this.readOnlyDatabases.stream().anyMatch(l -> l.databaseIsReadOnly(databaseId));
    }

    @Override
    public long updateId() {
        return this.updateId;
    }

    @Override
    public Set<ReadOnlyDatabases.Lookup.Source> readonlySources(DatabaseId databaseId) {
        Objects.requireNonNull(databaseId);
        if (databaseId.isSystemDatabase()) {
            return Set.of();
        }
        return this.readOnlyDatabases.stream().filter(l -> l.databaseIsReadOnly(databaseId)).map(ReadOnlyDatabases.Lookup::source).collect(Collectors.toSet());
    }

    @Override
    public DatabaseReadOnlyChecker forDatabase(NamedDatabaseId namedDatabaseId) {
        Objects.requireNonNull(namedDatabaseId);
        if (namedDatabaseId.isSystemDatabase()) {
            return DatabaseReadOnlyChecker.writable();
        }
        this.refresh();
        return new DatabaseReadOnlyChecker.Default(this, namedDatabaseId);
    }

    @Override
    public synchronized void refresh() {
        ++this.updateId;
        this.readOnlyDatabases = this.readOnlyDatabasesLookupFactories.stream().map(ReadOnlyDatabases.LookupFactory::lookupReadOnlyDatabases).collect(Collectors.toUnmodifiableSet());
        this.listener.onRefresh(this);
    }
}

