/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.neo4j.string.EncodingUtils;

public class ProcessUtils {
    public static String executeCommand(String command, Duration timeout) {
        String[] commands = new StringTokenizer(command, StringMatcherFactory.INSTANCE.splitMatcher(), StringMatcherFactory.INSTANCE.quoteMatcher()).getTokenArray();
        return ProcessUtils.executeCommand(commands, timeout);
    }

    public static String executeCommand(String[] commands, Duration timeout) {
        Process process = null;
        try {
            process = new ProcessBuilder(commands).start();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Thread outGobbler = ProcessUtils.streamGobbler(process.getInputStream(), out);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            Thread errGobbler = ProcessUtils.streamGobbler(process.getErrorStream(), err);
            if (!process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new IllegalArgumentException(String.format("Timed out executing command `%s`", Arrays.toString(commands)));
            }
            outGobbler.join();
            errGobbler.join();
            String output = StringUtils.chomp((String)out.toString(EncodingUtils.getNativeCharset()));
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new IllegalArgumentException(String.format("Command `%s` failed with exit code %s.%n%s%n%s", Arrays.toString(commands), exitCode, output, StringUtils.chomp((String)err.toString(EncodingUtils.getNativeCharset()))));
            }
            String string = output;
            return string;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalArgumentException("Interrupted while executing command", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }

    private static Thread streamGobbler(InputStream from, OutputStream to) {
        Thread thread = new Thread(() -> {
            try {
                from.transferTo(to);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        thread.start();
        return thread;
    }
}

