/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.progress.Indicator;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

class IndicatorTest {
    IndicatorTest() {
    }

    @Test
    void shouldIncludeDeltaTimes() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(bout);
        FakeClock clock = new FakeClock();
        Indicator.Textual indicator = new Indicator.Textual("Test", out, true, (SystemNanoClock)clock, 'D', 20, 1, 10);
        int line = 0;
        clock.forward(1L, TimeUnit.SECONDS);
        indicator.progress(20 * line, 20 * ++line);
        clock.forward(100L, TimeUnit.MILLISECONDS);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        indicator.progress(20 * line, 20 * ++line);
        clock.forward(3L, TimeUnit.SECONDS);
        indicator.progress(20 * line, 20 * ++line);
        out.flush();
        String output = bout.toString();
        Assertions.assertThat((String)output).contains(new CharSequence[]{"10% D1s"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"20% D100ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"40% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"50% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"60% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"70% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"80% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"90% D0ms"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"100% D3s"});
    }

    @Test
    void shouldConfigureNumberOfDotsAndLines() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(bout);
        int dotsPerLine = 5;
        int lines = 4;
        Indicator.Textual indicator = new Indicator.Textual("Test", out, false, Clocks.nanoClock(), ' ', dotsPerLine, 1, lines);
        indicator.progress(0, dotsPerLine * lines);
        out.flush();
        String output = bout.toString();
        Assertions.assertThat((String)output).contains(new CharSequence[]{".....  25%"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{".....  50%"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{".....  75%"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"..... 100%"});
    }

    @Test
    void shouldConfigureNumberOfDotsAndGroupsLines() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(bout);
        int dotsPerGroup = 5;
        int groupsPerLine = 3;
        int lines = 5;
        Indicator.Textual indicator = new Indicator.Textual("Test", out, false, Clocks.nanoClock(), ' ', dotsPerGroup, groupsPerLine, lines);
        indicator.progress(0, groupsPerLine * dotsPerGroup * lines);
        out.flush();
        String output = bout.toString();
        Assertions.assertThat((String)output).contains(new CharSequence[]{"..... ..... .....  20%"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"..... ..... .....  40%"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"..... ..... .....  60%"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"..... ..... .....  80%"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"..... ..... ..... 100%"});
    }

    @Test
    void shouldPrintMarks() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(bout);
        Indicator.Textual indicator = new Indicator.Textual("Test", out, false, Clocks.nanoClock(), ' ', 10, 1, 2);
        indicator.progress(0, 5);
        indicator.mark('1');
        indicator.progress(5, 12);
        indicator.mark('2');
        indicator.progress(12, 20);
        out.flush();
        String output = bout.toString();
        Assertions.assertThat((String)output).contains(new CharSequence[]{".....1....  50%"});
        Assertions.assertThat((String)output).contains(new CharSequence[]{"..2....... 100%"});
    }
}

