/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.LockSupport;

public class BinaryLatch {
    private static final int MAX_SPINS = Runtime.getRuntime().availableProcessors() < 2 ? 1 : 256;
    private static final Node end = new Node();
    private static final Node released = new Node();
    private static final byte waiterStateSuccessor = 1;
    private static final byte waiterStateReleased = 2;
    private Node stack;
    private static final VarHandle STACK;

    public void release() {
        Node waiters = STACK.getAndSet(this, released);
        if (waiters == null) {
            return;
        }
        BinaryLatch.unparkSuccessor(waiters);
    }

    private static void unparkSuccessor(Node waiters) {
        if (waiters.getClass() == Waiter.class) {
            Waiter waiter = (Waiter)waiters;
            waiter.state = 1;
            LockSupport.unpark(waiter.waitingThread);
        }
    }

    public void await() {
        Node state = STACK.getVolatile(this);
        if (state != released) {
            Waiter waiter = new Waiter();
            state = STACK.getAndSet(this, waiter);
            if (state == released) {
                Node others = STACK.getAndSet(this, released);
                waiter.next = released;
                BinaryLatch.unparkAll(others);
            } else {
                waiter.next = state == null ? end : state;
                int count = 0;
                do {
                    if (count < MAX_SPINS) {
                        Thread.onSpinWait();
                        ++count;
                        continue;
                    }
                    LockSupport.park(this);
                } while (!this.isReleased(waiter));
            }
        }
    }

    private boolean isReleased(Waiter waiter) {
        Node next;
        if (waiter.state == 1) {
            BinaryLatch.unparkAll(waiter.next);
            return true;
        }
        Node state = STACK.getVolatile(this);
        do {
            if (state == released) {
                if (waiter.state != 2) {
                    BinaryLatch.unparkAll(waiter.next);
                }
                return true;
            }
            while ((next = state.next) == null) {
            }
        } while ((state = next) != end);
        return false;
    }

    private static void unparkAll(Node waiters) {
        while (waiters.getClass() == Waiter.class) {
            Node next;
            Waiter waiter = (Waiter)waiters;
            waiter.state = (byte)2;
            LockSupport.unpark(waiter.waitingThread);
            while ((next = waiters.next) == null) {
            }
            waiters = next;
        }
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            STACK = l.findVarHandle(BinaryLatch.class, "stack", Node.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class Node {
        volatile Node next;

        private Node() {
        }
    }

    private static final class Waiter
    extends Node {
        final Thread waitingThread = Thread.currentThread();
        volatile byte state;

        private Waiter() {
        }
    }
}

