/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.internal.helpers.Exceptions;

public final class Futures {
    private Futures() {
    }

    @SafeVarargs
    public static <V> Future<List<V>> combine(Future<? extends V> ... futures) {
        return Futures.combine(Arrays.asList(futures));
    }

    public static <V> List<V> getAllResults(Iterable<? extends Future<V>> futures) throws ExecutionException {
        ArrayList<V> result = futures instanceof Collection ? new ArrayList<V>(((Collection)futures).size()) : new ArrayList();
        Throwable finalError = null;
        for (Future<V> future : futures) {
            try {
                result.add(future.get());
            }
            catch (Throwable e) {
                finalError = Exceptions.chain(finalError, (Throwable)e);
            }
        }
        if (finalError != null) {
            throw new ExecutionException(finalError);
        }
        return result;
    }

    public static void getAll(Iterable<? extends Future<?>> futures) throws ExecutionException {
        Throwable finalError = null;
        for (Future<?> future : futures) {
            try {
                future.get();
            }
            catch (Throwable e) {
                finalError = Exceptions.chain(finalError, (Throwable)e);
            }
        }
        if (finalError != null) {
            throw new ExecutionException(finalError);
        }
    }

    public static <V> Future<List<V>> combine(final Iterable<? extends Future<? extends V>> futures) {
        return new Future<List<V>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result = false;
                for (Future future : futures) {
                    result |= future.cancel(mayInterruptIfRunning);
                }
                return result;
            }

            @Override
            public boolean isCancelled() {
                boolean result = false;
                for (Future future : futures) {
                    result |= future.isCancelled();
                }
                return result;
            }

            @Override
            public boolean isDone() {
                boolean result = false;
                for (Future future : futures) {
                    result |= future.isDone();
                }
                return result;
            }

            @Override
            public List<V> get() throws InterruptedException, ExecutionException {
                ArrayList result = new ArrayList();
                for (Future future : futures) {
                    result.add(future.get());
                }
                return result;
            }

            @Override
            public List<V> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                ArrayList result = new ArrayList();
                for (Future future : futures) {
                    long before = System.nanoTime();
                    result.add(future.get(timeout, unit));
                    timeout -= unit.convert(System.nanoTime() - before, TimeUnit.NANOSECONDS);
                }
                return result;
            }
        };
    }
}

