/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.internal.helpers.NamedThreadFactory;

public class IdSpaceParallelExecution {
    private IdSpaceParallelExecution() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runInParallel(String threadNamePrefix, int threads, long highIndex, Function<Partition, Callable<Void>> taskFactory) throws ExecutionException {
        long indexesPerThread = MathUtil.ceil((long)highIndex, (long)threads);
        long index = 0L;
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (int i = 0; i < threads && index < highIndex; ++i) {
            long startIndex = index;
            long endIndex = Math.min(index + indexesPerThread, highIndex);
            tasks.add(taskFactory.apply(new Partition(startIndex, endIndex, i)));
            index = endIndex;
        }
        if (!tasks.isEmpty()) {
            ExecutorService executor = Executors.newFixedThreadPool(tasks.size(), (ThreadFactory)NamedThreadFactory.named((String)threadNamePrefix));
            try {
                for (Future future : executor.invokeAll(tasks)) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                executor.shutdown();
            }
        }
    }

    public record Partition(long startInclusive, long endExclusive, int partitionId) {
    }
}

