/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;

public class ExternalSettings
implements LoadableConfig {
    @Description(value="Name of the Windows Service.")
    public static final Setting<String> windowsServiceName = ExternalSettings.dummySetting("dbms.windows_service_name", "neo4j");
    @Description(value="Additional JVM arguments. Argument order can be significant. To use a Java commercial feature, the argument to unlock commercial features must precede the argument to enable the specific feature in the config value string. For example, to use Flight Recorder, `-XX:+UnlockCommercialFeatures` must come before `-XX:+FlightRecorder`.")
    public static final Setting<String> additionalJvm = ExternalSettings.dummySetting("dbms.jvm.additional");
    @Description(value="Initial heap size. By default it is calculated based on available system resources.")
    public static final Setting<String> initialHeapSize = ExternalSettings.dummySetting("dbms.memory.heap.initial_size", "", "a byte size (valid units are `k`, `K`, `m`, `M`, `g`, `G`)");
    @Description(value="Maximum heap size. By default it is calculated based on available system resources.")
    public static final Setting<String> maxHeapSize = ExternalSettings.dummySetting("dbms.memory.heap.max_size", "", "a byte size (valid units are `k`, `K`, `m`, `M`, `g`, `G`)");

    private static DummySetting dummySetting(String name) {
        return new DummySetting(name, "", "a string");
    }

    private static DummySetting dummySetting(String name, String defVal) {
        return new DummySetting(name, defVal, "a string");
    }

    private static DummySetting dummySetting(String name, String defVal, String valDesc) {
        return new DummySetting(name, defVal, valDesc);
    }

    static class DummySetting
    extends BaseSetting<String> {
        private final String name;
        private final String defaultValue;
        private final String valueDescription;

        DummySetting(String name, String defVal, String valueDescription) {
            this.name = name;
            this.defaultValue = defVal;
            this.valueDescription = valueDescription;
        }

        public String name() {
            return this.name;
        }

        public void withScope(Function<String, String> scopingRule) {
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String from(Configuration config) {
            return (String)config.get((Setting)this);
        }

        public String apply(Function<String, String> provider) {
            return provider.apply(this.name);
        }

        public List<Setting<String>> settings(Map<String, String> params) {
            return Collections.singletonList(this);
        }

        public String valueDescription() {
            return this.valueDescription;
        }
    }
}

