/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.SettingConstraint;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.Numbers;

public final class SettingConstraints {
    public static final SettingConstraint<Long> POWER_OF_2 = new SettingConstraint<Long>(){

        @Override
        public void validate(Long value) {
            if (value != null && !Numbers.isPowerOfTwo((long)value)) {
                throw new IllegalArgumentException("only power of 2 values allowed");
            }
        }

        @Override
        public String getDescription() {
            return "is power of 2";
        }
    };
    public static final SettingConstraint<SocketAddress> HOSTNAME_ONLY = new SettingConstraint<SocketAddress>(){

        @Override
        public void validate(SocketAddress value) {
            if (value == null) {
                throw new IllegalArgumentException("can not be null");
            }
            if (value.getPort() >= 0) {
                throw new IllegalArgumentException("can not have a port");
            }
            if (StringUtils.isBlank((CharSequence)value.getHostname())) {
                throw new IllegalArgumentException("needs not a hostname");
            }
        }

        @Override
        public String getDescription() {
            return "has no specified port";
        }
    };
    public static final SettingConstraint<Path> ABSOLUTE_PATH = new SettingConstraint<Path>(){

        @Override
        public void validate(Path value) {
            if (!value.isAbsolute()) {
                throw new IllegalArgumentException(String.format("`%s` is not an absolute path.", this.valueToString(value)));
            }
        }

        @Override
        public String getDescription() {
            return "is absolute";
        }
    };

    private SettingConstraints() {
    }

    public static SettingConstraint<String> except(final String ... forbiddenValues) {
        return new SettingConstraint<String>(){

            @Override
            public void validate(String value) {
                if (StringUtils.isNotBlank((CharSequence)value) && ArrayUtils.contains((Object[])forbiddenValues, (Object)value)) {
                    throw new IllegalArgumentException(String.format("not allowed value is: %s", value));
                }
            }

            @Override
            public String getDescription() {
                if (forbiddenValues.length > 1) {
                    return String.format("is none of %s", Arrays.toString(forbiddenValues));
                }
                if (forbiddenValues.length == 1) {
                    return String.format("is not `%s`", forbiddenValues[0]);
                }
                return "";
            }
        };
    }

    public static SettingConstraint<String> matches(final String regex, final String description) {
        return new SettingConstraint<String>(){
            private final String descMsg;
            private final Pattern pattern;
            {
                this.descMsg = StringUtils.isEmpty((CharSequence)description) ? "" : String.format(" (%s)", description);
                this.pattern = Pattern.compile(regex);
            }

            @Override
            public void validate(String value) {
                if (!this.pattern.matcher(value).matches()) {
                    throw new IllegalArgumentException(String.format("value does not match expression: `%s`%s", regex, this.descMsg));
                }
            }

            @Override
            public String getDescription() {
                return String.format("matches the pattern `%s`%s", regex, this.descMsg);
            }
        };
    }

    public static SettingConstraint<String> matches(String regex) {
        return SettingConstraints.matches(regex, null);
    }

    public static <T extends Comparable<T>> SettingConstraint<T> min(final T minValue) {
        return new SettingConstraint<T>(){

            @Override
            public void validate(T value) {
                if (value == null) {
                    throw new IllegalArgumentException("can not be null");
                }
                if (minValue.compareTo(value) > 0) {
                    throw new IllegalArgumentException(String.format("minimum allowed value is %s", this.valueToString(minValue)));
                }
            }

            @Override
            public String getDescription() {
                return String.format("is minimum `%s`", this.valueToString(minValue));
            }
        };
    }

    public static <T extends Comparable<T>> SettingConstraint<T> max(final T maxValue) {
        return new SettingConstraint<T>(){

            @Override
            public void validate(T value) {
                if (value == null) {
                    throw new IllegalArgumentException("can not be null");
                }
                if (maxValue.compareTo(value) < 0) {
                    throw new IllegalArgumentException(String.format("maximum allowed value is %s", this.valueToString(maxValue)));
                }
            }

            @Override
            public String getDescription() {
                return String.format("is maximum `%s`", this.valueToString(maxValue));
            }
        };
    }

    public static <T extends Comparable<T>> SettingConstraint<T> range(final T minValue, final T maxValue) {
        return new SettingConstraint<T>(){
            private SettingConstraint<T> max;
            private SettingConstraint<T> min;
            {
                this.max = SettingConstraints.max(maxValue);
                this.min = SettingConstraints.min(minValue);
            }

            @Override
            public void validate(T value) {
                this.min.validate(value);
                this.max.validate(value);
            }

            @Override
            public String getDescription() {
                return String.format("is in the range `%s` to `%s`", this.valueToString(minValue), this.valueToString(maxValue));
            }
        };
    }

    public static <T> SettingConstraint<T> is(final T expected) {
        return new SettingConstraint<T>(){

            @Override
            public void validate(T value) {
                if (!Objects.equals(value, expected)) {
                    throw new IllegalArgumentException(String.format("is not `%s`", this.valueToString(expected)));
                }
            }

            @Override
            public String getDescription() {
                return String.format("is `%s`", this.valueToString(expected));
            }
        };
    }

    @SafeVarargs
    public static <T> SettingConstraint<T> any(final SettingConstraint<T> first, final SettingConstraint<T> ... rest) {
        return new SettingConstraint<T>(){
            private final SettingConstraint<T>[] constraints;
            {
                this.constraints = (SettingConstraint[])ArrayUtil.concat((Object)first, (Object[])rest);
            }

            @Override
            public void validate(T value) {
                for (SettingConstraint constraint : this.constraints) {
                    try {
                        constraint.validate(value);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                }
                throw new IllegalArgumentException(String.format("does not fulfill any of %s", this.getDescription()));
            }

            @Override
            public String getDescription() {
                return Arrays.stream(this.constraints).map(SettingConstraint::getDescription).collect(Collectors.joining(" or "));
            }

            @Override
            void setParser(SettingValueParser<T> parser) {
                super.setParser(parser);
                Arrays.stream(this.constraints).forEach(constraint -> constraint.setParser(parser));
            }
        };
    }

    public static <T> SettingConstraint<List<T>> size(final int size) {
        return new SettingConstraint<List<T>>(){

            @Override
            public void validate(List<T> value) {
                if (value == null) {
                    throw new IllegalArgumentException("can not be null");
                }
                if (value.size() != size) {
                    throw new IllegalArgumentException(String.format("needs to be of size %s", size));
                }
            }

            @Override
            public String getDescription() {
                return String.format("is of size `%s`", size);
            }
        };
    }
}

