/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.annotations.api.IgnoreApiCheck;
import org.neo4j.configuration.SettingConstraint;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.graphdb.config.Setting;

@IgnoreApiCheck
public final class SettingImpl<T>
implements Setting<T> {
    private final String name;
    private final String suffix;
    private SettingImpl<T> dependency;
    private final SettingValueParser<T> parser;
    private final T defaultValue;
    private final List<SettingConstraint<T>> constraints;
    private final boolean dynamic;
    private final boolean immutable;
    private boolean internal;
    private String description;
    private boolean deprecated;
    private String documentedDefaultValue;

    private SettingImpl(String name, SettingValueParser<T> parser, T defaultValue, List<SettingConstraint<T>> constraints, boolean dynamic, boolean immutable, SettingImpl<T> dependency) {
        this.name = name;
        this.parser = parser;
        this.dependency = dependency;
        this.constraints = constraints;
        this.defaultValue = defaultValue;
        this.dynamic = dynamic;
        this.immutable = immutable;
        this.internal = name != null && name.contains("unsupported.");
        this.suffix = StringUtils.isNotEmpty((CharSequence)name) ? name.substring(name.lastIndexOf(46) + 1) : name;
    }

    public static <T> Builder<T> newBuilder(String name, SettingValueParser<T> parser, T defaultValue) {
        return new Builder<T>(name, parser, defaultValue);
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public T parse(String value) {
        if (value == null) {
            return null;
        }
        return this.parser.parse(value);
    }

    public String valueToString(T value) {
        if (value != null) {
            return this.parser.valueToString(value);
        }
        return "No Value";
    }

    T solveDefault(T value, T defaultValue) {
        return this.parser.solveDefault(value, defaultValue);
    }

    T solveDependency(T value, T dependencyValue) {
        return this.parser.solveDependency(value, dependencyValue);
    }

    public void validate(T value) {
        if (value != null) {
            if (!this.parser.getType().isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException(String.format("Setting '%s' can not have value '%s'. Should be of type '%s', but is '%s'", this.name, value, this.parser.getType().getSimpleName(), value.getClass().getSimpleName()));
            }
            this.parser.validate(value);
            for (SettingConstraint<T> constraint : this.constraints) {
                constraint.validate(value);
            }
        }
    }

    public String toString() {
        String desc = String.format("%s, %s", this.name, this.parser.getDescription());
        if (!this.constraints.isEmpty()) {
            String constraintDesc = this.constraints.stream().map(SettingConstraint::getDescription).collect(Collectors.joining(" and "));
            desc = String.format("%s which %s", desc, constraintDesc);
        }
        if (this.dependency != null) {
            desc = String.format("%s. %s from %s", desc, this.parser.getSolverDescription(), this.dependency.name());
        }
        return desc;
    }

    SettingImpl<T> dependency() {
        return this.dependency;
    }

    public String description() {
        return this.description != null ? this.description : this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingImpl setting = (SettingImpl)o;
        return this.name.equals(setting.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String name() {
        return this.name;
    }

    public String suffix() {
        return this.suffix;
    }

    public boolean dynamic() {
        return this.dynamic;
    }

    public boolean immutable() {
        return this.immutable;
    }

    public boolean internal() {
        return this.internal;
    }

    public boolean deprecated() {
        return this.deprecated;
    }

    public String documentedDefaultValue() {
        return this.documentedDefaultValue;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setInternal() {
        this.internal = true;
    }

    void setDeprecated() {
        this.deprecated = true;
    }

    void setDocumentedDefaultValue(String documentedDefaultValue) {
        this.documentedDefaultValue = documentedDefaultValue;
    }

    public static class Builder<T> {
        private final String name;
        private final SettingValueParser<T> parser;
        private final List<SettingConstraint<T>> constraints = new ArrayList<SettingConstraint<T>>();
        private T defaultValue;
        private boolean dynamic;
        private boolean immutable;
        private SettingImpl<T> dependency;

        private Builder(String name, SettingValueParser<T> parser, T defaultValue) {
            this.name = name;
            this.parser = parser;
            this.defaultValue = defaultValue;
        }

        public Builder<T> dynamic() {
            this.dynamic = true;
            return this;
        }

        public Builder<T> immutable() {
            this.immutable = true;
            return this;
        }

        public Builder<T> addConstraint(SettingConstraint<T> constraint) {
            constraint.setParser(this.parser);
            this.constraints.add(constraint);
            return this;
        }

        public Builder<T> setDependency(Setting<T> setting) {
            this.dependency = (SettingImpl)setting;
            return this;
        }

        public Setting<T> build() {
            if (this.immutable && this.dynamic) {
                throw new IllegalArgumentException("Setting can not be both dynamic and immutable");
            }
            if (this.dependency != null && !this.dependency.immutable()) {
                throw new IllegalArgumentException("Setting can only have immutable dependency");
            }
            return new SettingImpl<T>(this.name, this.parser, this.defaultValue, this.constraints, this.dynamic, this.immutable, this.dependency);
        }
    }
}

