/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import java.time.Duration;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.configuration.connectors.ConnectorDefaults;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;

@PublicApi
public final class BoltConnector
implements SettingsDeclaration {
    public static final int DEFAULT_PORT = 7687;
    public static final String NAME = "bolt";
    @Description(value="Enable the bolt connector")
    @DocumentedDefaultValue(value="true")
    public static final Setting<Boolean> enabled = ConnectorDefaults.bolt_enabled;
    @Description(value="Encryption level to require this connector to use")
    public static final Setting<EncryptionLevel> encryption_level = SettingImpl.newBuilder("dbms.connector.bolt.tls_level", SettingValueParsers.ofEnum(EncryptionLevel.class), EncryptionLevel.DISABLED).build();
    @Description(value="Address the connector should bind to")
    public static final Setting<SocketAddress> listen_address = SettingImpl.newBuilder("dbms.connector.bolt.listen_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress(7687)).setDependency(GraphDatabaseSettings.default_listen_address).build();
    @Description(value="Advertised address for this connector")
    public static final Setting<SocketAddress> advertised_address = SettingImpl.newBuilder("dbms.connector.bolt.advertised_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress(7687)).setDependency(GraphDatabaseSettings.default_advertised_address).build();
    @Description(value="The number of threads to keep in the thread pool bound to this connector, even if they are idle.")
    public static final Setting<Integer> thread_pool_min_size = SettingImpl.newBuilder("dbms.connector.bolt.thread_pool_min_size", SettingValueParsers.INT, 5).build();
    @Description(value="The maximum number of threads allowed in the thread pool bound to this connector.")
    public static final Setting<Integer> thread_pool_max_size = SettingImpl.newBuilder("dbms.connector.bolt.thread_pool_max_size", SettingValueParsers.INT, 400).build();
    @Description(value="The maximum time an idle thread in the thread pool bound to this connector will wait for new tasks.")
    public static final Setting<Duration> thread_pool_keep_alive = SettingImpl.newBuilder("dbms.connector.bolt.thread_pool_keep_alive", SettingValueParsers.DURATION, Duration.ofMinutes(5L)).build();
    @Description(value="The maximum time to wait for the thread pool to finish processing its pending jobs and shutdown")
    public static final Setting<Duration> thread_pool_shutdown_wait_time = SettingImpl.newBuilder("dbms.connector.bolt.unsupported_thread_pool_shutdown_wait_time", SettingValueParsers.DURATION, Duration.ofSeconds(5L)).build();
    @Description(value="The queue size of the thread pool bound to this connector (-1 for unbounded, 0 for direct handoff, > 0 for bounded)")
    @Internal
    public static final Setting<Integer> unsupported_thread_pool_queue_size = SettingImpl.newBuilder("dbms.connector.bolt.unsupported_thread_pool_queue_size", SettingValueParsers.INT, 0).build();

    public static enum EncryptionLevel {
        REQUIRED,
        OPTIONAL,
        DISABLED;

    }
}

