/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.nio.file.Path;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.factory.Maps;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.configuration.connectors.ConnectorDefaults;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogTimeZone;

@PublicApi
public class GraphDatabaseSettings
implements SettingsDeclaration {
    public static final int DEFAULT_BLOCK_SIZE = 128;
    public static final int DEFAULT_LABEL_BLOCK_SIZE = 64;
    public static final int MINIMAL_BLOCK_SIZE = 16;
    public static final long UNSPECIFIED_TIMEOUT = 0L;
    public static final String SYSTEM_DATABASE_NAME = "system";
    public static final String DEFAULT_DATABASE_NAME = "neo4j";
    public static final String DEFAULT_DATA_DIR_NAME = "data";
    public static final String DEFAULT_DATABASES_ROOT_DIR_NAME = "databases";
    public static final String DEFAULT_TX_LOGS_ROOT_DIR_NAME = "transactions";
    @Description(value="Root relative to which directory settings are resolved.")
    @DocumentedDefaultValue(value="Defaults to current working directory")
    public static final Setting<Path> neo4j_home = SettingImpl.newBuilder("dbms.directories.neo4j_home", SettingValueParsers.PATH, Path.of("", new String[0]).toAbsolutePath()).addConstraint(SettingConstraints.ABSOLUTE_PATH).immutable().build();
    @Description(value="Name of the default database.")
    public static final Setting<String> default_database = SettingImpl.newBuilder("dbms.default_database", SettingValueParsers.DATABASENAME, "neo4j").build();
    @Description(value="Path of the data directory. You must not configure more than one Neo4j installation to use the same data directory.")
    public static final Setting<Path> data_directory = SettingImpl.newBuilder("dbms.directories.data", SettingValueParsers.PATH, Path.of("data", new String[0])).setDependency(neo4j_home).immutable().build();
    @Internal
    public static final Setting<Path> databases_root_path = SettingImpl.newBuilder("unsupported.dbms.directories.databases.root", SettingValueParsers.PATH, Path.of("databases", new String[0])).setDependency(data_directory).immutable().build();
    @Deprecated
    @Internal
    @Description(value="Location where Neo4j keeps the logical transaction logs.")
    public static final Setting<Path> logical_logs_location = SettingImpl.newBuilder("dbms.directories.tx_log", SettingValueParsers.PATH, Path.of("neo4j", new String[0])).setDependency(databases_root_path).build();
    @Description(value="Root location where Neo4j will store transaction logs for configured databases.")
    public static final Setting<Path> transaction_logs_root_path = SettingImpl.newBuilder("dbms.directories.transaction.logs.root", SettingValueParsers.PATH, Path.of("transactions", new String[0])).setDependency(data_directory).immutable().build();
    @Description(value="Only allow read operations from this Neo4j instance. This mode still requires write access to the directory for lock purposes.")
    public static final Setting<Boolean> read_only = SettingImpl.newBuilder("dbms.read_only", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Configure lucene to be in memory only, for test environment. This is set in code and should never be configured explicitly.")
    public static final Setting<Boolean> ephemeral_lucene = SettingImpl.newBuilder("unsupported.dbms.lucene.ephemeral", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<String> lock_manager = SettingImpl.newBuilder("unsupported.dbms.lock_manager", SettingValueParsers.STRING, "").build();
    @Internal
    public static final Setting<String> tracer = SettingImpl.newBuilder("unsupported.dbms.tracer", SettingValueParsers.STRING, null).build();
    @Description(value="Print out the effective Neo4j configuration after startup.")
    @Internal
    public static final Setting<Boolean> dump_configuration = SettingImpl.newBuilder("unsupported.dbms.report_configuration", SettingValueParsers.BOOL, false).build();
    @Description(value="A strict configuration validation will prevent the database from starting up if unknown configuration options are specified in the neo4j settings namespace (such as dbms., cypher., etc).")
    public static final Setting<Boolean> strict_config_validation = SettingImpl.newBuilder("dbms.config.strict_validation", SettingValueParsers.BOOL, false).build();
    @Description(value="Whether to allow an upgrade in case the current version of the database starts against an older version.")
    public static final Setting<Boolean> allow_upgrade = SettingImpl.newBuilder("dbms.allow_upgrade", SettingValueParsers.BOOL, false).build();
    @Description(value="Database record format. Valid values: `standard`, `high_limit`. The `high_limit` format is available for Enterprise Edition only. It is required if you have a graph that is larger than 34 billion nodes, 34 billion relationships, or 68 billion properties. A change of the record format is irreversible. Certain operations may suffer from a performance penalty of up to 10%, which is why this format is not switched on by default. However, if you want to change the configured record format value, you must also set `dbms.allow_upgrade=true`, because the setting implies a one-way store format migration.")
    @DocumentedDefaultValue(value="`standard` for new databases, latest version of current format for existing databases")
    public static final Setting<String> record_format = SettingImpl.newBuilder("dbms.record_format", SettingValueParsers.STRING, "").build();
    @Description(value="Set this to specify the default parser (language version).")
    public static final Setting<CypherParserVersion> cypher_parser_version = SettingImpl.newBuilder("cypher.default_language_version", SettingValueParsers.ofEnum(CypherParserVersion.class), CypherParserVersion.DEFAULT).build();
    @Description(value="Set this to specify the default planner for the default language version.")
    public static final Setting<CypherPlanner> cypher_planner = SettingImpl.newBuilder("cypher.planner", SettingValueParsers.ofEnum(CypherPlanner.class), CypherPlanner.DEFAULT).build();
    @Description(value="Set this to specify the behavior when Cypher planner or runtime hints cannot be fulfilled. If true, then non-conformance will result in an error, otherwise only a warning is generated.")
    public static final Setting<Boolean> cypher_hints_error = SettingImpl.newBuilder("cypher.hints_error", SettingValueParsers.BOOL, false).build();
    @Description(value="This setting is associated with performance optimization. Set this to `true` in situations where it is preferable to have any queries using the 'shortestPath' function terminate as soon as possible with no answer, rather than potentially running for a long time attempting to find an answer (even if there is no path to be found). For most queries, the 'shortestPath' algorithm will return the correct answer very quickly. However there are some cases where it is possible that the fast bidirectional breadth-first search algorithm will find no results even if they exist. This can happen when the predicates in the `WHERE` clause applied to 'shortestPath' cannot be applied to each step of the traversal, and can only be applied to the entire path. When the query planner detects these special cases, it will plan to perform an exhaustive depth-first search if the fast algorithm finds no paths. However, the exhaustive search may be orders of magnitude slower than the fast algorithm. If it is critical that queries terminate as soon as possible, it is recommended that this option be set to `true`, which means that Neo4j will never consider using the exhaustive search for shortestPath queries. However, please note that if no paths are found, an error will be thrown at run time, which will need to be handled by the application.")
    public static final Setting<Boolean> forbid_exhaustive_shortestpath = SettingImpl.newBuilder("cypher.forbid_exhaustive_shortestpath", SettingValueParsers.BOOL, false).build();
    @Description(value="This setting is associated with performance optimization. The shortest path algorithm does not work when the start and end nodes are the same. With this setting set to `false` no path will be returned when that happens. The default value of `true` will instead throw an exception. This can happen if you perform a shortestPath search after a cartesian product that might have the same start and end nodes for some of the rows passed to shortestPath. If it is preferable to not experience this exception, and acceptable for results to be missing for those rows, then set this to `false`. If you cannot accept missing results, and really want the shortestPath between two common nodes, then re-write the query using a standard Cypher variable length pattern expression followed by ordering by path length and limiting to one result.")
    public static final Setting<Boolean> forbid_shortestpath_common_nodes = SettingImpl.newBuilder("cypher.forbid_shortestpath_common_nodes", SettingValueParsers.BOOL, true).build();
    @Description(value="Set this to change the behavior for Cypher create relationship when the start or end node is missing. By default this fails the query and stops execution, but by setting this flag the create operation is simply not performed and execution continues.")
    public static final Setting<Boolean> cypher_lenient_create_relationship = SettingImpl.newBuilder("cypher.lenient_create_relationship", SettingValueParsers.BOOL, false).build();
    @Description(value="Set this to specify the default runtime for the default language version.")
    @Internal
    public static final Setting<CypherRuntime> cypher_runtime = SettingImpl.newBuilder("unsupported.cypher.runtime", SettingValueParsers.ofEnum(CypherRuntime.class), CypherRuntime.DEFAULT).build();
    @Description(value="Choose the expression engine. The default is to only compile expressions that are hot, if 'COMPILED' is chosen all expressions will be compiled directly and if 'INTERPRETED' is chosen expressions will never be compiled.")
    @Internal
    public static final Setting<CypherExpressionEngine> cypher_expression_engine = SettingImpl.newBuilder("unsupported.cypher.expression_engine", SettingValueParsers.ofEnum(CypherExpressionEngine.class), CypherExpressionEngine.DEFAULT).build();
    @Description(value="Number of uses before an expression is considered for compilation")
    @Internal
    public static final Setting<Integer> cypher_expression_recompilation_limit = SettingImpl.newBuilder("unsupported.cypher.expression_recompilation_limit", SettingValueParsers.INT, 10).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="Enable tracing of compilation in cypher.")
    @Internal
    public static final Setting<Boolean> cypher_compiler_tracing = SettingImpl.newBuilder("unsupported.cypher.compiler_tracing", SettingValueParsers.BOOL, false).build();
    @Description(value="The number of Cypher query execution plans that are cached.")
    public static final Setting<Integer> query_cache_size = SettingImpl.newBuilder("dbms.query_cache_size", SettingValueParsers.INT, 1000).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="The threshold when a plan is considered stale. If any of the underlying statistics used to create the plan have changed more than this value, the plan will be considered stale and will be replanned. Change is calculated as abs(a-b)/max(a,b). This means that a value of 0.75 requires the database to approximately quadruple in size. A value of 0 means replan as soon as possible, with the soonest being defined by the cypher.min_replan_interval which defaults to 10s. After this interval the divergence threshold will slowly start to decline, reaching 10% after about 7h. This will ensure that long running databases will still get query replanning on even modest changes, while not replanning frequently unless the changes are very large.")
    public static final Setting<Double> query_statistics_divergence_threshold = SettingImpl.newBuilder("cypher.statistics_divergence_threshold", SettingValueParsers.DOUBLE, 0.75).addConstraint(SettingConstraints.range(0.0, 1.0)).build();
    @Description(value="Large databases might change slowly, and so to prevent queries from never being replanned the divergence threshold set by cypher.statistics_divergence_threshold is configured to shrink over time. The algorithm used to manage this change is set by unsupported.cypher.replan_algorithm and will cause the threshold to reach the value set here once the time since the previous replanning has reached unsupported.cypher.target_replan_interval. Setting this value to higher than the cypher.statistics_divergence_threshold will cause the threshold to not decay over time.")
    @Internal
    public static final Setting<Double> query_statistics_divergence_target = SettingImpl.newBuilder("unsupported.cypher.statistics_divergence_target", SettingValueParsers.DOUBLE, 0.1).addConstraint(SettingConstraints.range(0.0, 1.0)).build();
    @Description(value="The threshold when a warning is generated if a label scan is done after a load csv where the label has no index")
    @Internal
    public static final Setting<Long> query_non_indexed_label_warning_threshold = SettingImpl.newBuilder("unsupported.cypher.non_indexed_label_warning_threshold", SettingValueParsers.LONG, 10000L).build();
    @Description(value="To improve IDP query planning time, we can restrict the internal planning table size, triggering compaction of candidate plans. The smaller the threshold the faster the planning, but the higher the risk of sub-optimal plans.")
    @Internal
    public static final Setting<Integer> cypher_idp_solver_table_threshold = SettingImpl.newBuilder("unsupported.cypher.idp_solver_table_threshold", SettingValueParsers.INT, 128).addConstraint(SettingConstraints.min(16)).build();
    @Description(value="To improve IDP query planning time, we can restrict the internal planning loop duration, triggering more frequent compaction of candidate plans. The smaller the threshold the faster the planning, but the higher the risk of sub-optimal plans.")
    @Internal
    public static final Setting<Long> cypher_idp_solver_duration_threshold = SettingImpl.newBuilder("unsupported.cypher.idp_solver_duration_threshold", SettingValueParsers.LONG, 1000L).addConstraint(SettingConstraints.min(10L)).build();
    @Description(value="The minimum time between possible cypher query replanning events. After this time, the graph statistics will be evaluated, and if they have changed by more than the value set by cypher.statistics_divergence_threshold, the query will be replanned. If the statistics have not changed sufficiently, the same interval will need to pass before the statistics will be evaluated again. Each time they are evaluated, the divergence threshold will be reduced slightly until it reaches 10% after 7h, so that even moderately changing databases will see query replanning after a sufficiently long time interval.")
    public static final Setting<Duration> cypher_min_replan_interval = SettingImpl.newBuilder("cypher.min_replan_interval", SettingValueParsers.DURATION, Duration.ofSeconds(10L)).build();
    @Description(value="Large databases might change slowly, and to prevent queries from never being replanned the divergence threshold set by cypher.statistics_divergence_threshold is configured to shrink over time. The algorithm used to manage this change is set by unsupported.cypher.replan_algorithm and will cause the threshold to reach the value set by unsupported.cypher.statistics_divergence_target once the time since the previous replanning has reached the value set here. Setting this value to less than the value of cypher.min_replan_interval will cause the threshold to not decay over time.")
    @Internal
    public static final Setting<Duration> cypher_replan_interval_target = SettingImpl.newBuilder("unsupported.cypher.target_replan_interval", SettingValueParsers.DURATION, Duration.ofHours(7L)).build();
    @Description(value="Large databases might change slowly, and to prevent queries from never being replanned the divergence threshold set by cypher.statistics_divergence_threshold is configured to shrink over time using the algorithm set here. This will cause the threshold to reach the value set by unsupported.cypher.statistics_divergence_target once the time since the previous replanning has reached the value set in unsupported.cypher.target_replan_interval. Setting the algorithm to 'none' will cause the threshold to not decay over time.")
    @Internal
    public static final Setting<CypherReplanAlgorithm> cypher_replan_algorithm = SettingImpl.newBuilder("unsupported.cypher.replan_algorithm", SettingValueParsers.ofEnum(CypherReplanAlgorithm.class), CypherReplanAlgorithm.DEFAULT).build();
    @Description(value="Set this to enable monitors in the Cypher runtime.")
    @Internal
    public static final Setting<Boolean> cypher_enable_runtime_monitors = SettingImpl.newBuilder("unsupported.cypher.enable_runtime_monitors", SettingValueParsers.BOOL, false).build();
    @Description(value="Determines if Cypher will allow using file URLs when loading data using `LOAD CSV`. Setting this value to `false` will cause Neo4j to fail `LOAD CSV` clauses that load data from the file system.")
    public static final Setting<Boolean> allow_file_urls = SettingImpl.newBuilder("dbms.security.allow_csv_import_from_file_urls", SettingValueParsers.BOOL, true).build();
    @Description(value="Sets the root directory for file URLs used with the Cypher `LOAD CSV` clause. This should be set to a directory relative to the Neo4j installation path, restricting access to only those files within that directory and its subdirectories. For example the value \"import\" will only enable access to files within the 'import' folder. Removing this setting will disable the security feature, allowing all files in the local system to be imported. Setting this to an empty field will allow access to all files within the Neo4j installation folder.")
    public static final Setting<Path> load_csv_file_url_root = SettingImpl.newBuilder("dbms.directories.import", SettingValueParsers.PATH, null).immutable().setDependency(neo4j_home).build();
    @Description(value="Selects whether to conform to the standard https://tools.ietf.org/html/rfc4180 for interpreting escaped quotation characters in CSV files loaded using `LOAD CSV`. Setting this to `false` will use the standard, interpreting repeated quotes '\"\"' as a single in-lined quote, while `true` will use the legacy convention originally supported in Neo4j 3.0 and 3.1, allowing a backslash to include quotes in-lined in fields.")
    public static final Setting<Boolean> csv_legacy_quote_escaping = SettingImpl.newBuilder("dbms.import.csv.legacy_quote_escaping", SettingValueParsers.BOOL, true).build();
    @Description(value="The size of the internal buffer in bytes used by `LOAD CSV`. If the csv file contains huge fields this value may have to be increased.")
    public static final Setting<Long> csv_buffer_size = SettingImpl.newBuilder("dbms.import.csv.buffer_size", SettingValueParsers.LONG, ByteUnit.mebiBytes((long)2L)).addConstraint(SettingConstraints.min(1L)).build();
    @Description(value="Enables or disables tracking of how much time a query spends actively executing on the CPU. Calling `dbms.listQueries` will display the time. This can also be logged in the query log by using `dbms.logs.query.time_logging_enabled`.")
    public static final Setting<Boolean> track_query_cpu_time = SettingImpl.newBuilder("dbms.track_query_cpu_time", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Enables or disables tracking of how many bytes are allocated by the execution of a query. If enabled, calling `dbms.listQueries` will display the allocated bytes. If enabled, the maximum allocated bytes of a query can be limited using `cypher.query_max_allocations`. This can also be logged in the query log by using `dbms.logs.query.allocation_logging_enabled`.")
    public static final Setting<Boolean> track_query_allocation = SettingImpl.newBuilder("dbms.track_query_allocation", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="The maximum amount of heap memory allocations to for cypher to perform on a single query, in bytes (or kilobytes with the 'k' suffix, megabytes with 'm' and gigabytes with 'g'). Zero means 'unlimited'. If a query exceeds this limit, it will be terminated. Determining the heap memory allocations done by a query is a rough estimate and not an exact measurement. If no memory limit is configured, queries will be allowed to allocate as much heap memory as needed. This could potentially lead to queries consuming more heap memory than available, which will kill the Neo4j server.")
    public static final Setting<Long> query_max_memory = SettingImpl.newBuilder("cypher.query_max_allocations", SettingValueParsers.BYTES, SettingValueParsers.BYTES.parse("0")).addConstraint(SettingConstraints.min(0L)).dynamic().build();
    @Description(value="Enable tracing of pipelined runtime scheduler.")
    @Internal
    public static final Setting<Boolean> enable_pipelined_runtime_trace = SettingImpl.newBuilder("unsupported.cypher.pipelined.enable_runtime_trace", SettingValueParsers.BOOL, false).build();
    @Description(value="Path to the pipelined runtime scheduler trace. If 'stdOut' and tracing is on, will print to std out.")
    @Internal
    public static final Setting<Path> pipelined_scheduler_trace_filename = SettingImpl.newBuilder("unsupported.cypher.pipelined.runtime_trace_path", SettingValueParsers.PATH, Path.of("stdOut", new String[0])).setDependency(neo4j_home).immutable().build();
    @Description(value="The size of batches in the pipelined runtime for queries which work with few rows.")
    @Internal
    public static final Setting<Integer> cypher_pipelined_batch_size_small = SettingImpl.newBuilder("unsupported.cypher.pipelined.batch_size_small", SettingValueParsers.INT, 128).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="The size of batches in the pipelined runtime for queries which work with many rows.")
    @Internal
    public static final Setting<Integer> cypher_pipelined_batch_size_big = SettingImpl.newBuilder("unsupported.cypher.pipelined.batch_size_big", SettingValueParsers.INT, 1024).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="Number of threads to allocate to Cypher worker threads. If set to 0, two workers will be started for every physical core in the system.")
    @Internal
    public static final Setting<Integer> cypher_worker_count = SettingImpl.newBuilder("unsupported.cypher.number_of_workers", SettingValueParsers.INT, 0).build();
    @Description(value="For compiled execution, specialized code is generated and then executed. More optimizations such as operator fusion may apply. Operator fusion means that multiple operators such as for example AllNodesScan -> Filter -> ProduceResult can be compiled into a single specialized operator. This setting only applies to the pipelined and parallel runtime. Allowed values are \"COMPILED\" (default) and \"INTERPRETED\".")
    @Internal
    public static final Setting<CypherOperatorEngine> cypher_operator_engine = SettingImpl.newBuilder("unsupported.cypher.pipelined.operator_engine", SettingValueParsers.ofEnum(CypherOperatorEngine.class), CypherOperatorEngine.COMPILED).build();
    @Description(value="Use interpreted pipes as a fallback for operators that do not have a specialized implementation in the pipelined runtime. Allowed values are \"disabled\", \"default\" (the default) and \"all\" (experimental). The default is to enable the use of a subset of whitelisted operators that are known to be supported, whereas \"all\" is an experimental option that enables the fallback to be used for all possible operators that are not known to be unsupported.")
    @Internal
    public static final Setting<CypherPipelinedInterpretedPipesFallback> cypher_pipelined_interpreted_pipes_fallback = SettingImpl.newBuilder("unsupported.cypher.pipelined_interpreted_pipes_fallback", SettingValueParsers.ofEnum(CypherPipelinedInterpretedPipesFallback.class), CypherPipelinedInterpretedPipesFallback.DEFAULT).build();
    @Description(value="Max number of recent queries to collect in the data collector module. Will round down to the nearest power of two. The default number (8192 query invocations)  was chosen as a trade-off between getting a useful amount of queries, and not wasting too much heap. Even with a buffer full of unique queries, the estimated footprint lies in tens of MBs. If the buffer is full of cached queries, the retained size was measured to 265 kB. Setting this to 0 will disable data collection of queries completely.")
    @Internal
    public static final Setting<Integer> data_collector_max_recent_query_count = SettingImpl.newBuilder("unsupported.datacollector.max_recent_query_count", SettingValueParsers.INT, 8192).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="Sets the upper limit for how much of the query text that will be retained by the query collector. For queries longer than the limit, only a prefix of size limit will be retained by the collector. Lowering this value will reduce the memory footprint of collected query invocations under loads with many queries with long query texts, which could occur for generated queries. The downside is that on retrieving queries by `db.stats.retrieve`, queries longer than this max size would be returned incomplete. Setting this to 0 will completely drop query texts from the collected queries.")
    @Internal
    public static final Setting<Integer> data_collector_max_query_text_size = SettingImpl.newBuilder("unsupported.datacollector.max_query_text_size", SettingValueParsers.INT, 10000).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="The maximum amount of time to wait for the database to become available, when starting a new transaction.")
    @Internal
    public static final Setting<Duration> transaction_start_timeout = SettingImpl.newBuilder("unsupported.dbms.transaction_start_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(1L)).build();
    @Description(value="The maximum number of concurrently running transactions. If set to 0, limit is disabled.")
    public static final Setting<Integer> max_concurrent_transactions = SettingImpl.newBuilder("dbms.transaction.concurrent.maximum", SettingValueParsers.INT, 1000).dynamic().build();
    @Description(value="Transaction creation tracing level.")
    public static final Setting<TransactionTracingLevel> transaction_tracing_level = SettingImpl.newBuilder("dbms.transaction.tracing.level", SettingValueParsers.ofEnum(TransactionTracingLevel.class), TransactionTracingLevel.DISABLED).dynamic().build();
    @Description(value="Transaction sampling percentage.")
    public static final Setting<Integer> transaction_sampling_percentage = SettingImpl.newBuilder("dbms.transaction.sampling.percentage", SettingValueParsers.INT, 5).dynamic().addConstraint(SettingConstraints.range(1, 100)).build();
    @Description(value="The maximum time interval of a transaction within which it should be completed.")
    public static final Setting<Duration> transaction_timeout = SettingImpl.newBuilder("dbms.transaction.timeout", SettingValueParsers.DURATION, Duration.ZERO).dynamic().build();
    @Description(value="The maximum time interval within which lock should be acquired. Zero (default) means timeout is disabled.")
    public static final Setting<Duration> lock_acquisition_timeout = SettingImpl.newBuilder("dbms.lock.acquisition.timeout", SettingValueParsers.DURATION, Duration.ZERO).build();
    @Description(value="Configures the time interval between transaction monitor checks. Determines how often monitor thread will check transaction for timeout.")
    public static final Setting<Duration> transaction_monitor_check_interval = SettingImpl.newBuilder("dbms.transaction.monitor.check.interval", SettingValueParsers.DURATION, Duration.ofSeconds(2L)).build();
    @Description(value="The maximum amount of time to wait for running transactions to complete before allowing initiated database shutdown to continue")
    public static final Setting<Duration> shutdown_transaction_end_timeout = SettingImpl.newBuilder("dbms.shutdown_transaction_end_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(10L)).build();
    @Description(value="Location of the database plugin directory. Compiled Java JAR files that contain database procedures will be loaded if they are placed in this directory.")
    public static final Setting<Path> plugin_dir = SettingImpl.newBuilder("dbms.directories.plugins", SettingValueParsers.PATH, Path.of("plugins", new String[0])).setDependency(neo4j_home).immutable().build();
    @Description(value="Threshold for rotation of the user log (_neo4j.log_). If set to 0, log rotation is disabled. Note that if dbms.logs.user.stdout_enabled is enabled this setting will be ignored.")
    public static final Setting<Long> store_user_log_rotation_threshold = SettingImpl.newBuilder("dbms.logs.user.rotation.size", SettingValueParsers.BYTES, 0L).addConstraint(SettingConstraints.range(0L, Long.MAX_VALUE)).build();
    @Description(value="Threshold for rotation of the debug log.")
    public static final Setting<Long> store_internal_log_rotation_threshold = SettingImpl.newBuilder("dbms.logs.debug.rotation.size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)20L)).addConstraint(SettingConstraints.range(0L, Long.MAX_VALUE)).build();
    @Description(value="Debug log contexts that should output debug level logging")
    @Internal
    public static final Setting<List<String>> store_internal_debug_contexts = SettingImpl.newBuilder("unsupported.dbms.logs.debug.debug_loggers", SettingValueParsers.listOf(SettingValueParsers.STRING), List.of("org.neo4j.diagnostics")).dynamic().build();
    @Description(value="Debug log level threshold.")
    public static final Setting<Level> store_internal_log_level = SettingImpl.newBuilder("dbms.logs.debug.level", SettingValueParsers.ofEnum(Level.class), Level.INFO).dynamic().build();
    @Description(value="Database timezone. Among other things, this setting influences which timezone the logs and monitoring procedures use.")
    public static final Setting<LogTimeZone> db_timezone = SettingImpl.newBuilder("dbms.db.timezone", SettingValueParsers.ofEnum(LogTimeZone.class), LogTimeZone.UTC).build();
    @Description(value="Database timezone for temporal functions. All Time and DateTime values that are created without an explicit timezone will use this configured default timezone.")
    public static final Setting<ZoneId> db_temporal_timezone = SettingImpl.newBuilder("db.temporal.timezone", SettingValueParsers.TIMEZONE, ZoneOffset.UTC).build();
    @Description(value="Maximum time to wait for active transaction completion when rotating counts store")
    @Internal
    public static final Setting<Duration> counts_store_rotation_timeout = SettingImpl.newBuilder("unsupported.dbms.counts_store_rotation_timeout", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).build();
    @Description(value="Minimum time interval after last rotation of the user log (_neo4j.log_) before it may be  rotated again. Note that if dbms.logs.user.stdout_enabled is enabled this setting will be ignored.")
    public static final Setting<Duration> store_user_log_rotation_delay = SettingImpl.newBuilder("dbms.logs.user.rotation.delay", SettingValueParsers.DURATION, Duration.ofSeconds(300L)).build();
    @Description(value="Minimum time interval after last rotation of the debug log before it may be rotated again.")
    public static final Setting<Duration> store_internal_log_rotation_delay = SettingImpl.newBuilder("dbms.logs.debug.rotation.delay", SettingValueParsers.DURATION, Duration.ofSeconds(300L)).build();
    @Description(value="Maximum number of history files for the user log (_neo4j.log_). Note that if dbms.logs.user.stdout_enabled is enabled this setting will be ignored.")
    public static final Setting<Integer> store_user_log_max_archives = SettingImpl.newBuilder("dbms.logs.user.rotation.keep_number", SettingValueParsers.INT, 7).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="Maximum number of history files for the debug log.")
    public static final Setting<Integer> store_internal_log_max_archives = SettingImpl.newBuilder("dbms.logs.debug.rotation.keep_number", SettingValueParsers.INT, 7).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="Configures the general policy for when check-points should occur. The default policy is the 'periodic' check-point policy, as specified by the 'dbms.checkpoint.interval.tx' and 'dbms.checkpoint.interval.time' settings. The Neo4j Enterprise Edition provides two alternative policies: The first is the 'continuous' check-point policy, which will ignore those settings and run the check-point process all the time. The second is the 'volumetric' check-point policy, which makes a best-effort at check-pointing often enough so that the database doesn't get too far behind on deleting old transaction logs in accordance with the 'dbms.tx_log.rotation.retention_policy' setting.")
    public static final Setting<CheckpointPolicy> check_point_policy = SettingImpl.newBuilder("dbms.checkpoint", SettingValueParsers.ofEnum(CheckpointPolicy.class), CheckpointPolicy.PERIODIC).build();
    @Description(value="Configures the transaction interval between check-points. The database will not check-point more often  than this (unless check pointing is triggered by a different event), but might check-point less often than this interval, if performing a check-point takes longer time than the configured interval. A check-point is a point in the transaction logs, from which recovery would start from. Longer check-point intervals typically means that recovery will take longer to complete in case of a crash. On the other hand, a longer check-point interval can also reduce the I/O load that the database places on the system, as each check-point implies a flushing and forcing of all the store files.  The default is '100000' for a check-point every 100000 transactions.")
    public static final Setting<Integer> check_point_interval_tx = SettingImpl.newBuilder("dbms.checkpoint.interval.tx", SettingValueParsers.INT, 100000).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="Configures the time interval between check-points. The database will not check-point more often than this (unless check pointing is triggered by a different event), but might check-point less often than this interval, if performing a check-point takes longer time than the configured interval. A check-point is a point in the transaction logs, from which recovery would start from. Longer check-point intervals typically means that recovery will take longer to complete in case of a crash. On the other hand, a longer check-point interval can also reduce the I/O load that the database places on the system, as each check-point implies a flushing and forcing of all the store files.")
    public static final Setting<Duration> check_point_interval_time = SettingImpl.newBuilder("dbms.checkpoint.interval.time", SettingValueParsers.DURATION, Duration.ofMinutes(15L)).build();
    @Description(value="Limit the number of IOs the background checkpoint process will consume per second. This setting is advisory, is ignored in Neo4j Community Edition, and is followed to best effort in Enterprise Edition. An IO is in this case a 8 KiB (mostly sequential) write. Limiting the write IO in this way will leave more bandwidth in the IO subsystem to service random-read IOs, which is important for the response time of queries when the database cannot fit entirely in memory. The only drawback of this setting is that longer checkpoint times may lead to slightly longer recovery times in case of a database or system crash. A lower number means lower IO pressure, and consequently longer checkpoint times. Set this to -1 to disable the IOPS limit and remove the limitation entirely; this will let the checkpointer flush data as fast as the hardware will go. Removing the setting, or commenting it out, will set the default value of 300.")
    public static final Setting<Integer> check_point_iops_limit = SettingImpl.newBuilder("dbms.checkpoint.iops.limit", SettingValueParsers.INT, 300).dynamic().build();
    @Description(value="Enable or disable background index sampling")
    public static final Setting<Boolean> index_background_sampling_enabled = SettingImpl.newBuilder("dbms.index_sampling.background_enabled", SettingValueParsers.BOOL, true).build();
    @Description(value="Index sampling chunk size limit")
    public static final Setting<Integer> index_sample_size_limit = SettingImpl.newBuilder("dbms.index_sampling.sample_size_limit", SettingValueParsers.INT, (int)ByteUnit.mebiBytes((long)8L)).addConstraint(SettingConstraints.range((int)ByteUnit.mebiBytes((long)1L), Integer.MAX_VALUE)).build();
    @Description(value="Percentage of index updates of total index size required before sampling of a given index is triggered")
    public static final Setting<Integer> index_sampling_update_percentage = SettingImpl.newBuilder("dbms.index_sampling.update_percentage", SettingValueParsers.INT, 5).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="Set the maximum number of threads that can concurrently be used to sample indexes. Zero means unrestricted.")
    @Internal
    public static final Setting<Integer> index_sampling_parallelism = SettingImpl.newBuilder("unsupported.dbms.index_sampling.parallelism", SettingValueParsers.INT, 4).addConstraint(SettingConstraints.min(0)).build();
    @Deprecated(since="4.0.0", forRemoval=true)
    @Description(value="The maximum number of open Lucene index searchers.")
    public static final Setting<Integer> lucene_searcher_cache_size = SettingImpl.newBuilder("dbms.index_searcher_cache_size", SettingValueParsers.INT, Integer.MAX_VALUE).addConstraint(SettingConstraints.min(1)).build();
    @Internal
    public static final Setting<Boolean> multi_threaded_schema_index_population_enabled = SettingImpl.newBuilder("unsupported.dbms.multi_threaded_schema_index_population_enabled", SettingValueParsers.BOOL, true).build();
    @Description(value="Index provider to use for newly created schema indexes. An index provider may store different value types in separate physical indexes. native-btree-1.0: All value types and arrays of all value types, even composite keys, are stored in one native index. lucene+native-3.0: Like native-btree-1.0 but single property strings are stored in Lucene. A native index has faster updates, less heap and CPU usage compared to a Lucene index. A native index has some limitations around key size and slower execution of CONTAINS and ENDS WITH string index queries, compared to a Lucene index.\nDeprecated: Which index provider to use will be a fully internal concern.")
    @Deprecated
    public static final Setting<String> default_schema_provider = SettingImpl.newBuilder("dbms.index.default_schema_provider", SettingValueParsers.STRING, SchemaIndex.NATIVE_BTREE10.toString()).build();
    @Description(value="The default index provider used for managing full-text indexes. Only 'fulltext-1.0' is supported.")
    @Internal
    public static final Setting<String> default_fulltext_provider = SettingImpl.newBuilder("unsupported.dbms.index.default_fulltext_provider", SettingValueParsers.STRING, "fulltext-1.0").build();
    @Description(value="Make Neo4j keep the logical transaction logs for being able to backup the database. Can be used for specifying the threshold to prune logical logs after. For example \"10 days\" will prune logical logs that only contains transactions older than 10 days from the current time, or \"100k txs\" will keep the 100k latest transactions and prune any older transactions.")
    public static final Setting<String> keep_logical_logs = SettingImpl.newBuilder("dbms.tx_log.rotation.retention_policy", SettingValueParsers.STRING, "7 days").dynamic().addConstraint(SettingConstraints.matches("^(true|keep_all|false|keep_none|(\\d+[KkMmGg]?( (files|size|txs|entries|hours|days))))$", "must be `true`, `false` or of format `<number><optional unit> <type>`. Valid units are `k`, `M` and `G`. Valid types are `files`, `size`, `txs`, `entries`, `hours` and `days`. For example, `100M size` will limiting logical log space on disk to 100Mb, or `200k txs` will limiting the number of transactions to keep to 200 000")).build();
    @Description(value="Specifies at which file size the logical log will auto-rotate. Minimum accepted value is 128 KiB. ")
    public static final Setting<Long> logical_log_rotation_threshold = SettingImpl.newBuilder("dbms.tx_log.rotation.size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)250L)).addConstraint(SettingConstraints.min(ByteUnit.kibiBytes((long)128L))).dynamic().build();
    @Description(value="Specify if Neo4j should try to preallocate logical log file in advance.")
    public static final Setting<Boolean> preallocate_logical_logs = SettingImpl.newBuilder("dbms.tx_log.preallocate", SettingValueParsers.BOOL, true).dynamic().build();
    @Description(value="If `true`, Neo4j will abort recovery if any errors are encountered in the logical log. Setting this to `false` will allow Neo4j to restore as much as possible from the corrupted log files and ignore the rest, but the integrity of the database might be compromised.")
    @Internal
    public static final Setting<Boolean> fail_on_corrupted_log_files = SettingImpl.newBuilder("unsupported.dbms.tx_log.fail_on_corrupted_log_files", SettingValueParsers.BOOL, true).build();
    @Description(value="If `true`, Neo4j will abort recovery if transaction log files are missing. Setting this to `false` will allow Neo4j to create new empty missing files for the already existing database, but the integrity of the database might be compromised.")
    public static final Setting<Boolean> fail_on_missing_files = SettingImpl.newBuilder("dbms.recovery.fail_on_missing_files", SettingValueParsers.BOOL, true).build();
    @Description(value="Specifies if engine should run cypher query based on a snapshot of accessed data. Query will be restarted in case if concurrent modification of data will be detected.")
    @Internal
    public static final Setting<Boolean> snapshot_query = SettingImpl.newBuilder("unsupported.dbms.query.snapshot", SettingValueParsers.BOOL, false).build();
    @Description(value="Specifies number or retries that query engine will do to execute query based on stable accessed data snapshot before giving up.")
    @Internal
    public static final Setting<Integer> snapshot_query_retries = SettingImpl.newBuilder("unsupported.dbms.query.snapshot.retries", SettingValueParsers.INT, 5).addConstraint(SettingConstraints.range(1, Integer.MAX_VALUE)).build();
    @Description(value="The amount of memory to use for mapping the store files, in bytes (or kilobytes with the 'k' suffix, megabytes with 'm' and gigabytes with 'g'). If Neo4j is running on a dedicated server, then it is generally recommended to leave about 2-4 gigabytes for the operating system, give the JVM enough heap to hold all your transaction state and query context, and then leave the rest for the page cache. If no page cache memory is configured, then a heuristic setting is computed based on available system resources.")
    public static final Setting<String> pagecache_memory = SettingImpl.newBuilder("dbms.memory.pagecache.size", SettingValueParsers.STRING, null).build();
    @Description(value="Specify which page swapper to use for doing paged IO. This is only used when integrating with proprietary storage technology.")
    public static final Setting<String> pagecache_swapper = SettingImpl.newBuilder("dbms.memory.pagecache.swapper", SettingValueParsers.STRING, null).build();
    @Description(value="The profiling frequency for the page cache. Accurate profiles allow the page cache to do active warmup after a restart, reducing the mean time to performance. This feature available in Neo4j Enterprise Edition.")
    public static final Setting<Duration> pagecache_warmup_profiling_interval = SettingImpl.newBuilder("dbms.memory.pagecache.warmup.profile.interval", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).build();
    @Description(value="Page cache can be configured to perform usage sampling of loaded pages that can be used to construct active load profile. According to that profile pages can be reloaded on the restart, replication, etc. This setting allows disabling that behavior. This feature available in Neo4j Enterprise Edition.")
    public static final Setting<Boolean> pagecache_warmup_enabled = SettingImpl.newBuilder("dbms.memory.pagecache.warmup.enable", SettingValueParsers.BOOL, true).build();
    @Description(value="Page cache warmup can be configured to prefetch files, preferably when cache size is bigger than store size. Files to be prefetched can be filtered by 'dbms.memory.pagecache.warmup.preload.whitelist'. Enabling this disables warmup by profile ")
    public static final Setting<Boolean> pagecache_warmup_prefetch = SettingImpl.newBuilder("dbms.memory.pagecache.warmup.preload", SettingValueParsers.BOOL, false).build();
    @Description(value="Page cache warmup prefetch file whitelist regex. By default matches all files")
    public static final Setting<String> pagecache_warmup_prefetch_whitelist = SettingImpl.newBuilder("dbms.memory.pagecache.warmup.preload.whitelist", SettingValueParsers.STRING, ".*").build();
    @Description(value="Allows the enabling or disabling of the file watcher service. This is an auxiliary service but should be left enabled in almost all cases.")
    public static final Setting<Boolean> filewatcher_enabled = SettingImpl.newBuilder("dbms.filewatcher.enabled", SettingValueParsers.BOOL, true).build();
    @Description(value="Specifies the block size for storing strings. This parameter is only honored when the store is created, otherwise it is ignored. Note that each character in a string occupies two bytes, meaning that e.g a block size of 120 will hold a 60 character long string before overflowing into a second block. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    @Internal
    public static final Setting<Integer> string_block_size = SettingImpl.newBuilder("unsupported.dbms.block_size.strings", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="Specifies the block size for storing arrays. This parameter is only honored when the store is created, otherwise it is ignored. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    @Internal
    public static final Setting<Integer> array_block_size = SettingImpl.newBuilder("unsupported.dbms.block_size.array_properties", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="Specifies the block size for storing labels exceeding in-lined space in node record. This parameter is only honored when the store is created, otherwise it is ignored. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    @Internal
    public static final Setting<Integer> label_block_size = SettingImpl.newBuilder("unsupported.dbms.block_size.labels", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="An identifier that uniquely identifies this graph database instance within this JVM. Defaults to an auto-generated number depending on how many instance are started in this JVM.")
    @Internal
    public static final Setting<String> forced_kernel_id = SettingImpl.newBuilder("unsupported.dbms.kernel_id", SettingValueParsers.STRING, null).addConstraint(SettingConstraints.matches("[a-zA-Z0-9]*", "has to be a valid kernel identifier")).build();
    @Internal
    public static final Setting<Duration> vm_pause_monitor_measurement_duration = SettingImpl.newBuilder("unsupported.vm_pause_monitor.measurement_duration", SettingValueParsers.DURATION, Duration.ofMillis(100L)).build();
    @Internal
    public static final Setting<Duration> vm_pause_monitor_stall_alert_threshold = SettingImpl.newBuilder("unsupported.vm_pause_monitor.stall_alert_threshold", SettingValueParsers.DURATION, Duration.ofMillis(100L)).build();
    @Description(value="Relationship count threshold for considering a node to be dense")
    public static final Setting<Integer> dense_node_threshold = SettingImpl.newBuilder("dbms.relationship_grouping_threshold", SettingValueParsers.INT, 50).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="Specifies the use of the new faster but experimental consistency checker")
    public static final Setting<Boolean> experimental_consistency_checker = SettingImpl.newBuilder("unsupported.consistency_checker.experimental", SettingValueParsers.BOOL, false).build();
    @Description(value="Specifies if the experimental consistency checker should stop when number of observed inconsistencies exceed the threshold. If the value is zero, all inconsistencies will be reported")
    public static final Setting<Integer> experimental_consistency_checker_stop_threshold = SettingImpl.newBuilder("unsupported.consistency_checker.experimental.fail_fast", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="Log executed queries. Valid values are 'OFF', 'INFO' & 'VERBOSE'.\nOFF:  no logging.\nINFO: log queries at the end of execution, that take longer than the configured threshold, dbms.logs.query.threshold.\nVERBOSE: log queries at the start and end of execution, regardless of dbms.logs.query.threshold.\nLog entries are by default written to the file _query.log_ located in the Logs directory. This feature is available in the Neo4j Enterprise Edition.")
    public static final Setting<LogQueryLevel> log_queries = SettingImpl.newBuilder("dbms.logs.query.enabled", SettingValueParsers.ofEnum(LogQueryLevel.class), LogQueryLevel.VERBOSE).dynamic().build();
    @Description(value="Send user logs to the process stdout. If this is disabled then logs will instead be sent to the file _neo4j.log_ located in the logs directory.")
    public static final Setting<Boolean> store_user_log_to_stdout = SettingImpl.newBuilder("dbms.logs.user.stdout_enabled", SettingValueParsers.BOOL, true).build();
    @Description(value="Path of the logs directory.")
    public static final Setting<Path> logs_directory = SettingImpl.newBuilder("dbms.directories.logs", SettingValueParsers.PATH, Path.of("logs", new String[0])).setDependency(neo4j_home).immutable().build();
    @Description(value="Path to the query log file.")
    public static final Setting<Path> log_queries_filename = SettingImpl.newBuilder("dbms.logs.query.path", SettingValueParsers.PATH, Path.of("query.log", new String[0])).setDependency(logs_directory).immutable().build();
    @Description(value="Path to the user log file. Note that if dbms.logs.user.stdout_enabled is enabled this setting will be ignored.")
    public static final Setting<Path> store_user_log_path = SettingImpl.newBuilder("dbms.logs.user.path", SettingValueParsers.PATH, Path.of("neo4j.log", new String[0])).setDependency(logs_directory).immutable().build();
    @Description(value="Path to the debug log file.")
    public static final Setting<Path> store_internal_log_path = SettingImpl.newBuilder("dbms.logs.debug.path", SettingValueParsers.PATH, Path.of("debug.log", new String[0])).setDependency(logs_directory).immutable().build();
    @Description(value="Log parameters for the executed queries being logged.")
    public static final Setting<Boolean> log_queries_parameter_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.parameter_logging_enabled", SettingValueParsers.BOOL, true).dynamic().build();
    @Description(value="Log detailed time information for the executed queries being logged. Requires `dbms.track_query_cpu_time=true`")
    public static final Setting<Boolean> log_queries_detailed_time_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.time_logging_enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Log allocated bytes for the executed queries being logged. The logged number is cumulative over the duration of the query, i.e. for memory intense or long-running queries the value may be larger than the current memory allocation. Requires `dbms.track_query_allocation=true`")
    public static final Setting<Boolean> log_queries_allocation_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.allocation_logging_enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Logs which runtime that was used to run the query")
    public static final Setting<Boolean> log_queries_runtime_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.runtime_logging_enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Log page hits and page faults for the executed queries being logged.")
    public static final Setting<Boolean> log_queries_page_detail_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.page_logging_enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="If the execution of query takes more time than this threshold, the query is logged once completed - provided query logging is set to INFO. Defaults to 0 seconds, that is all queries are logged.")
    public static final Setting<Duration> log_queries_threshold = SettingImpl.newBuilder("dbms.logs.query.threshold", SettingValueParsers.DURATION, Duration.ZERO).dynamic().build();
    @Description(value="The file size in bytes at which the query log will auto-rotate. If set to zero then no rotation will occur. Accepts a binary suffix `k`, `m` or `g`.")
    public static final Setting<Long> log_queries_rotation_threshold = SettingImpl.newBuilder("dbms.logs.query.rotation.size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)20L)).addConstraint(SettingConstraints.range(0L, Long.MAX_VALUE)).dynamic().build();
    @Description(value="Maximum number of history files for the query log.")
    public static final Setting<Integer> log_queries_max_archives = SettingImpl.newBuilder("dbms.logs.query.rotation.keep_number", SettingValueParsers.INT, 7).addConstraint(SettingConstraints.min(1)).dynamic().build();
    @Description(value="Specifies number of operations that batch inserter will try to group into one batch before flushing data into underlying storage.")
    @Internal
    public static final Setting<Integer> batch_inserter_batch_size = SettingImpl.newBuilder("unsupported.tools.batch_inserter.batch_size", SettingValueParsers.INT, 10000).build();
    @Description(value="Enable auth requirement to access Neo4j.")
    @DocumentedDefaultValue(value="true")
    public static final Setting<Boolean> auth_enabled = SettingImpl.newBuilder("dbms.security.auth_enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Path> auth_store = SettingImpl.newBuilder("unsupported.dbms.security.auth_store.location", SettingValueParsers.PATH, null).setDependency(neo4j_home).immutable().build();
    @Description(value="The maximum number of unsuccessful authentication attempts before imposing a user lock for  the configured amount of time, as defined by `dbms.security.auth_lock_time`.The locked out user will not be able to log in until the lock period expires, even if correct  credentials are provided. Setting this configuration option to values less than 3 is not recommended because it might make  it easier for an attacker to brute force the password.")
    public static final Setting<Integer> auth_max_failed_attempts = SettingImpl.newBuilder("dbms.security.auth_max_failed_attempts", SettingValueParsers.INT, 3).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="The amount of time user account should be locked after a configured number of unsuccessful authentication attempts. The locked out user will not be able to log in until the lock period expires, even if correct credentials are provided. Setting this configuration option to a low value is not recommended because it might make it easier for an attacker to brute force the password.")
    public static final Setting<Duration> auth_lock_time = SettingImpl.newBuilder("dbms.security.auth_lock_time", SettingValueParsers.DURATION, Duration.ofSeconds(5L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(0L))).build();
    @Description(value="A list of procedures and user defined functions (comma separated) that are allowed full access to the database. The list may contain both fully-qualified procedure names, and partial names with the wildcard '*'. Note that this enables these procedures to bypass security. Use with caution.")
    public static final Setting<List<String>> procedure_unrestricted = SettingImpl.newBuilder("dbms.security.procedures.unrestricted", SettingValueParsers.listOf(SettingValueParsers.STRING), Collections.emptyList()).build();
    @Description(value="A list of procedures (comma separated) that are to be loaded. The list may contain both fully-qualified procedure names, and partial names with the wildcard '*'. If this setting is left empty no procedures will be loaded.")
    public static final Setting<List<String>> procedure_whitelist = SettingImpl.newBuilder("dbms.security.procedures.whitelist", SettingValueParsers.listOf(SettingValueParsers.STRING), List.of("*")).build();
    @Description(value="The default role that can execute all procedures and user-defined functions that are not covered by the `dbms.security.procedures.roles` setting. If the `dbms.security.procedures.default_allowed` setting is the empty string (default), procedures will be executed according to the same security rules as normal Cypher statements.")
    public static final Setting<String> default_allowed = SettingImpl.newBuilder("dbms.security.procedures.default_allowed", SettingValueParsers.STRING, "").build();
    @Description(value="This provides a finer level of control over which roles can execute procedures than the `dbms.security.procedures.default_allowed` setting. For example: `+dbms.security.procedures.roles=apoc.convert.*:reader;apoc.load.json*:writer;apoc.trigger.add:TriggerHappy+` will allow the role `reader` to execute all procedures in the `apoc.convert` namespace, the role `writer` to execute all procedures in the `apoc.load` namespace that starts with `json` and the role `TriggerHappy` to execute the specific procedure `apoc.trigger.add`. Procedures not matching any of these patterns will be subject to the `dbms.security.procedures.default_allowed` setting.")
    public static final Setting<String> procedure_roles = SettingImpl.newBuilder("dbms.security.procedures.roles", SettingValueParsers.STRING, "").build();
    @Description(value="Default network interface to listen for incoming connections. To listen for connections on all interfaces, use \"0.0.0.0\". ")
    public static final Setting<SocketAddress> default_listen_address = SettingImpl.newBuilder("dbms.default_listen_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress("localhost")).addConstraint(SettingConstraints.HOSTNAME_ONLY).immutable().build();
    @Description(value="Default hostname or IP address the server uses to advertise itself.")
    public static final Setting<SocketAddress> default_advertised_address = SettingImpl.newBuilder("dbms.default_advertised_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress("localhost")).addConstraint(SettingConstraints.HOSTNAME_ONLY).immutable().build();
    @Description(value="Whether to apply network level outbound network buffer based throttling")
    @Internal
    public static final Setting<Boolean> bolt_outbound_buffer_throttle = SettingImpl.newBuilder("unsupported.dbms.bolt.outbound_buffer_throttle", SettingValueParsers.BOOL, true).build();
    @Description(value="When the size (in bytes) of outbound network buffers, used by bolt's network layer, grows beyond this value bolt channel will advertise itself as unwritable and will block related processing thread until it becomes writable again.")
    @Internal
    public static final Setting<Integer> bolt_outbound_buffer_throttle_high_water_mark = SettingImpl.newBuilder("unsupported.dbms.bolt.outbound_buffer_throttle.high_watermark", SettingValueParsers.INT, (int)ByteUnit.kibiBytes((long)512L)).addConstraint(SettingConstraints.range((int)ByteUnit.kibiBytes((long)64L), Integer.MAX_VALUE)).build();
    @Description(value="When the size (in bytes) of outbound network buffers, previously advertised as unwritable, gets below this value bolt channel will re-advertise itself as writable and blocked processing thread will resume execution.")
    @Internal
    public static final Setting<Integer> bolt_outbound_buffer_throttle_low_water_mark = SettingImpl.newBuilder("unsupported.dbms.bolt.outbound_buffer_throttle.low_watermark", SettingValueParsers.INT, (int)ByteUnit.kibiBytes((long)128L)).addConstraint(SettingConstraints.range((int)ByteUnit.kibiBytes((long)16L), Integer.MAX_VALUE)).build();
    @Description(value="When the total time outbound network buffer based throttle lock is held exceeds this value, the corresponding bolt channel will be aborted. Setting this to 0 will disable this behaviour.")
    @Internal
    public static final Setting<Duration> bolt_outbound_buffer_throttle_max_duration = SettingImpl.newBuilder("unsupported.dbms.bolt.outbound_buffer_throttle.max_duration", SettingValueParsers.DURATION, Duration.ofMinutes(15L)).addConstraint(SettingConstraints.any(SettingConstraints.min(Duration.ofSeconds(30L)), SettingConstraints.is(Duration.ZERO))).build();
    @Description(value="When the number of queued inbound messages grows beyond this value, reading from underlying channel will be paused (no more inbound messages will be available) until queued number of messages drops below the configured low watermark value.")
    @Internal
    public static final Setting<Integer> bolt_inbound_message_throttle_high_water_mark = SettingImpl.newBuilder("unsupported.dbms.bolt.inbound_message_throttle.high_watermark", SettingValueParsers.INT, 300).addConstraint(SettingConstraints.range(1, Integer.MAX_VALUE)).build();
    @Description(value="When the number of queued inbound messages, previously reached configured high watermark value, drops below this value, reading from underlying channel will be enabled and any pending messages will start queuing again.")
    @Internal
    public static final Setting<Integer> bolt_inbound_message_throttle_low_water_mark = SettingImpl.newBuilder("unsupported.dbms.bolt.inbound_message_throttle.low_watermark", SettingValueParsers.INT, 100).addConstraint(SettingConstraints.range(1, Integer.MAX_VALUE)).build();
    @Description(value="Bolt Worker thread names will be extended with current database name in case the Worker is already associated with Transaction. This is useful if a Worker thread gets stuck and it is needed to figure out on which database was it working on from a Thread dump.")
    @Internal
    public static final Setting<Boolean> bolt_worker_threads_contain_database_name = SettingImpl.newBuilder("unsupported.dbms.bolt.worker_threads_contain_database", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Create an archive of an index before re-creating it if failing to load on startup.")
    @Internal
    public static final Setting<Boolean> archive_failed_index = SettingImpl.newBuilder("unsupported.dbms.index.archive_failed", SettingValueParsers.BOOL, false).build();
    @Description(value="The maximum amount of time to wait for the database state represented by the bookmark.")
    public static final Setting<Duration> bookmark_ready_timeout = SettingImpl.newBuilder("dbms.transaction.bookmark_ready_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(30L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="How long callers should cache the response of the routing procedure `dbms.routing.getRoutingTable()`")
    public static final Setting<Duration> routing_ttl = SettingImpl.newBuilder("dbms.routing_ttl", SettingValueParsers.DURATION, Duration.ofSeconds(300L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="Defines whether memory for transaction state should be allocated on- or off-heap. Note that for small transactions you can gain up to 25% write speed by setting it to `ON_HEAP`.")
    public static final Setting<TransactionStateMemoryAllocation> tx_state_memory_allocation = SettingImpl.newBuilder("dbms.tx_state.memory_allocation", SettingValueParsers.ofEnum(TransactionStateMemoryAllocation.class), TransactionStateMemoryAllocation.OFF_HEAP).build();
    @Description(value="The maximum amount of off-heap memory that can be used to store transaction state data; it's a total amount of memory shared across all active transactions. Zero means 'unlimited'. Used when dbms.tx_state.memory_allocation is set to 'OFF_HEAP'.")
    public static final Setting<Long> tx_state_max_off_heap_memory = SettingImpl.newBuilder("dbms.tx_state.max_off_heap_memory", SettingValueParsers.BYTES, SettingValueParsers.BYTES.parse("2G")).addConstraint(SettingConstraints.min(0L)).build();
    @Description(value="Defines the maximum size of an off-heap memory block that can be cached to speed up allocations for transaction state data. The value must be a power of 2.")
    public static final Setting<Long> tx_state_off_heap_max_cacheable_block_size = SettingImpl.newBuilder("dbms.tx_state.off_heap.max_cacheable_block_size", SettingValueParsers.BYTES, ByteUnit.kibiBytes((long)512L)).addConstraint(SettingConstraints.min(ByteUnit.kibiBytes((long)4L))).addConstraint(SettingConstraints.POWER_OF_2).build();
    @Description(value="Defines the size of the off-heap memory blocks cache. The cache will contain this number of blocks for each block size that is power of two. Thus, maximum amount of memory used by blocks cache can be calculated as 2 * dbms.tx_state.off_heap.max_cacheable_block_size * dbms.tx_state.off_heap.block_cache_size")
    public static final Setting<Integer> tx_state_off_heap_block_cache_size = SettingImpl.newBuilder("dbms.tx_state.off_heap.block_cache_size", SettingValueParsers.INT, 128).addConstraint(SettingConstraints.min(16)).build();
    @Description(value="Defines whether the dbms may retry reconciling a database to its desired state.")
    public static final Setting<Boolean> reconciler_may_retry = SettingImpl.newBuilder("dbms.reconciler.may_retry", SettingValueParsers.BOOL, false).build();
    @Description(value="Defines the maximum amount of time to wait before retrying after the dbms fails to reconcile a database to its desired state.")
    public static final Setting<Duration> reconciler_maximum_backoff = SettingImpl.newBuilder("dbms.reconciler.max_backoff", SettingValueParsers.DURATION, Duration.ofHours(1L)).addConstraint(SettingConstraints.min(Duration.ofMinutes(1L))).build();
    @Description(value="Defines the minimum amount of time to wait before retrying after the dbms fails to reconcile a database to its desired state.")
    public static final Setting<Duration> reconciler_minimum_backoff = SettingImpl.newBuilder("dbms.reconciler.min_backoff", SettingValueParsers.DURATION, Duration.ofSeconds(2L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="Defines the level of parallelism employed by the reconciler. By default the parallelism is Integer.MAX_VALUE (i.e. a cached thread pool is used). An explicit setting of 0 implies parallelism equal to the number of cores available on the host machine.")
    @Internal
    public static final Setting<Integer> reconciler_maximum_parallelism = SettingImpl.newBuilder("dbms.reconciler.max_parallelism", SettingValueParsers.INT, Integer.MAX_VALUE).build();
    @Description(value="Forces smaller ID cache, in order to preserve memory.")
    @Internal
    public static final Setting<Boolean> force_small_id_cache = SettingImpl.newBuilder("unsupported.dbms.force_small_id_cache", SettingValueParsers.BOOL, Boolean.FALSE).build();
    @Internal
    public static final Setting<Boolean> consistency_check_on_apply = SettingImpl.newBuilder("unsupported.dbms.storage.consistency_check_on_apply", SettingValueParsers.BOOL, Boolean.FALSE).build();
    @Internal
    @Description(value="Whether or not to log contents of data that is inconsistent when deleting it.")
    public static final Setting<Boolean> log_inconsistent_data_deletion = SettingImpl.newBuilder("dbms.log_inconsistent_data_deletion", SettingValueParsers.BOOL, Boolean.FALSE).dynamic().build();
    public static final Map<Setting<?>, Object> SERVER_DEFAULTS = Maps.mutable.withMap(ConnectorDefaults.SERVER_CONNECTOR_DEFAULTS).withKeyValue(auth_enabled, (Object)true);

    public static enum TransactionStateMemoryAllocation {
        ON_HEAP,
        OFF_HEAP;

    }

    public static enum LogQueryLevel {
        OFF,
        INFO,
        VERBOSE;

    }

    public static enum SchemaIndex {
        NATIVE_BTREE10("native-btree", "1.0", false),
        NATIVE30("lucene+native", "3.0", false);

        private final String providerKey;
        private final String providerVersion;
        private final boolean deprecated;
        private final String providerName;

        private SchemaIndex(String providerKey, String providerVersion, boolean deprecated) {
            this.providerKey = providerKey;
            this.providerVersion = providerVersion;
            this.deprecated = deprecated;
            this.providerName = SchemaIndex.toProviderName(providerKey, providerVersion);
        }

        public String providerName() {
            return this.providerName;
        }

        public String providerKey() {
            return this.providerKey;
        }

        public String providerVersion() {
            return this.providerVersion;
        }

        public boolean deprecated() {
            return this.deprecated;
        }

        public String toString() {
            return this.providerName;
        }

        private static String toProviderName(String providerName, String providerVersion) {
            return providerName + "-" + providerVersion;
        }
    }

    public static enum CheckpointPolicy {
        PERIODIC,
        CONTINUOUS,
        VOLUMETRIC;

    }

    public static enum TransactionTracingLevel {
        DISABLED,
        SAMPLE,
        ALL;

    }

    public static enum CypherPipelinedInterpretedPipesFallback {
        DISABLED,
        DEFAULT,
        ALL;

    }

    public static enum CypherOperatorEngine {
        COMPILED,
        INTERPRETED;

    }

    public static enum CypherReplanAlgorithm {
        DEFAULT,
        NONE,
        INVERSE,
        EXPONENTIAL;

    }

    public static enum CypherExpressionEngine {
        DEFAULT,
        INTERPRETED,
        COMPILED,
        ONLY_WHEN_HOT;

    }

    public static enum CypherRuntime {
        DEFAULT,
        INTERPRETED,
        COMPILED,
        SLOTTED,
        PIPELINED;

    }

    public static enum CypherPlanner {
        DEFAULT,
        COST;

    }

    public static enum CypherParserVersion {
        DEFAULT("default"),
        V_35("3.5"),
        V_40("4.0");

        private final String name;

        private CypherParserVersion(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

