/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.neo4j.annotations.api.IgnoreApiCheck;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.ExternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.GroupSetting;
import org.neo4j.configuration.GroupSettingValidator;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingMigrator;
import org.neo4j.configuration.SettingObserver;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.logging.BufferingLog;
import org.neo4j.logging.Log;
import org.neo4j.service.Services;

@IgnoreApiCheck
public class Config
implements Configuration {
    public static final String DEFAULT_CONFIG_FILE_NAME = "neo4j.conf";
    protected final Map<String, Entry<?>> settings = new HashMap();
    private final Map<Class<? extends GroupSetting>, Map<String, GroupSetting>> allGroupInstances = new HashMap<Class<? extends GroupSetting>, Map<String, GroupSetting>>();
    private Log log;

    public static Config defaults() {
        return Config.defaults(Map.of());
    }

    public static <T> Config defaults(Setting<T> setting, T value) {
        return Config.defaults(Map.of(setting, value));
    }

    public static Config defaults(Map<Setting<?>, Object> settingValues) {
        return Config.newBuilder().set(settingValues).build();
    }

    public static Builder newBuilder() {
        Builder builder = new Builder();
        Services.loadAll(SettingsDeclaration.class).forEach(decl -> builder.addSettingsClass(decl.getClass()));
        Services.loadAll(GroupSetting.class).forEach(decl -> builder.addGroupSettingClass(decl.getClass()));
        Services.loadAll(SettingMigrator.class).forEach(builder::addMigrator);
        return builder;
    }

    public static Builder emptyBuilder() {
        return new Builder();
    }

    protected Config() {
    }

    private Config(Collection<Class<? extends SettingsDeclaration>> settingsClasses, Collection<Class<? extends GroupSetting>> groupSettingClasses, List<Class<? extends GroupSettingValidator>> validatorClasses, Collection<SettingMigrator> settingMigrators, Map<String, String> settingValueStrings, Map<String, Object> settingValueObjects, Map<String, Object> overriddenDefaultObjects, Config fromConfig, Log log) {
        this.log = log;
        HashMap<String, String> overriddenDefaultStrings = new HashMap<String, String>();
        try {
            settingMigrators.forEach(migrator -> migrator.migrate(settingValueStrings, overriddenDefaultStrings, log));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error while migrating settings, please see the exception cause", e);
        }
        Map<String, SettingImpl<?>> definedSettings = Config.getDefinedSettings(settingsClasses);
        Map<String, Class<? extends GroupSetting>> definedGroups = Config.getDefinedGroups(groupSettingClasses);
        HashSet<String> keys = new HashSet<String>(definedSettings.keySet());
        keys.addAll(settingValueStrings.keySet());
        keys.addAll(settingValueObjects.keySet());
        ArrayList newSettings = new ArrayList();
        if (fromConfig != null) {
            fromConfig.allGroupInstances.forEach((cls, fromGroupMap) -> {
                Map groupMap = this.allGroupInstances.computeIfAbsent((Class<? extends GroupSetting>)cls, k -> new HashMap());
                groupMap.putAll(fromGroupMap);
            });
            for (Map.Entry<String, Entry<?>> entry : fromConfig.settings.entrySet()) {
                newSettings.add(entry.getValue().setting);
                keys.remove(entry.getKey());
            }
        }
        boolean strict = (Boolean)GraphDatabaseSettings.strict_config_validation.defaultValue();
        if (keys.remove(GraphDatabaseSettings.strict_config_validation.name())) {
            this.evaluateSetting(GraphDatabaseSettings.strict_config_validation, settingValueStrings, settingValueObjects, fromConfig, overriddenDefaultStrings, overriddenDefaultObjects);
            strict = this.get(GraphDatabaseSettings.strict_config_validation);
        }
        newSettings.addAll(this.getActiveSettings(keys, definedGroups, definedSettings, strict));
        this.evaluateSettingValues(newSettings, settingValueStrings, settingValueObjects, overriddenDefaultStrings, overriddenDefaultObjects, fromConfig);
        this.validateGroupsettings(validatorClasses);
    }

    private void evaluateSettingValues(Collection<SettingImpl<?>> settingsToEvaluate, Map<String, String> settingValueStrings, Map<String, Object> settingValueObjects, Map<String, String> overriddenDefaultStrings, Map<String, Object> overriddenDefaultObjects, Config fromConfig) {
        LinkedList newSettings = new LinkedList(settingsToEvaluate);
        while (!newSettings.isEmpty()) {
            SettingImpl setting;
            boolean modified = false;
            SettingImpl last = (SettingImpl)newSettings.peekLast();
            do {
                if ((setting = Objects.requireNonNull((SettingImpl)newSettings.pollFirst())).dependency() != null && !this.settings.containsKey(setting.dependency().name())) {
                    newSettings.addLast(setting);
                    continue;
                }
                modified = true;
                this.evaluateSetting(setting, settingValueStrings, settingValueObjects, fromConfig, overriddenDefaultStrings, overriddenDefaultObjects);
            } while (setting != last);
            if (modified || newSettings.isEmpty()) continue;
            String unsolvable = newSettings.stream().map(s -> String.format("'%s'->'%s'", s.name(), s.dependency().name())).collect(Collectors.joining(",\n", "[", "]"));
            throw new IllegalArgumentException(String.format("Can not resolve setting dependencies. %s depend on settings not present in config, or are in a circular dependency ", unsolvable));
        }
    }

    private Collection<SettingImpl<?>> getActiveSettings(Set<String> settingNames, Map<String, Class<? extends GroupSetting>> definedGroups, Map<String, SettingImpl<?>> declaredSettings, boolean strict) {
        ArrayList newSettings = new ArrayList();
        for (String key : settingNames) {
            GroupSetting group;
            Map groupInstances;
            String id;
            SettingImpl<?> setting = declaredSettings.get(key);
            if (setting != null) {
                newSettings.add(setting);
                continue;
            }
            Optional<Map.Entry> groupEntryOpt = definedGroups.entrySet().stream().filter(e -> key.startsWith((String)e.getKey() + ".")).findAny();
            if (groupEntryOpt.isEmpty()) {
                String msg = String.format("Unrecognized setting. No declared setting with name: %s", key);
                if (strict) {
                    throw new IllegalArgumentException(msg);
                }
                this.log.warn(msg);
                continue;
            }
            Map.Entry groupEntry = groupEntryOpt.get();
            String prefix = (String)groupEntry.getKey();
            String keyWithoutPrefix = key.substring(prefix.length() + 1);
            if (keyWithoutPrefix.matches("^[^.]+$")) {
                id = keyWithoutPrefix;
            } else if (keyWithoutPrefix.matches("^[^.]+\\.[^.]+$")) {
                id = keyWithoutPrefix.substring(0, keyWithoutPrefix.indexOf(46));
            } else {
                String msg = String.format("Malformed group setting name: '%s', does not match any setting in its group.", key);
                if (strict) {
                    throw new IllegalArgumentException(msg);
                }
                this.log.warn(msg);
                continue;
            }
            if ((groupInstances = this.allGroupInstances.computeIfAbsent((Class)groupEntry.getValue(), k -> new HashMap())).containsKey(id)) continue;
            try {
                group = (GroupSetting)Config.createStringInstance((Class)groupEntry.getValue(), id);
            }
            catch (IllegalArgumentException e2) {
                String msg = String.format("Unrecognized setting. No declared setting with name: %s", key);
                if (strict) {
                    throw new IllegalArgumentException(msg);
                }
                this.log.warn(msg);
                continue;
            }
            groupInstances.put(id, group);
            Map<String, SettingImpl<?>> definedSettings = Config.getDefinedSettings(group.getClass(), group);
            if (definedSettings.values().stream().anyMatch(SettingImpl::dynamic)) {
                throw new IllegalArgumentException(String.format("Group setting can not be dynamic: '%s'", key));
            }
            newSettings.addAll(definedSettings.values());
        }
        return newSettings;
    }

    private void validateGroupsettings(List<Class<? extends GroupSettingValidator>> validatorClasses) {
        for (GroupSettingValidator validator : Config.getGroupSettingValidators(validatorClasses)) {
            String prefix = validator.getPrefix() + ".";
            Map values = this.settings.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(HashMap::new, (map, entry) -> map.put(((Entry)entry.getValue()).setting, ((Entry)entry.getValue()).getValue()), HashMap::putAll);
            validator.validate(values, this);
        }
    }

    private void evaluateSetting(Setting<?> untypedSetting, Map<String, String> settingValueStrings, Map<String, Object> settingValueObjects, Config fromConfig, Map<String, String> overriddenDefaultStrings, Map<String, Object> overriddenDefaultObjects) {
        SettingImpl setting = (SettingImpl)untypedSetting;
        String key = setting.name();
        try {
            Object defaultValue = null;
            if (overriddenDefaultObjects.containsKey(key)) {
                defaultValue = overriddenDefaultObjects.get(key);
            } else if (overriddenDefaultStrings.containsKey(key)) {
                defaultValue = setting.parse(overriddenDefaultStrings.get(key));
            } else {
                Object fromDefault;
                defaultValue = setting.defaultValue();
                if (fromConfig != null && fromConfig.settings.containsKey(key) && !Objects.equals(defaultValue, fromDefault = fromConfig.settings.get((Object)key).defaultValue)) {
                    defaultValue = fromDefault;
                }
            }
            Object value = null;
            if (settingValueObjects.containsKey(key)) {
                value = settingValueObjects.get(key);
            } else if (settingValueStrings.containsKey(key)) {
                value = setting.parse(settingValueStrings.get(key));
            } else if (fromConfig != null && fromConfig.settings.containsKey(key)) {
                Entry<?> entry = fromConfig.settings.get(key);
                value = entry.isDefault ? null : entry.value;
            }
            value = setting.solveDefault(value, defaultValue);
            this.settings.put(key, this.createEntry(setting, value, defaultValue));
        }
        catch (RuntimeException exception) {
            String msg = String.format("Error evaluating value for setting '%s'. %s", setting.name(), exception.getMessage());
            throw new IllegalArgumentException(msg, exception);
        }
    }

    private <T> Entry<T> createEntry(SettingImpl<T> setting, T value, T defaultValue) {
        if (setting.dependency() != null) {
            Entry<?> dep = this.settings.get(setting.dependency().name());
            T solvedValue = setting.solveDependency(value != null ? value : defaultValue, dep.getValue());
            setting.validate(solvedValue);
            return new DepEntry<T>(setting, value, defaultValue, solvedValue);
        }
        setting.validate(defaultValue);
        setting.validate(value);
        return new Entry<T>(setting, value, defaultValue);
    }

    public <T extends GroupSetting> Map<String, T> getGroups(Class<T> group) {
        return new HashMap(this.allGroupInstances.getOrDefault(group, new HashMap()));
    }

    public <T extends GroupSetting, U extends T> Map<Class<U>, Map<String, U>> getGroupsFromInheritance(Class<T> parentClass) {
        return this.allGroupInstances.keySet().stream().filter(parentClass::isAssignableFrom).map(childClass -> childClass).collect(Collectors.toMap(childClass -> childClass, this::getGroups));
    }

    private static List<GroupSettingValidator> getGroupSettingValidators(List<Class<? extends GroupSettingValidator>> validatorClasses) {
        ArrayList<GroupSettingValidator> validators = new ArrayList<GroupSettingValidator>();
        validatorClasses.forEach(validatorClass -> validators.add((GroupSettingValidator)Config.createInstance(validatorClass)));
        return validators;
    }

    private static <T> T createInstance(Class<T> classObj) {
        T instance;
        try {
            instance = Config.createStringInstance(classObj, null);
        }
        catch (Exception first) {
            try {
                Constructor<T> constructor = classObj.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception second) {
                String name = classObj.getSimpleName();
                String msg = String.format("Failed to create instance of: %s, please see the exception cause", name);
                throw new IllegalArgumentException(msg, Exceptions.chain((Throwable)second, (Throwable)first));
            }
        }
        return instance;
    }

    public <T> T get(Setting<T> setting) {
        return this.getObserver(setting).getValue();
    }

    public <T> SettingObserver<T> getObserver(Setting<T> setting) {
        SettingObserver observer = this.settings.get(setting.name());
        if (observer != null) {
            return observer;
        }
        throw new IllegalArgumentException(String.format("Config has no association with setting: '%s'", setting.name()));
    }

    public <T> void setDynamic(Setting<T> setting, T value, String scope) {
        Entry entry = (Entry)this.getObserver(setting);
        SettingImpl<T> actualSetting = entry.setting;
        if (!actualSetting.dynamic()) {
            throw new IllegalArgumentException(String.format("Setting '%s' is not dynamic and can not be changed at runtime", setting.name()));
        }
        this.set(setting, value);
        this.log.info("%s changed to %s, by %s", new Object[]{setting.name(), actualSetting.valueToString(value), scope});
    }

    public <T> void set(Setting<T> setting, T value) {
        Entry entry = (Entry)this.getObserver(setting);
        SettingImpl actualSetting = entry.setting;
        if (actualSetting.immutable()) {
            throw new IllegalArgumentException(String.format("Setting '%s' immutable (final). Can not amend", actualSetting.name()));
        }
        entry.setValue(value);
    }

    public <T> void setIfNotSet(Setting<T> setting, T value) {
        Entry entry = (Entry)this.getObserver(setting);
        if (entry == null || entry.isDefault) {
            this.set(setting, value);
        }
    }

    public boolean isExplicitlySet(Setting<?> setting) {
        if (this.settings.containsKey(setting.name())) {
            return !this.settings.get((Object)setting.name()).isDefault;
        }
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeNullValues) {
        StringBuilder sb = new StringBuilder();
        this.settings.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
            SettingImpl setting = ((Entry)e.getValue()).setting;
            Object valueObj = ((Entry)e.getValue()).getValue();
            if (valueObj != null || includeNullValues) {
                String value = setting.valueToString(valueObj);
                sb.append(String.format("%s=%s%n", e.getKey(), value));
            }
        });
        return sb.toString();
    }

    public void setLogger(Log log) {
        if (this.log instanceof BufferingLog) {
            ((BufferingLog)this.log).replayInto(log);
        }
        this.log = log;
    }

    public Map<Setting<Object>, Object> getValues() {
        HashMap<Setting<Object>, Object> values = new HashMap<Setting<Object>, Object>();
        this.settings.forEach((s, entry) -> values.put(entry.setting, entry.value));
        return values;
    }

    public Setting<Object> getSetting(String name) {
        if (!this.settings.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Setting `%s` not found", name));
        }
        return this.settings.get((Object)name).setting;
    }

    public Map<String, Setting<Object>> getDeclaredSettings() {
        return this.settings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Entry)entry.getValue()).setting));
    }

    private static Map<String, Class<? extends GroupSetting>> getDefinedGroups(Collection<Class<? extends GroupSetting>> groupSettingClasses) {
        return groupSettingClasses.stream().collect(Collectors.toMap(cls -> ((GroupSetting)Config.createInstance(cls)).getPrefix(), cls -> cls));
    }

    private static <T> T createStringInstance(Class<T> cls, String id) {
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            return constructor.newInstance(id);
        }
        catch (Exception e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw new IllegalArgumentException("Could not create instance with id: " + id, e);
            }
            String msg = String.format("'%s' must have a ( @Nullable String ) constructor, be static & non-abstract", cls.getSimpleName());
            throw new RuntimeException(msg, e);
        }
    }

    private static Map<String, SettingImpl<?>> getDefinedSettings(Collection<Class<? extends SettingsDeclaration>> settingsClasses) {
        HashMap settings = new HashMap();
        settingsClasses.forEach(c -> settings.putAll(Config.getDefinedSettings(c, null)));
        return settings;
    }

    private static Map<String, SettingImpl<?>> getDefinedSettings(Class<?> settingClass, Object fromObject) {
        HashMap settings = new HashMap();
        Arrays.stream(FieldUtils.getAllFields(settingClass)).filter(f -> f.getType().isAssignableFrom(SettingImpl.class)).forEach(field -> {
            try {
                field.setAccessible(true);
                SettingImpl setting = (SettingImpl)field.get(fromObject);
                if (field.isAnnotationPresent(Description.class)) {
                    setting.setDescription(field.getAnnotation(Description.class).value());
                }
                if (field.isAnnotationPresent(DocumentedDefaultValue.class)) {
                    setting.setDocumentedDefaultValue(field.getAnnotation(DocumentedDefaultValue.class).value());
                }
                if (field.isAnnotationPresent(Internal.class)) {
                    setting.setInternal();
                }
                if (field.isAnnotationPresent(Deprecated.class)) {
                    setting.setDeprecated();
                }
                settings.put(setting.name(), setting);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("%s %s, from %s is not accessible.", field.getType(), field.getName(), settingClass.getSimpleName()), e);
            }
        });
        return settings;
    }

    public <T> void addListener(Setting<T> setting, SettingChangeListener<T> listener) {
        Entry entry = (Entry)this.getObserver(setting);
        entry.addListener(listener);
    }

    public <T> void removeListener(Setting<T> setting, SettingChangeListener<T> listener) {
        Entry entry = (Entry)this.getObserver(setting);
        entry.removeListener(listener);
    }

    private static class Entry<T>
    implements SettingObserver<T> {
        protected final SettingImpl<T> setting;
        protected final T defaultValue;
        private final Collection<SettingChangeListener<T>> updateListeners = new ConcurrentLinkedQueue<SettingChangeListener<T>>();
        private volatile T value;
        private volatile boolean isDefault;

        private Entry(SettingImpl<T> setting, T value, T defaultValue) {
            this.setting = setting;
            this.defaultValue = defaultValue;
            this.internalSetValue(value);
        }

        @Override
        public T getValue() {
            return this.value;
        }

        synchronized void setValue(T value) {
            T oldValue = this.value;
            this.internalSetValue(value);
            this.updateListeners.forEach(listener -> listener.accept(oldValue, this.value));
        }

        private void internalSetValue(T value) {
            this.isDefault = value == null;
            this.value = this.isDefault ? this.defaultValue : value;
        }

        private void addListener(SettingChangeListener<T> listener) {
            if (!this.setting.dynamic()) {
                throw new IllegalArgumentException("Setting is not dynamic and will not change");
            }
            this.updateListeners.add(listener);
        }

        private void removeListener(SettingChangeListener<T> listener) {
            this.updateListeners.remove(listener);
        }

        public String toString() {
            return this.setting.valueToString(this.value) + (this.isDefault ? " (default)" : " (configured)");
        }
    }

    private class DepEntry<T>
    extends Entry<T> {
        private volatile T solved;

        private DepEntry(SettingImpl<T> setting, T value, T defaultValue, T solved) {
            super(setting, value, defaultValue);
            this.solved = solved;
        }

        @Override
        public T getValue() {
            return this.solved;
        }

        @Override
        synchronized void setValue(T value) {
            super.setValue(value);
            this.solved = this.setting.solveDependency(value != null ? value : this.defaultValue, Config.this.getObserver(this.setting.dependency()).getValue());
        }
    }

    public static class Builder {
        private final Collection<Class<? extends SettingsDeclaration>> settingsClasses = new HashSet<Class<? extends SettingsDeclaration>>();
        private final Collection<Class<? extends GroupSetting>> groupSettingClasses = new HashSet<Class<? extends GroupSetting>>();
        private final Collection<SettingMigrator> settingMigrators = new HashSet<SettingMigrator>();
        private final List<Class<? extends GroupSettingValidator>> validators = new ArrayList<Class<? extends GroupSettingValidator>>();
        private final Map<String, String> settingValueStrings = new HashMap<String, String>();
        private final Map<String, Object> settingValueObjects = new HashMap<String, Object>();
        private final Map<String, Object> overriddenDefaults = new HashMap<String, Object>();
        private Config fromConfig;
        private Log log = new BufferingLog();

        private static boolean allowedToLogOverriddenValues(String setting) {
            return !Objects.equals(setting, ExternalSettings.additionalJvm.name());
        }

        private void overrideSettingValue(String setting, Object value) {
            String msg = "The '%s' setting is overridden. Setting value changed from '%s' to '%s'.";
            if (this.settingValueStrings.containsKey(setting) && Builder.allowedToLogOverriddenValues(setting)) {
                this.log.warn(msg, new Object[]{setting, this.settingValueStrings.remove(setting), value});
            }
            if (this.settingValueObjects.containsKey(setting)) {
                this.log.warn(msg, new Object[]{setting, this.settingValueObjects.remove(setting), value});
            }
        }

        private Builder setRaw(String setting, String value) {
            this.overrideSettingValue(setting, value);
            this.settingValueStrings.put(setting, value);
            return this;
        }

        private Builder set(String setting, Object value) {
            this.overrideSettingValue(setting, value);
            this.settingValueObjects.put(setting, value);
            return this;
        }

        public Builder setRaw(Map<String, String> settingValues) {
            settingValues.forEach(this::setRaw);
            return this;
        }

        public <T> Builder set(Setting<T> setting, T value) {
            return this.set(setting.name(), value);
        }

        public Builder set(Map<Setting<?>, Object> settingValues) {
            settingValues.forEach((setting, value) -> this.set(setting.name(), value));
            return this;
        }

        private Builder setDefault(String setting, Object value) {
            if (this.overriddenDefaults.containsKey(setting) && Builder.allowedToLogOverriddenValues(setting)) {
                this.log.warn("The overridden default value of '%s' setting is overridden. Setting value changed from '%s' to '%s'.", new Object[]{setting, this.overriddenDefaults.get(setting), value});
            }
            this.overriddenDefaults.put(setting, value);
            return this;
        }

        public Builder setDefaults(Map<Setting<?>, Object> overriddenDefaults) {
            overriddenDefaults.forEach((setting, value) -> this.setDefault(setting.name(), value));
            return this;
        }

        public <T> Builder setDefault(Setting<T> setting, T value) {
            return this.setDefault(setting.name(), value);
        }

        public Builder remove(Setting<?> setting) {
            this.settingValueStrings.remove(setting.name());
            this.settingValueObjects.remove(setting.name());
            return this;
        }

        public Builder removeDefault(Setting<?> setting) {
            this.overriddenDefaults.remove(setting.name());
            return this;
        }

        Builder addSettingsClass(Class<? extends SettingsDeclaration> settingsClass) {
            this.settingsClasses.add(settingsClass);
            return this;
        }

        Builder addGroupSettingClass(Class<? extends GroupSetting> groupSettingClass) {
            this.groupSettingClasses.add(groupSettingClass);
            return this;
        }

        public Builder addValidators(List<Class<? extends GroupSettingValidator>> validators) {
            this.validators.addAll(validators);
            return this;
        }

        public Builder addValidator(Class<? extends GroupSettingValidator> validator) {
            this.validators.add(validator);
            return this;
        }

        public Builder addMigrator(SettingMigrator migrator) {
            this.settingMigrators.add(migrator);
            return this;
        }

        public Builder fromConfig(Config config) {
            if (this.fromConfig != null) {
                throw new IllegalArgumentException("Can only build a config from one other config.");
            }
            this.fromConfig = config;
            return this;
        }

        public Builder fromFileNoThrow(Path path) {
            if (path != null) {
                this.fromFile(path.toFile(), false);
            }
            return this;
        }

        public Builder fromFileNoThrow(File cfg) {
            return this.fromFile(cfg, false);
        }

        public Builder fromFile(File cfg) {
            return this.fromFile(cfg, true);
        }

        private Builder fromFile(File file, boolean allowThrow) {
            if (file == null || !file.exists()) {
                if (allowThrow) {
                    throw new IllegalArgumentException(new IOException("Config file [" + file + "] does not exist."));
                }
                this.log.warn("Config file [%s] does not exist.", new Object[]{file});
                return this;
            }
            try (FileInputStream stream = new FileInputStream(file);){
                new Properties(){

                    @Override
                    public synchronized Object put(Object key, Object value) {
                        this.setRaw(key.toString(), value.toString());
                        return null;
                    }
                }.load(stream);
            }
            catch (IOException e) {
                if (allowThrow) {
                    throw new IllegalArgumentException("Unable to load config file [" + file + "].", e);
                }
                this.log.error("Unable to load config file [%s]: %s", new Object[]{file, e.getMessage()});
            }
            return this;
        }

        private Builder() {
        }

        public Config build() {
            return new Config(this.settingsClasses, this.groupSettingClasses, this.validators, this.settingMigrators, this.settingValueStrings, this.settingValueObjects, this.overriddenDefaults, this.fromConfig, this.log);
        }
    }
}

