/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.helpers.DatabaseNameValidator;

public class DatabaseNamePattern {
    private final Optional<Pattern> regexPattern;
    private final String databaseName;

    public DatabaseNamePattern(String name) {
        DatabaseNameValidator.validateDatabaseNamePattern(name);
        this.regexPattern = DatabaseNamePattern.buildRegexPattern(name.toLowerCase());
        this.databaseName = name;
    }

    public boolean matches(String value) {
        return this.regexPattern.map(p -> p.matcher(value.toLowerCase()).matches()).orElse(this.databaseName.equals(value));
    }

    public boolean containsPattern() {
        return this.regexPattern.isPresent();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public static Optional<Pattern> buildRegexPattern(String name) {
        if (!StringUtils.containsAny((CharSequence)name, (CharSequence)"*?")) {
            return Optional.empty();
        }
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '*') {
                pattern.append(".+");
                continue;
            }
            if (ch == '?') {
                pattern.append(".{0,1}");
                continue;
            }
            if (ch == '.' || ch == '-') {
                pattern.append("\\").append(ch);
                continue;
            }
            pattern.append(ch);
        }
        return Optional.of(Pattern.compile(pattern.toString()));
    }

    public String toString() {
        if (this.containsPattern()) {
            return "Database name pattern=" + this.databaseName;
        }
        return "Database name=" + this.databaseName;
    }
}

