/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.time.Duration;
import java.util.Objects;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.internal.helpers.TimeUtil;

@PublicApi
public class DurationRange {
    private Duration min;
    private Duration max;

    public DurationRange(Duration min, Duration max) {
        this.min = min;
        this.max = max;
        if (min.toNanos() > max.toNanos()) {
            throw new IllegalArgumentException("min may not be longer than max");
        }
    }

    public static DurationRange fromSeconds(int min, int max) {
        return new DurationRange(Duration.ofSeconds(min), Duration.ofSeconds(max));
    }

    public static DurationRange parse(String value) {
        String[] parts = value.trim().replaceAll("^\\[", "").replaceAll("\\]$", "").split("-");
        if (parts.length != 2 || parts[0].isEmpty() || parts[1].isEmpty()) {
            throw new IllegalArgumentException("must be in format <min>-<max>, where min and max are non-negative durations");
        }
        Duration min = Duration.ofMillis((Long)TimeUtil.parseTimeMillis.apply(parts[0]));
        Duration max = Duration.ofMillis((Long)TimeUtil.parseTimeMillis.apply(parts[1]));
        return new DurationRange(min, max);
    }

    public Duration getMin() {
        return this.min;
    }

    public Duration getMax() {
        return this.max;
    }

    public Duration getDelta() {
        return this.max.minus(this.min);
    }

    public String valueToString() {
        return TimeUtil.nanosToString((long)this.min.toNanos()) + "-" + TimeUtil.nanosToString((long)this.max.toNanos());
    }

    public String toString() {
        return "[" + this.min.toString() + "-" + this.max + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationRange that = (DurationRange)o;
        return this.min.equals(that.min) && this.max.equals(that.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }
}

