/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import java.nio.file.Path;
import java.time.Duration;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;

public final class BoltConnectorInternalSettings
implements SettingsDeclaration {
    public static final String LOOPBACK_NAME = "bolt-loopback";
    public static final int DEFAULT_LOOPBACK_CONNECTOR_PORT = 7689;
    @Internal
    @Description(value="The queue size of the thread pool bound to this connector (-1 for unbounded, 0 for direct handoff, > 0 for bounded)")
    public static final Setting<Integer> unsupported_thread_pool_queue_size = SettingImpl.newBuilder("dbms.connector.bolt.unsupported_thread_pool_queue_size", SettingValueParsers.INT, 0).build();
    @Internal
    @Description(value="Enable TCP keep alive probes on this connector")
    public static final Setting<Boolean> tcp_keep_alive = SettingImpl.newBuilder("dbms.connector.bolt.tcp_keep_alive", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="The type of messages to enable keep-alive messages for (ALL, STREAMING or OFF)")
    public static final Setting<KeepAliveRequestType> connection_keep_alive_type = SettingImpl.newBuilder("dbms.connector.bolt.connection_keep_alive_for_requests", SettingValueParsers.ofEnum(KeepAliveRequestType.class), KeepAliveRequestType.STREAMING).build();
    @Internal
    @Description(value="The maximum time to wait before sending a NOOP on connections waiting for responses from active ongoing queries.")
    public static final Setting<Duration> connection_keep_alive = SettingImpl.newBuilder("dbms.connector.bolt.connection_keep_alive", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).build();
    @Internal
    @Description(value="The interval between every scheduled keep-alive check on all connections with active queries. Zero duration turns off keep-alive service.")
    public static final Setting<Duration> connection_keep_alive_streaming_scheduling_interval = SettingImpl.newBuilder("dbms.connector.bolt.connection_keep_alive_streaming_scheduling_interval", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).build();
    @Internal
    @Description(value="The total amount of probes to be missed before a connection is considered stale")
    public static final Setting<Integer> connection_keep_alive_probes = SettingImpl.newBuilder("dbms.connector.bolt.connection_keep_alive_probes", SettingValueParsers.INT, 2).build();
    @Internal
    @Description(value="The maximum time to wait for a user to finish authentication before closing the connection.")
    public static final Setting<Duration> unsupported_bolt_unauth_connection_timeout = SettingImpl.newBuilder("dbms.connector.bolt.unsupported_unauth_connection_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(30L)).build();
    @Internal
    @Description(value="The maximum inbound message size in bytes are allowed before a connection is authenticated.")
    public static final Setting<Long> unsupported_bolt_unauth_connection_max_inbound_bytes = SettingImpl.newBuilder("dbms.connector.bolt.unsupported_unauth_max_inbound_bytes", SettingValueParsers.BYTES, ByteUnit.kibiBytes((long)8L)).build();
    @Internal
    @Description(value="The absolute path of the file for use with the Unix Domain Socket based loopback interface. This file must be specified and will be created at runtime and deleted on shutdown.")
    public static final Setting<Path> unsupported_loopback_listen_file = SettingImpl.newBuilder("unsupported.dbms.loopback_file", SettingValueParsers.PATH, null).build();
    @Internal
    @Description(value="Whether or not to delete an existing file for use with the Unix Domain Socket based loopback interface. This improves the handling of the case where a previous hard shutdown was unable to delete the file.")
    public static final Setting<Boolean> unsupported_loopback_delete = SettingImpl.newBuilder("unsupported.dbms.loopback_delete", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable or disable the bolt loopback connector. A user successfully authenticated over this will execute all queries with no security restrictions. This includes overriding the `unsupported.dbms.block_create_drop_database`, `unsupported.dbms.block_start_stop_database` and `unsupported.dbms.upgrade_restriction_enabled` settings.")
    public static final Setting<Boolean> enable_loopback_auth = SettingImpl.newBuilder("unsupported.dbms.loopback_enabled", SettingValueParsers.BOOL, false).build();

    public static enum KeepAliveRequestType {
        ALL,
        STREAMING,
        OFF;

    }
}

